/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Type;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.util.Assert;

class RepositoryConstructorBuilder
implements AotRepositoryConstructorBuilder {
    private final AotRepositoryFragmentMetadata metadata;
    private AotRepositoryConstructorBuilder.ConstructorCustomizer customizer = builder -> {};

    RepositoryConstructorBuilder(AotRepositoryFragmentMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void addParameter(String parameterName, Class<?> type) {
        ResolvableType resolvableType = ResolvableType.forClass(type);
        if (!resolvableType.hasGenerics() || !resolvableType.hasResolvableGenerics()) {
            this.addParameter(parameterName, TypeName.get(type));
            return;
        }
        this.addParameter(parameterName, (TypeName)ParameterizedTypeName.get(type, (Type[])resolvableType.resolveGenerics()));
    }

    @Override
    public void addParameter(String parameterName, TypeName type) {
        this.addParameter(parameterName, type, true);
    }

    @Override
    public void addParameter(String parameterName, TypeName type, boolean createField) {
        this.metadata.addConstructorArgument(parameterName, type, createField ? parameterName : null);
        if (createField) {
            this.metadata.addField(parameterName, type, Modifier.PRIVATE, Modifier.FINAL);
        }
    }

    @Override
    public void customize(AotRepositoryConstructorBuilder.ConstructorCustomizer customizer) {
        Assert.notNull((Object)customizer, (String)"ConstructorCustomizer must not be null");
        this.customizer = customizer;
    }

    public MethodSpec buildConstructor() {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Map.Entry<String, AotRepositoryFragmentMetadata.ConstructorArgument> parameter : this.metadata.getConstructorArguments().entrySet()) {
            builder.addParameter(parameter.getValue().typeName(), parameter.getKey(), new Modifier[0]);
        }
        this.customizer.customize(builder);
        for (Map.Entry<String, AotRepositoryFragmentMetadata.ConstructorArgument> parameter : this.metadata.getConstructorArguments().entrySet()) {
            if (!parameter.getValue().isForLocalField()) continue;
            builder.addStatement("this.$N = $N", new Object[]{parameter.getKey(), parameter.getKey()});
        }
        return builder.build();
    }
}

