/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.grpc;

import io.grpc.ManagedChannelBuilder;
import io.grpc.inprocess.InProcessChannelBuilder;
import java.util.List;
import java.util.Optional;
import org.springframework.cloud.sleuth.brave.instrument.grpc.GrpcManagedChannelBuilderCustomizer;

public class SpringAwareManagedChannelBuilder {
    private List<GrpcManagedChannelBuilderCustomizer> customizers;

    public SpringAwareManagedChannelBuilder(Optional<List<GrpcManagedChannelBuilderCustomizer>> customizers) {
        this.customizers = customizers.orElse(null);
    }

    public ManagedChannelBuilder<?> forAddress(String name, int port) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)name, (int)port);
        this.customize(builder);
        return builder;
    }

    public ManagedChannelBuilder<?> forTarget(String target) {
        ManagedChannelBuilder builder = ManagedChannelBuilder.forTarget((String)target);
        this.customize(builder);
        return builder;
    }

    public ManagedChannelBuilder<?> inProcessChannelBuilder(String serverName) {
        InProcessChannelBuilder builder = InProcessChannelBuilder.forName((String)serverName);
        this.customize((ManagedChannelBuilder<?>)builder);
        return builder;
    }

    private void customize(ManagedChannelBuilder<?> builder) {
        if (this.customizers != null) {
            for (GrpcManagedChannelBuilderCustomizer customizer : this.customizers) {
                customizer.customize(builder);
            }
        }
    }
}

