/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.baggage.BaggageField;
import brave.internal.baggage.BaggageFields;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageInScope;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;

class W3CBaggagePropagator {
    private static final Log log = LogFactory.getLog(W3CBaggagePropagator.class);
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private final BraveBaggageManager braveBaggageManager;
    private final List<String> localFields;

    W3CBaggagePropagator(BraveBaggageManager braveBaggageManager, List<String> localFields) {
        this.braveBaggageManager = braveBaggageManager;
        this.localFields = localFields;
    }

    public List<String> keys() {
        return FIELDS;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (context, carrier) -> {
            BaggageFields extra = (BaggageFields)context.findExtra(BaggageFields.class);
            if (extra == null || extra.getAllFields().isEmpty()) {
                return;
            }
            StringBuilder headerContent = new StringBuilder();
            String[] strings = this.localFields.toArray(new String[0]);
            Map filtered = extra.toMapFilteringFieldNames(strings);
            for (Map.Entry entry : filtered.entrySet()) {
                headerContent.append((String)entry.getKey()).append("=").append((String)entry.getValue());
                headerContent.append(",");
            }
            if (headerContent.length() > 0) {
                headerContent.setLength(headerContent.length() - 1);
                setter.put(carrier, (Object)FIELD, headerContent.toString());
            }
        };
    }

    <R> TraceContextOrSamplingFlags contextWithBaggage(R carrier, TraceContextOrSamplingFlags context, Propagation.Getter<R, String> getter) {
        String baggageHeader = getter.get(carrier, (Object)FIELD);
        if (baggageHeader == null) {
            return context;
        }
        if (baggageHeader.isEmpty()) {
            return context;
        }
        TraceContextOrSamplingFlags.Builder builder = context.toBuilder();
        List<AbstractMap.SimpleEntry<BaggageField, String>> pairs = this.addBaggageToContext(baggageHeader, builder);
        TraceContextOrSamplingFlags built = builder.build();
        pairs.forEach(e -> {
            BaggageField baggage = (BaggageField)e.getKey();
            baggage.updateValue(built, (String)e.getValue());
        });
        return built;
    }

    List<AbstractMap.SimpleEntry<BaggageField, String>> addBaggageToContext(String baggageHeader, TraceContextOrSamplingFlags.Builder builder) {
        String[] entries;
        ArrayList<AbstractMap.SimpleEntry<BaggageField, String>> pairs = new ArrayList<AbstractMap.SimpleEntry<BaggageField, String>>();
        for (String entry : entries = baggageHeader.split(",")) {
            int beginningOfMetadata = entry.indexOf(";");
            if (beginningOfMetadata > 0) {
                entry = entry.substring(0, beginningOfMetadata);
            }
            Object[] keyAndValue = entry.split("=");
            for (int i = 0; i < keyAndValue.length; i += 2) {
                try {
                    String key = keyAndValue[i].trim();
                    String value = keyAndValue[i + 1].trim();
                    BaggageInScope baggage = this.braveBaggageManager.createBaggage(key);
                    BaggageField field = ((BraveBaggageInScope)baggage).unwrap();
                    pairs.add(new AbstractMap.SimpleEntry<BaggageField, String>(field, value));
                    continue;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Exception occurred while trying to parse baggage with key value [" + Arrays.toString(keyAndValue) + "]. Will ignore that entry."), (Throwable)e);
                }
            }
        }
        builder.addExtra((Object)BaggageFields.newFactory(pairs.stream().map(AbstractMap.SimpleEntry::getKey).collect(Collectors.toList()), (int)(pairs.size() * 2)).create());
        return pairs;
    }
}

