/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet.context;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.AotDetector;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.web.context.servlet.ApplicationServletEnvironment;
import org.springframework.boot.web.server.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.boot.web.server.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

class ServletWebServerApplicationContextFactory
implements ApplicationContextFactory {
    ServletWebServerApplicationContextFactory() {
    }

    public @Nullable Class<? extends ConfigurableEnvironment> getEnvironmentType(@Nullable WebApplicationType webApplicationType) {
        return webApplicationType != WebApplicationType.SERVLET ? null : ApplicationServletEnvironment.class;
    }

    public @Nullable ConfigurableEnvironment createEnvironment(@Nullable WebApplicationType webApplicationType) {
        return webApplicationType != WebApplicationType.SERVLET ? null : new ApplicationServletEnvironment();
    }

    public @Nullable ConfigurableApplicationContext create(@Nullable WebApplicationType webApplicationType) {
        return webApplicationType != WebApplicationType.SERVLET ? null : this.createContext();
    }

    private ConfigurableApplicationContext createContext() {
        if (!AotDetector.useGeneratedArtifacts()) {
            return new AnnotationConfigServletWebServerApplicationContext();
        }
        return new ServletWebServerApplicationContext();
    }
}

