/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockitoPostProcessor;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class MockitoTestExecutionListener
extends AbstractTestExecutionListener {
    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.initMocks(testContext);
        this.injectFields(testContext);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (Boolean.TRUE.equals(testContext.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE))) {
            this.initMocks(testContext);
            this.reinjectFields(testContext);
        }
    }

    public int getOrder() {
        return 1950;
    }

    private void initMocks(TestContext testContext) {
        if (this.hasMockitoAnnotations(testContext)) {
            MockitoAnnotations.initMocks((Object)testContext.getTestInstance());
        }
    }

    private boolean hasMockitoAnnotations(TestContext testContext) {
        MockitoAnnotationCollection collector = new MockitoAnnotationCollection();
        ReflectionUtils.doWithFields((Class)testContext.getTestClass(), (ReflectionUtils.FieldCallback)collector);
        return collector.hasAnnotations();
    }

    private void injectFields(TestContext testContext) {
        this.postProcessFields(testContext, new MockitoFieldHandler(){

            @Override
            public void handle(MockitoField mockitoField, MockitoPostProcessor postProcessor) {
                postProcessor.inject(mockitoField.field, mockitoField.target, mockitoField.definition);
            }
        });
    }

    private void reinjectFields(final TestContext testContext) {
        this.postProcessFields(testContext, new MockitoFieldHandler(){

            @Override
            public void handle(MockitoField mockitoField, MockitoPostProcessor postProcessor) {
                ReflectionUtils.makeAccessible((Field)mockitoField.field);
                ReflectionUtils.setField((Field)mockitoField.field, (Object)testContext.getTestInstance(), null);
                postProcessor.inject(mockitoField.field, mockitoField.target, mockitoField.definition);
            }
        });
    }

    private void postProcessFields(TestContext testContext, MockitoFieldHandler handler) {
        DefinitionsParser parser = new DefinitionsParser();
        parser.parse(testContext.getTestClass());
        if (!parser.getDefinitions().isEmpty()) {
            MockitoPostProcessor postProcessor = (MockitoPostProcessor)((Object)testContext.getApplicationContext().getBean(MockitoPostProcessor.class));
            for (Definition definition : parser.getDefinitions()) {
                Field field = parser.getField(definition);
                if (field == null) continue;
                handler.handle(new MockitoField(field, testContext.getTestInstance(), definition), postProcessor);
            }
        }
    }

    private static interface MockitoFieldHandler {
        public void handle(MockitoField var1, MockitoPostProcessor var2);
    }

    private static final class MockitoField {
        private final Field field;
        private final Object target;
        private final Definition definition;

        private MockitoField(Field field, Object instance, Definition definition) {
            this.field = field;
            this.target = instance;
            this.definition = definition;
        }
    }

    private static class MockitoAnnotationCollection
    implements ReflectionUtils.FieldCallback {
        private final Set<Annotation> annotations = new LinkedHashSet<Annotation>();

        private MockitoAnnotationCollection() {
        }

        public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith("org.mockito")) continue;
                this.annotations.add(annotation);
            }
        }

        public boolean hasAnnotations() {
            return !this.annotations.isEmpty();
        }
    }
}

