/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.Metadata;
import org.apache.hadoop.hive.ql.io.orc.MetadataReader;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public interface Reader {
    public long getNumberOfRows();

    public long getRawDataSize();

    public long getRawDataSizeOfColumns(List<String> var1);

    public List<String> getMetadataKeys();

    public ByteBuffer getMetadataValue(String var1);

    public boolean hasMetadataValue(String var1);

    public CompressionKind getCompression();

    public int getCompressionSize();

    public int getRowIndexStride();

    public List<StripeInformation> getStripes();

    public ObjectInspector getObjectInspector();

    public long getContentLength();

    public ColumnStatistics[] getStatistics();

    public Metadata getMetadata() throws IOException;

    public List<OrcProto.Type> getTypes();

    public OrcFile.Version getFileVersion();

    public OrcFile.WriterVersion getWriterVersion();

    public RecordReader rows() throws IOException;

    public RecordReader rowsOptions(Options var1) throws IOException;

    public RecordReader rows(boolean[] var1) throws IOException;

    public RecordReader rows(long var1, long var3, boolean[] var5) throws IOException;

    public RecordReader rows(long var1, long var3, boolean[] var5, SearchArgument var6, String[] var7) throws IOException;

    public MetadataReader metadata() throws IOException;

    public static class Options {
        private boolean[] include;
        private long offset = 0L;
        private long length = Long.MAX_VALUE;
        private SearchArgument sarg = null;
        private String[] columnNames = null;

        public Options include(boolean[] include) {
            this.include = include;
            return this;
        }

        public Options range(long offset, long length) {
            this.offset = offset;
            this.length = length;
            return this;
        }

        public Options searchArgument(SearchArgument sarg, String[] columnNames) {
            this.sarg = sarg;
            this.columnNames = columnNames;
            return this;
        }

        public boolean[] getInclude() {
            return this.include;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getLength() {
            return this.length;
        }

        public SearchArgument getSearchArgument() {
            return this.sarg;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public long getMaxOffset() {
            long result = this.offset + this.length;
            if (result < 0L) {
                result = Long.MAX_VALUE;
            }
            return result;
        }

        public Options clone() {
            Options result = new Options();
            result.include = this.include;
            result.offset = this.offset;
            result.length = this.length;
            result.sarg = this.sarg;
            result.columnNames = this.columnNames;
            return result;
        }

        public String toString() {
            int i;
            StringBuilder buffer = new StringBuilder();
            buffer.append("{include: ");
            if (this.include == null) {
                buffer.append("null");
            } else {
                buffer.append("[");
                for (i = 0; i < this.include.length; ++i) {
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.include[i]);
                }
                buffer.append("]");
            }
            buffer.append(", offset: ");
            buffer.append(this.offset);
            buffer.append(", length: ");
            buffer.append(this.length);
            if (this.sarg != null) {
                buffer.append(", sarg: ");
                buffer.append(this.sarg.toString());
                buffer.append(", columns: [");
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append("'");
                    buffer.append(this.columnNames[i]);
                    buffer.append("'");
                }
                buffer.append("]");
            }
            buffer.append("}");
            return buffer.toString();
        }
    }
}

