/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal.shaded.okhttp.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.sonarsource.scanner.api.internal.shaded.okhttp.internal.http2.ErrorCode;
import org.sonarsource.scanner.api.internal.shaded.okhttp.internal.http2.Header;
import org.sonarsource.scanner.api.internal.shaded.okhttp.internal.http2.Http2Connection;
import org.sonarsource.scanner.api.internal.shaded.okhttp.internal.http2.StreamResetException;
import org.sonarsource.scanner.api.internal.shaded.okio.AsyncTimeout;
import org.sonarsource.scanner.api.internal.shaded.okio.Buffer;
import org.sonarsource.scanner.api.internal.shaded.okio.BufferedSource;
import org.sonarsource.scanner.api.internal.shaded.okio.Sink;
import org.sonarsource.scanner.api.internal.shaded.okio.Source;
import org.sonarsource.scanner.api.internal.shaded.okio.Timeout;

public final class Http2Stream {
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    final int id;
    final Http2Connection connection;
    private final List<Header> requestHeaders;
    private List<Header> responseHeaders;
    private boolean hasResponseHeaders;
    private final FramingSource source;
    final FramingSink sink;
    final StreamTimeout readTimeout = new StreamTimeout();
    final StreamTimeout writeTimeout = new StreamTimeout();
    ErrorCode errorCode = null;

    Http2Stream(int id, Http2Connection connection, boolean outFinished, boolean inFinished, List<Header> requestHeaders) {
        if (connection == null) {
            throw new NullPointerException("connection == null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders == null");
        }
        this.id = id;
        this.connection = connection;
        this.bytesLeftInWriteWindow = connection.peerSettings.getInitialWindowSize();
        this.source = new FramingSource(connection.okHttpSettings.getInitialWindowSize());
        this.sink = new FramingSink();
        this.source.finished = inFinished;
        this.sink.finished = outFinished;
        this.requestHeaders = requestHeaders;
    }

    public int getId() {
        return this.id;
    }

    public synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.finished && !this.source.closed || !this.sink.finished && !this.sink.closed || !this.hasResponseHeaders;
    }

    public boolean isLocallyInitiated() {
        boolean streamIsClient = (this.id & 1) == 1;
        return this.connection.client == streamIsClient;
    }

    public Http2Connection getConnection() {
        return this.connection;
    }

    public List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public synchronized List<Header> takeResponseHeaders() throws IOException {
        if (!this.isLocallyInitiated()) {
            throw new IllegalStateException("servers cannot read response headers");
        }
        this.readTimeout.enter();
        try {
            while (this.responseHeaders == null && this.errorCode == null) {
                this.waitForIo();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        List<Header> result = this.responseHeaders;
        if (result != null) {
            this.responseHeaders = null;
            return result;
        }
        throw new StreamResetException(this.errorCode);
    }

    public synchronized ErrorCode getErrorCode() {
        return this.errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponseHeaders(List<Header> responseHeaders, boolean out) throws IOException {
        assert (!Thread.holdsLock(this));
        if (responseHeaders == null) {
            throw new NullPointerException("responseHeaders == null");
        }
        boolean outFinished = false;
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.hasResponseHeaders = true;
            if (!out) {
                this.sink.finished = true;
                outFinished = true;
            }
        }
        this.connection.writeSynReply(this.id, outFinished, responseHeaders);
        if (outFinished) {
            this.connection.flush();
        }
    }

    public Timeout readTimeout() {
        return this.readTimeout;
    }

    public Timeout writeTimeout() {
        return this.writeTimeout;
    }

    public Source getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!this.hasResponseHeaders && !this.isLocallyInitiated()) {
                throw new IllegalStateException("reply before requesting the sink");
            }
        }
        return this.sink;
    }

    public void close(ErrorCode rstStatusCode) throws IOException {
        if (!this.closeInternal(rstStatusCode)) {
            return;
        }
        this.connection.writeSynReset(this.id, rstStatusCode);
    }

    public void closeLater(ErrorCode errorCode) {
        if (!this.closeInternal(errorCode)) {
            return;
        }
        this.connection.writeSynResetLater(this.id, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal(ErrorCode errorCode) {
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (this.errorCode != null) {
                return false;
            }
            if (this.source.finished && this.sink.finished) {
                return false;
            }
            this.errorCode = errorCode;
            this.notifyAll();
        }
        this.connection.removeStream(this.id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHeaders(List<Header> headers) {
        assert (!Thread.holdsLock(this));
        boolean open = true;
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.hasResponseHeaders = true;
            if (this.responseHeaders == null) {
                this.responseHeaders = headers;
                open = this.isOpen();
                this.notifyAll();
            } else {
                ArrayList<Header> newHeaders = new ArrayList<Header>();
                newHeaders.addAll(this.responseHeaders);
                newHeaders.add(null);
                newHeaders.addAll(headers);
                this.responseHeaders = newHeaders;
            }
        }
        if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    void receiveData(BufferedSource in, int length) throws IOException {
        assert (!Thread.holdsLock(this));
        this.source.receive(in, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveFin() {
        boolean open;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            this.source.finished = true;
            open = this.isOpen();
            this.notifyAll();
        }
        if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    synchronized void receiveRstStream(ErrorCode errorCode) {
        if (this.errorCode == null) {
            this.errorCode = errorCode;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStreamIfNecessary() throws IOException {
        boolean open;
        boolean cancel;
        assert (!Thread.holdsLock(this));
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            cancel = !this.source.finished && this.source.closed && (this.sink.finished || this.sink.closed);
            open = this.isOpen();
        }
        if (cancel) {
            this.close(ErrorCode.CANCEL);
        } else if (!open) {
            this.connection.removeStream(this.id);
        }
    }

    void addBytesToWriteWindow(long delta) {
        this.bytesLeftInWriteWindow += delta;
        if (delta > 0L) {
            this.notifyAll();
        }
    }

    void checkOutNotClosed() throws IOException {
        if (this.sink.closed) {
            throw new IOException("stream closed");
        }
        if (this.sink.finished) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            throw new StreamResetException(this.errorCode);
        }
    }

    void waitForIo() throws InterruptedIOException {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    class StreamTimeout
    extends AsyncTimeout {
        StreamTimeout() {
        }

        @Override
        protected void timedOut() {
            Http2Stream.this.closeLater(ErrorCode.CANCEL);
        }

        @Override
        protected IOException newTimeoutException(IOException cause) {
            SocketTimeoutException socketTimeoutException = new SocketTimeoutException("timeout");
            if (cause != null) {
                socketTimeoutException.initCause(cause);
            }
            return socketTimeoutException;
        }

        public void exitAndThrowIfTimedOut() throws IOException {
            if (this.exit()) {
                throw this.newTimeoutException(null);
            }
        }
    }

    final class FramingSink
    implements Sink {
        private static final long EMIT_BUFFER_SIZE = 16384L;
        private final Buffer sendBuffer = new Buffer();
        boolean closed;
        boolean finished;

        FramingSink() {
        }

        @Override
        public void write(Buffer source, long byteCount) throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            this.sendBuffer.write(source, byteCount);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitFrame(boolean outFinished) throws IOException {
            long toWrite;
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.writeTimeout.enter();
                try {
                    while (Http2Stream.this.bytesLeftInWriteWindow <= 0L && !this.finished && !this.closed && Http2Stream.this.errorCode == null) {
                        Http2Stream.this.waitForIo();
                    }
                }
                finally {
                    Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
                }
                Http2Stream.this.checkOutNotClosed();
                toWrite = Math.min(Http2Stream.this.bytesLeftInWriteWindow, this.sendBuffer.size());
                Http2Stream.this.bytesLeftInWriteWindow -= toWrite;
            }
            Http2Stream.this.writeTimeout.enter();
            try {
                Http2Stream.this.connection.writeData(Http2Stream.this.id, outFinished && toWrite == this.sendBuffer.size(), this.sendBuffer, toWrite);
            }
            finally {
                Http2Stream.this.writeTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                Http2Stream.this.checkOutNotClosed();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                Http2Stream.this.connection.flush();
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.writeTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                if (this.closed) {
                    return;
                }
            }
            if (!Http2Stream.this.sink.finished) {
                if (this.sendBuffer.size() > 0L) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else {
                    Http2Stream.this.connection.writeData(Http2Stream.this.id, true, null, 0L);
                }
            }
            http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
            }
            Http2Stream.this.connection.flush();
            Http2Stream.this.cancelStreamIfNecessary();
        }
    }

    private final class FramingSource
    implements Source {
        private final Buffer receiveBuffer = new Buffer();
        private final Buffer readBuffer = new Buffer();
        private final long maxByteCount;
        boolean closed;
        boolean finished;

        FramingSource(long maxByteCount) {
            this.maxByteCount = maxByteCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long read(Buffer sink, long byteCount) throws IOException {
            long read;
            if (byteCount < 0L) {
                throw new IllegalArgumentException("byteCount < 0: " + byteCount);
            }
            Object object = Http2Stream.this;
            synchronized (object) {
                this.waitUntilReadable();
                this.checkNotClosed();
                if (this.readBuffer.size() == 0L) {
                    return -1L;
                }
                read = this.readBuffer.read(sink, Math.min(byteCount, this.readBuffer.size()));
                Http2Stream.this.unacknowledgedBytesRead += read;
                if (Http2Stream.this.unacknowledgedBytesRead >= (long)(Http2Stream.this.connection.okHttpSettings.getInitialWindowSize() / 2)) {
                    Http2Stream.this.connection.writeWindowUpdateLater(Http2Stream.this.id, Http2Stream.this.unacknowledgedBytesRead);
                    Http2Stream.this.unacknowledgedBytesRead = 0L;
                }
            }
            object = Http2Stream.this.connection;
            synchronized (object) {
                Http2Stream.this.connection.unacknowledgedBytesRead += read;
                if (Http2Stream.this.connection.unacknowledgedBytesRead >= (long)(Http2Stream.this.connection.okHttpSettings.getInitialWindowSize() / 2)) {
                    Http2Stream.this.connection.writeWindowUpdateLater(0, Http2Stream.this.connection.unacknowledgedBytesRead);
                    Http2Stream.this.connection.unacknowledgedBytesRead = 0L;
                }
            }
            return read;
        }

        private void waitUntilReadable() throws IOException {
            Http2Stream.this.readTimeout.enter();
            try {
                while (this.readBuffer.size() == 0L && !this.finished && !this.closed && Http2Stream.this.errorCode == null) {
                    Http2Stream.this.waitForIo();
                }
            }
            finally {
                Http2Stream.this.readTimeout.exitAndThrowIfTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void receive(BufferedSource in, long byteCount) throws IOException {
            assert (!Thread.holdsLock(Http2Stream.this));
            while (byteCount > 0L) {
                boolean flowControlError;
                boolean finished;
                Http2Stream http2Stream = Http2Stream.this;
                synchronized (http2Stream) {
                    finished = this.finished;
                    flowControlError = byteCount + this.readBuffer.size() > this.maxByteCount;
                }
                if (flowControlError) {
                    in.skip(byteCount);
                    Http2Stream.this.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (finished) {
                    in.skip(byteCount);
                    return;
                }
                long read = in.read(this.receiveBuffer, byteCount);
                if (read == -1L) {
                    throw new EOFException();
                }
                byteCount -= read;
                Http2Stream http2Stream2 = Http2Stream.this;
                synchronized (http2Stream2) {
                    boolean wasEmpty = this.readBuffer.size() == 0L;
                    this.readBuffer.writeAll(this.receiveBuffer);
                    if (wasEmpty) {
                        Http2Stream.this.notifyAll();
                    }
                }
            }
        }

        @Override
        public Timeout timeout() {
            return Http2Stream.this.readTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Http2Stream http2Stream = Http2Stream.this;
            synchronized (http2Stream) {
                this.closed = true;
                this.readBuffer.clear();
                Http2Stream.this.notifyAll();
            }
            Http2Stream.this.cancelStreamIfNecessary();
        }

        private void checkNotClosed() throws IOException {
            if (this.closed) {
                throw new IOException("stream closed");
            }
            if (Http2Stream.this.errorCode != null) {
                throw new StreamResetException(Http2Stream.this.errorCode);
            }
        }
    }
}

