/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.lightningcsv.parser;

import java.io.IOException;
import org.simpleflatmapper.lightningcsv.parser.AbstractCharConsumer;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.lightningcsv.parser.CellPreProcessor;
import org.simpleflatmapper.lightningcsv.parser.CharBuffer;
import org.simpleflatmapper.lightningcsv.parser.TextFormat;

public final class ConfigurableCharConsumer
extends AbstractCharConsumer {
    public static final int CONTAINS_ESCAPED_CHAR = 256;
    public static final int ESCAPED = 128;
    public static final int ROW_DATA = 64;
    public static final int COMMENTED = 32;
    public static final int CELL_DATA = 16;
    public static final int QUOTED = 8;
    public static final int LAST_CHAR_WAS_SEPARATOR = 4;
    public static final int LAST_CHAR_WAS_CR = 2;
    public static final int QUOTED_AREA = 1;
    public static final int NONE = 0;
    private static final int TURN_OFF_LAST_CHAR_MASK = -7;
    private static final int TURN_OFF_QUOTED_AREA = -2;
    private static final int TURN_OFF_ESCAPED = -129;
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final char COMMENT = '#';
    private final CharBuffer csvBuffer;
    private final TextFormat textFormat;
    private final CellPreProcessor cellPreProcessor;
    private int _currentIndex = 0;
    private int _currentState = 0;

    public static AbstractCharConsumer of(CharBuffer csvBuffer, TextFormat textFormat, CellPreProcessor cellPreProcessor) {
        return new ConfigurableCharConsumer(csvBuffer, textFormat, cellPreProcessor);
    }

    public ConfigurableCharConsumer(CharBuffer csvBuffer, TextFormat textFormat, CellPreProcessor cellPreProcessor) {
        this.csvBuffer = csvBuffer;
        this._currentIndex = csvBuffer.rowStartMark;
        this.cellPreProcessor = cellPreProcessor;
        this.textFormat = textFormat;
    }

    @Override
    public CharBuffer charBuffer() {
        return this.csvBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        notIgnoreLeadingSpace = this.ignoreLeadingSpace() == false;
        yamlComment = this.yamlComment();
        escapeChar = this.escapeChar();
        separatorChar = this.separatorChar();
        quoteChar = this.quoteChar();
        separatorFingerPrint = separatorChar & 13 & 10;
        separatorFingerPrintMask = separatorFingerPrint | ~separatorChar & -14 & -11;
        currentState = this._currentState;
        currentIndex = this._currentIndex;
        chars = this.csvBuffer.buffer;
        bufferSize = this.csvBuffer.bufferSize;
        cellPreProcessor = this.cellPreProcessor;
        if (bufferSize > chars.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
lbl15:
        // 3 sources

        try {
            block5: while (currentIndex < bufferSize) {
                block24: {
                    if ((currentState & 33) != 0) break block24;
                    block6: while (currentIndex < bufferSize) {
                        character = chars[currentIndex];
                        cellEnd = currentIndex++;
                        if (character == separatorChar) {
                            cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.cellStartMark = currentIndex;
                            currentState = 68;
                            continue;
                        }
                        if (character == '\n') {
                            if ((currentState & 2) == 0) {
                                cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, cellEnd, cellConsumer, currentState);
                                cellConsumer.endOfRow();
                            }
                            this.markEndOfRow(currentIndex);
                            currentState = 0;
                            continue;
                        }
                        if (character == '\r') {
                            cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, cellEnd, cellConsumer, currentState);
                            cellConsumer.endOfRow();
                            this.markEndOfRow(currentIndex);
                            currentState = 2;
                            continue;
                        }
                        if ((currentState & 24) == 16) {
                            while (currentIndex < bufferSize) {
                                c = chars[currentIndex];
                                ce = currentIndex++;
                                if ((c & separatorFingerPrintMask) != separatorFingerPrint || c != separatorChar && c != '\n' && c != '\r') continue;
                                cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, ce, cellConsumer, currentState);
                                if (c == separatorChar) {
                                    currentState = 68;
                                } else {
                                    currentState = c == '\n' ? 0 : 2;
                                    cellConsumer.endOfRow();
                                    this.csvBuffer.rowStartMark = currentIndex;
                                }
                                this.csvBuffer.cellStartMark = currentIndex;
                                continue block6;
                            }
                            return;
                        }
                        if (((currentState ^ 16) & 24) != 0 && character == quoteChar) {
                            currentState = 9 | (currentState & 8) << 5;
                            continue block5;
                        }
                        if (yamlComment && (currentState & 80) == 0 && character == '#') {
                            currentState |= 32;
                            continue block5;
                        }
                        currentState &= -7;
                        if (!notIgnoreLeadingSpace && character == ' ') continue;
                        currentState |= 16;
                    }
                    ** GOTO lbl15
                }
                if ((currentState & 1) != 0) {
                    while (currentIndex < bufferSize) {
                        if ((currentState & 128) == 0) {
                            if ((c = chars[currentIndex++]) == quoteChar) {
                                currentState &= -2;
                                continue block5;
                            }
                            if (c != escapeChar) continue;
                            currentState |= 384;
                            continue;
                        }
                        currentState &= -129;
                    }
                    return;
                }
                nextEndOfLineChar = this.findNexEndOfLineChar(chars, currentIndex, bufferSize);
                if (nextEndOfLineChar != -1) {
                    cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, nextEndOfLineChar, cellConsumer, currentState);
                    cellConsumer.endOfRow();
                    currentIndex = nextEndOfLineChar + 1;
                    this.markEndOfRow(currentIndex);
                    currentState = chars[nextEndOfLineChar] == '\r' ? 2 : 0;
                    continue;
                }
                currentIndex = bufferSize;
            }
        }
        finally {
            this._currentState = currentState;
            this._currentIndex = currentIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final boolean consumeToNextRow(CellConsumer cellConsumer) {
        notIgnoreLeadingSpace = this.ignoreLeadingSpace() == false;
        yamlComment = this.yamlComment();
        escapeChar = this.escapeChar();
        separatorChar = this.separatorChar();
        quoteChar = this.quoteChar();
        separatorFingerPrint = separatorChar & 13 & 10;
        separatorFingerPrintMask = separatorFingerPrint | ~separatorChar & -14 & -11;
        currentState = this._currentState;
        currentIndex = this._currentIndex;
        chars = this.csvBuffer.buffer;
        bufferSize = this.csvBuffer.bufferSize;
        cellPreProcessor = this.cellPreProcessor;
        if (bufferSize > chars.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
lbl15:
        // 3 sources

        try {
            block9: while (currentIndex < bufferSize) {
                block31: {
                    if ((currentState & 33) != 0) break block31;
                    block10: while (currentIndex < bufferSize) {
                        character = chars[currentIndex];
                        cellEnd = currentIndex++;
                        if (character == separatorChar) {
                            cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, cellEnd, cellConsumer, currentState);
                            this.csvBuffer.cellStartMark = currentIndex;
                            currentState = 68;
                            continue;
                        }
                        if (character == '\n') {
                            if ((currentState & 2) == 0) {
                                cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, cellEnd, cellConsumer, currentState);
                                if (cellConsumer.endOfRow()) {
                                    this.markEndOfRow(currentIndex);
                                    currentState = 0;
                                    var16_16 = true;
                                    return var16_16;
                                }
                            }
                            this.markEndOfRow(currentIndex);
                            currentState = 0;
                            continue;
                        }
                        if (character == '\r') {
                            cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, cellEnd, cellConsumer, currentState);
                            currentState = 2;
                            if (cellConsumer.endOfRow()) {
                                this.markEndOfRow(currentIndex);
                                var16_16 = true;
                                return var16_16;
                            }
                            this.markEndOfRow(currentIndex);
                            continue;
                        }
                        if ((currentState & 24) == 16) {
                            while (currentIndex < bufferSize) {
                                c = chars[currentIndex];
                                ce = currentIndex++;
                                if ((c & separatorFingerPrintMask) != separatorFingerPrint || c != separatorChar && c != '\n' && c != '\r') continue;
                                cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, ce, cellConsumer, currentState);
                                if (c == separatorChar) {
                                    currentState = 68;
                                } else {
                                    v0 = currentState = c == '\n' ? 0 : 2;
                                    if (cellConsumer.endOfRow()) {
                                        this.markEndOfRow(currentIndex);
                                        var18_18 = true;
                                        return var18_18;
                                    }
                                    this.csvBuffer.rowStartMark = currentIndex;
                                }
                                this.csvBuffer.cellStartMark = currentIndex;
                                continue block10;
                            }
                            var16_16 = false;
                            return var16_16;
                        }
                        if (((currentState ^ 16) & 24) != 0 && character == quoteChar) {
                            currentState = 9 | (currentState & 8) << 5;
                            continue block9;
                        }
                        if ((currentState & 80) == 0 && yamlComment && character == '#') {
                            currentState |= 32;
                            continue block9;
                        }
                        currentState &= -7;
                        if (!notIgnoreLeadingSpace && character == ' ') continue;
                        currentState |= 16;
                    }
                    ** GOTO lbl15
                }
                if ((currentState & 1) != 0) {
                    while (currentIndex < bufferSize) {
                        if ((currentState & 128) == 0) {
                            if ((c = chars[currentIndex++]) == quoteChar) {
                                currentState &= -2;
                                continue block9;
                            }
                            if (c != escapeChar) continue;
                            currentState |= 384;
                            continue;
                        }
                        currentState &= -129;
                    }
                    c = '\u0000';
                    return (boolean)c;
                }
                nextEndOfLineChar = this.findNexEndOfLineChar(chars, currentIndex, bufferSize);
                if (nextEndOfLineChar != -1) {
                    currentIndex = nextEndOfLineChar + 1;
                    cellPreProcessor.newCell(chars, this.csvBuffer.cellStartMark, nextEndOfLineChar, cellConsumer, currentState);
                    v1 = currentState = chars[nextEndOfLineChar] == '\r' ? 2 : 0;
                    if (cellConsumer.endOfRow()) {
                        this.markEndOfRow(currentIndex);
                        var15_15 = true;
                        return var15_15;
                    }
                    this.markEndOfRow(currentIndex);
                    continue;
                }
                currentIndex = bufferSize;
            }
            var14_14 = false;
            return var14_14;
        }
        finally {
            this._currentState = currentState;
            this._currentIndex = currentIndex;
        }
    }

    private void markEndOfRow(int currentIndex) {
        CharBuffer csvBuffer = this.csvBuffer;
        csvBuffer.cellStartMark = currentIndex;
        csvBuffer.rowStartMark = currentIndex;
    }

    private char quoteChar() {
        return this.textFormat.quoteChar;
    }

    private boolean yamlComment() {
        return this.textFormat.yamlComment;
    }

    private char separatorChar() {
        return this.textFormat.separatorChar;
    }

    private char escapeChar() {
        return this.textFormat.escapeChar;
    }

    private boolean ignoreLeadingSpace() {
        return this.cellPreProcessor.ignoreLeadingSpace();
    }

    private int findNexEndOfLineChar(char[] chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c != '\r' && c != '\n') continue;
            return i;
        }
        return -1;
    }

    @Override
    public final void finish(CellConsumer cellConsumer) {
        if (this.hasUnconsumedData() || (this._currentState & 4) != 0) {
            this.cellPreProcessor.newCell(this.csvBuffer.buffer, this.csvBuffer.cellStartMark, this._currentIndex, cellConsumer, this._currentState);
            this.csvBuffer.cellStartMark = this._currentIndex + 1;
            this._currentState = 0;
        }
        cellConsumer.end();
    }

    private boolean hasUnconsumedData() {
        return this._currentIndex > this.csvBuffer.cellStartMark;
    }

    @Override
    public boolean shiftAndRead(boolean keepRow) throws IOException {
        if (this.csvBuffer.isConstant()) {
            return false;
        }
        int shiftFrom = keepRow ? this.csvBuffer.rowStartMark : Math.min(this.csvBuffer.cellStartMark, this.csvBuffer.bufferSize);
        boolean b = this.csvBuffer.shiftAndRead(shiftFrom);
        this._currentIndex -= shiftFrom;
        return b;
    }
}

