/* *##%
 * Copyright (c) 2009 ruchaud. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty.jms;

import java.io.Serializable;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import static org.sharengo.wikitty.jms.WikittyJMSUtil.*;
import org.apache.activemq.command.ActiveMQObjectMessage;

/**
 * @author ruchaud
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public class WikittyActionMessage {

    protected HashMap<String, Serializable> parameters;
    protected String action;

    public WikittyActionMessage() throws JMSException {
        parameters = new HashMap<String, Serializable>();
    }

    public void setAction(String action) throws JMSException {
        this.action = action;
    }

    public String getAction() throws JMSException {
        return action;
    }

    public void addParameter(String name, Serializable value) {
        parameters.put(name, value);
    }

    public Serializable getParameter(String name) {
        Serializable result = parameters.get(name);
        return result;
    }

    public static ObjectMessage createSendMessage(WikittyActionMessage actionMessage) throws JMSException {
        ObjectMessage message = new ActiveMQObjectMessage();
        message.setStringProperty(PARAM_ACTION, actionMessage.action);
        message.setObject(actionMessage.parameters);
        return message;
    }

    public static WikittyActionMessage createReceiveMessage(ObjectMessage message) throws JMSException {
        WikittyActionMessage actionMessage = new WikittyActionMessage();
        actionMessage.action = message.getStringProperty(PARAM_ACTION);
        actionMessage.parameters = (HashMap<String, Serializable>) message.getObject();
        return actionMessage;
    }
}
