package org.sharengo.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TreeNodeImpl extends BusinessEntityWikitty implements TreeNode {

    private static final long serialVersionUID = 1204790258L;

    static final protected List<WikittyExtension> extensions;
    static final public WikittyExtension extensionTreeNode =
        new WikittyExtension(EXT_TREENODE, "1.0", null,
		    WikittyUtil.buildFieldMapExtension(
				"String name unique",
				"Wikitty parent unique",
				"String children[0-*] unique"));
    static {
        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        // EC-20100420 add current extension after parent ones
        // if current is loaded before required extension
        // load failed because required extension is missing
        exts.add(extensionTreeNode);

        extensions = Collections.unmodifiableList(exts);
    }

	public TreeNodeImpl() {
		super();
	}

    public TreeNodeImpl(BusinessEntityWikitty wi) {
		super(wi.getWikitty());
	}

 	public TreeNodeImpl(Wikitty wi) {
		super(wi);
	}


    public void setName(String name) {
        getWikitty().setField(EXT_TREENODE, "name", name);
    }

    public String getName() {
        String result = getWikitty().getFieldAsString(EXT_TREENODE, "name");
        return result;
    }


    public void setParent(String parent) {
        getWikitty().setField(EXT_TREENODE, "parent", parent);
    }

    public String getParent() {
        String result = getWikitty().getFieldAsString(EXT_TREENODE, "parent");
        return result;
    }

    public Set<String> getChildren() {
        Set<String> result = getWikitty().getFieldAsSet(EXT_TREENODE, "children", String.class);
        return result;
    }

    public void addChildren(String element) {
        getWikitty().addToField(EXT_TREENODE, "children", element);
    }
    
    public void removeChildren(String element) {
        getWikitty().removeFromField(EXT_TREENODE, "children", element);
    }
    
    public void clearChildren() {
        getWikitty().clearField(EXT_TREENODE, "children");
    }

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
    }


} //TreeNodeImpl
