package org.sharengo.wikitty;

import java.util.HashMap;
import java.util.Map;
import org.sharengo.wikitty.FieldType.TYPE;

public class FieldFactory {
    
    private ExtensionFactory parentFactory;
    private String fieldName; 
    private TYPE type;
    private int minOccur = 0, maxOccur = 1; 
    private boolean unique = false;
    private Map<String, String> tagValues = new HashMap<String, String>();
    
    public FieldFactory(ExtensionFactory parentFactory, String fieldName, TYPE type) {
        this.parentFactory = parentFactory;
        this.fieldName = fieldName;
        this.type = type;
    }
    
    public FieldFactory addField(String name, TYPE type) {
        append();
        return parentFactory.addField(name, type);
    }
    
    public WikittyExtension extension() {
        append();
        return parentFactory.extension();
    }
    
    private void append() {
        FieldType fieldType = new FieldType(type, minOccur, maxOccur, unique, minOccur > 0);
        for (Map.Entry<String, String> entry : tagValues.entrySet()) {
            String tag = entry.getKey();
            String value = entry.getValue();
            fieldType.addTagValue(tag, value);
        }
        parentFactory.add(fieldName, fieldType);
    }
    
    public FieldFactory maxOccur(int max) {
        maxOccur = max;
        return this;
    }
    
    public FieldFactory minOccur(int min) {
        minOccur = min;
        return this;
    }
    
    public FieldFactory unique() {
        unique = true;
        return this;
    }

    public FieldFactory addTagValue(String tag, String value) {
        tagValues.put(tag, value);
        return this;
    }

}
