/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.collect.Lists;
import java.util.List;
import org.openqa.selenium.internal.seleniumemulation.FunctionDeclaration;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;
import org.openqa.selenium.internal.seleniumemulation.ScriptMutator;
import org.openqa.selenium.internal.seleniumemulation.SeleniumMutator;
import org.openqa.selenium.internal.seleniumemulation.VariableDeclaration;

public class CompoundMutator
implements ScriptMutator {
    private final List<ScriptMutator> mutators = Lists.newArrayList();

    public CompoundMutator(String baseUrl) {
        this.addMutator(new VariableDeclaration("selenium", "var selenium = {};"));
        this.addMutator(new VariableDeclaration("selenium.browserbot", "selenium.browserbot = {};"));
        this.addMutator(new VariableDeclaration("selenium.browserbot.baseUrl", "selenium.browserbot.baseUrl = '" + baseUrl + "';"));
        this.addMutator(new FunctionDeclaration("selenium.page", "if (!selenium.browserbot) { selenium.browserbot = {} }; return selenium.browserbot;"));
        this.addMutator(new FunctionDeclaration("selenium.browserbot.getCurrentWindow", "return window;"));
        this.addMutator(new FunctionDeclaration("selenium.page().getCurrentWindow", "return window;"));
        this.addMutator(new FunctionDeclaration("selenium.browserbot.getDocument", "return document;"));
        this.addMutator(new FunctionDeclaration("selenium.page().getDocument", "return document;"));
        JavascriptLibrary library = new JavascriptLibrary();
        this.addMutator(new SeleniumMutator("selenium.isElementPresent", library.getSeleniumScript("isElementPresent.js")));
        this.addMutator(new SeleniumMutator("selenium.isTextPresent", library.getSeleniumScript("isTextPresent.js")));
        this.addMutator(new SeleniumMutator("selenium.isVisible", library.getSeleniumScript("isVisible.js")));
        this.addMutator(new SeleniumMutator("selenium.browserbot.findElement", library.getSeleniumScript("findElement.js")));
    }

    public void addMutator(ScriptMutator mutator) {
        this.mutators.add(mutator);
    }

    public void mutate(String script, StringBuilder outputTo) {
        StringBuilder nested = new StringBuilder();
        for (ScriptMutator mutator : this.mutators) {
            mutator.mutate(script, nested);
        }
        nested.append("").append(script);
        outputTo.append("return eval('");
        outputTo.append(this.escape(nested.toString()));
        outputTo.append("');");
    }

    private String escape(String escapee) {
        return escapee.replace("\\", "\\\\").replace("\n", "\\n").replace("'", "\\'");
    }
}

