/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.storage.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v144.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v144.page.model.FrameId;
import org.openqa.selenium.devtools.v144.storage.model.SharedStorageAccessMethod;
import org.openqa.selenium.devtools.v144.storage.model.SharedStorageAccessParams;
import org.openqa.selenium.devtools.v144.storage.model.SharedStorageAccessScope;
import org.openqa.selenium.json.JsonInput;

public class SharedStorageAccessed {
    private final TimeSinceEpoch accessTime;
    private final SharedStorageAccessScope scope;
    private final SharedStorageAccessMethod method;
    private final FrameId mainFrameId;
    private final String ownerOrigin;
    private final String ownerSite;
    private final SharedStorageAccessParams params;

    public SharedStorageAccessed(TimeSinceEpoch accessTime, SharedStorageAccessScope scope, SharedStorageAccessMethod method, FrameId mainFrameId, String ownerOrigin, String ownerSite, SharedStorageAccessParams params) {
        this.accessTime = Objects.requireNonNull(accessTime, "accessTime is required");
        this.scope = Objects.requireNonNull(scope, "scope is required");
        this.method = Objects.requireNonNull(method, "method is required");
        this.mainFrameId = Objects.requireNonNull(mainFrameId, "mainFrameId is required");
        this.ownerOrigin = Objects.requireNonNull(ownerOrigin, "ownerOrigin is required");
        this.ownerSite = Objects.requireNonNull(ownerSite, "ownerSite is required");
        this.params = Objects.requireNonNull(params, "params is required");
    }

    public TimeSinceEpoch getAccessTime() {
        return this.accessTime;
    }

    public SharedStorageAccessScope getScope() {
        return this.scope;
    }

    public SharedStorageAccessMethod getMethod() {
        return this.method;
    }

    public FrameId getMainFrameId() {
        return this.mainFrameId;
    }

    public String getOwnerOrigin() {
        return this.ownerOrigin;
    }

    public String getOwnerSite() {
        return this.ownerSite;
    }

    public SharedStorageAccessParams getParams() {
        return this.params;
    }

    private static SharedStorageAccessed fromJson(JsonInput input) {
        TimeSinceEpoch accessTime = null;
        SharedStorageAccessScope scope = null;
        SharedStorageAccessMethod method = null;
        FrameId mainFrameId = null;
        String ownerOrigin = null;
        String ownerSite = null;
        SharedStorageAccessParams params = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "accessTime": {
                    accessTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block18;
                }
                case "scope": {
                    scope = (SharedStorageAccessScope)((Object)input.read(SharedStorageAccessScope.class));
                    continue block18;
                }
                case "method": {
                    method = (SharedStorageAccessMethod)((Object)input.read(SharedStorageAccessMethod.class));
                    continue block18;
                }
                case "mainFrameId": {
                    mainFrameId = (FrameId)input.read(FrameId.class);
                    continue block18;
                }
                case "ownerOrigin": {
                    ownerOrigin = input.nextString();
                    continue block18;
                }
                case "ownerSite": {
                    ownerSite = input.nextString();
                    continue block18;
                }
                case "params": {
                    params = (SharedStorageAccessParams)input.read(SharedStorageAccessParams.class);
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStorageAccessed(accessTime, scope, method, mainFrameId, ownerOrigin, ownerSite, params);
    }
}

