/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.fetch.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum RequestStage {
    REQUEST("Request"),
    RESPONSE("Response");

    private String value;

    private RequestStage(String value) {
        this.value = value;
    }

    public static RequestStage fromString(String s) {
        return Arrays.stream(RequestStage.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within RequestStage "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static RequestStage fromJson(JsonInput input) {
        return RequestStage.fromString(input.nextString());
    }
}

