/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.unittest.fixture;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchiveFixture {
    public static ZipFixture newZip() {
        return new ZipFixture(null);
    }

    public static JarFixture newJar() {
        return new JarFixture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] b = new byte[1024];
            while ((len = in.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ZipFixture
    extends AbstractFixture {
        protected List<ChildFixture> children = new ArrayList<ChildFixture>();
        protected byte[] bytes = null;

        protected ZipFixture(ZipFixture parent) {
            super(parent);
        }

        public ZipFixture zip(String path) {
            ZipFixture res = new ZipFixture(this);
            this.children.add(new ChildFixture(path, res));
            return res;
        }

        public ZipFixture jar(String path) {
            JarFixture res = new JarFixture(this);
            this.children.add(new ChildFixture(path, res));
            return res;
        }

        public ZipFixture file(String path, String content) {
            return this.file(path).line(content).end();
        }

        public FileFixture file(String path) {
            FileFixture res = new FileFixture(this);
            this.children.add(new ChildFixture(path, res));
            return res;
        }

        public ZipFixture binary(String path, InputStream input) throws IOException {
            if (input == null) {
                throw new IllegalArgumentException("Provided input stream cannot be null");
            }
            IStreamFixture child = new IStreamFixture(this, input);
            this.children.add(new ChildFixture(path, child));
            return this;
        }

        public ZipFixture binary(String path, String resourcePath) throws IOException {
            return this.binary(path, this.getClass().getClassLoader().getResourceAsStream(resourcePath));
        }

        public ManifestFixture manifest() {
            ManifestFixture res = new ManifestFixture(this);
            this.children.add(new ChildFixture("META-INF/MANIFEST.MF", res));
            return res;
        }

        private void mkDirs(ZipOutputStream zout, String entry, Set<String> existingDirs) throws IOException {
            String[] parts = entry.split("/");
            String dirName = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                if (existingDirs.contains(dirName = dirName + parts[i] + "/")) continue;
                ZipEntry ze = new ZipEntry(dirName);
                zout.putNextEntry(ze);
                zout.closeEntry();
                existingDirs.add(dirName);
            }
        }

        protected void writeAllEntries(ZipOutputStream zout) throws IOException {
            HashSet<String> dirs = new HashSet<String>();
            for (ChildFixture child : this.children) {
                this.mkDirs(zout, child.path, dirs);
                ZipEntry ze = new ZipEntry(child.path);
                zout.putNextEntry(ze);
                child.fixture.writeOut(zout);
                zout.closeEntry();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeOut(OutputStream out) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ZipOutputStream zout = new ZipOutputStream(bout);
            try {
                this.writeAllEntries(zout);
            }
            finally {
                zout.close();
            }
            this.bytes = bout.toByteArray();
            ByteArrayInputStream bin = new ByteArrayInputStream(this.bytes);
            ArchiveFixture.copy(bin, out);
        }

        protected static class ChildFixture {
            public String path;
            public Fixture fixture;

            public ChildFixture(String path, Fixture fixture) {
                this.path = path;
                this.fixture = fixture;
            }
        }
    }

    public static class JarFixture
    extends ZipFixture {
        private ManifestFixture mfFixture;

        protected JarFixture(ZipFixture parent) {
            super(parent);
        }

        public ManifestFixture manifest() {
            if (this.mfFixture != null) {
                throw new IllegalStateException("Only one manifest allowed, you dummy ;)");
            }
            this.mfFixture = new ManifestFixture(this);
            return this.mfFixture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeOut(OutputStream out) throws IOException {
            if (this.bytes == null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                JarOutputStream jout = this.mfFixture != null ? new JarOutputStream((OutputStream)bout, this.mfFixture.getManifest()) : new JarOutputStream(bout);
                try {
                    this.writeAllEntries(jout);
                }
                finally {
                    jout.close();
                }
                this.bytes = bout.toByteArray();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(this.bytes);
            ArchiveFixture.copy(bin, out);
        }
    }

    public static class ManifestFixture
    extends AbstractFixture {
        private Manifest mf = new Manifest();

        protected Manifest getManifest() {
            return this.mf;
        }

        protected ManifestFixture(ZipFixture parent) {
            super(parent);
            this.mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1");
            this.mf.getMainAttributes().putValue("Bundle-ManifestVersion", "2");
        }

        public ManifestFixture symbolicName(String name) {
            this.mf.getMainAttributes().putValue("Bundle-SymbolicName", name);
            return this;
        }

        public ManifestFixture version(String version) {
            this.mf.getMainAttributes().putValue("Bundle-Version", version);
            return this;
        }

        public ManifestFixture attribute(String name, String value) {
            this.mf.getMainAttributes().putValue(name, value);
            return this;
        }

        public void writeOut(OutputStream out) throws IOException {
            this.mf.write(out);
        }
    }

    public static class IStreamFixture
    extends AbstractFixture {
        private byte[] bytes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStreamFixture(ZipFixture parent, InputStream input) throws IOException {
            super(parent);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                ArchiveFixture.copy(input, output);
            }
            finally {
                output.close();
            }
            this.bytes = output.toByteArray();
        }

        public void writeOut(OutputStream out) throws IOException {
            ArchiveFixture.copy(new ByteArrayInputStream(this.bytes), out);
        }
    }

    public static class FileFixture
    extends AbstractFixture {
        private StringBuffer text = new StringBuffer();

        protected FileFixture(ZipFixture parent) {
            super(parent);
        }

        public FileFixture line(String line) {
            this.text.append(line);
            this.text.append("\n");
            return this;
        }

        public void writeOut(OutputStream out) throws IOException {
            out.write(this.text.toString().getBytes());
        }
    }

    public static abstract class AbstractFixture
    implements Fixture {
        private ZipFixture parent;

        protected AbstractFixture(ZipFixture parent) {
            this.parent = parent;
        }

        public ZipFixture end() {
            return this.parent == null ? (ZipFixture)this : this.parent;
        }
    }

    public static interface Fixture {
        public void writeOut(OutputStream var1) throws IOException;
    }
}

