/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.rbc.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.rbc.internal.NoSuchServiceException;
import org.ops4j.pax.exam.rbc.internal.RemoteBundleContext;
import org.ops4j.pax.exam.rbc.internal.TimeoutException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteBundleContextImpl
implements RemoteBundleContext,
Serializable {
    private static final Log LOG = LogFactory.getLog(RemoteBundleContextImpl.class);
    private final transient BundleContext m_bundleContext;

    public RemoteBundleContextImpl(BundleContext bundleContext) {
        NullArgumentException.validateNotNull((Object)bundleContext, (String)"Bundle context");
        this.m_bundleContext = bundleContext;
    }

    @Override
    public Object remoteCall(Class<?> serviceType, String methodName, Class<?>[] methodParams, long timeoutInMillis, Object ... actualParams) throws NoSuchServiceException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        LOG.info((Object)("Remote call of [" + serviceType.getName() + "." + methodName + "]"));
        return serviceType.getMethod(methodName, methodParams).invoke(this.getService(serviceType, timeoutInMillis), actualParams);
    }

    @Override
    public long installBundle(String bundleUrl) throws BundleException {
        LOG.info((Object)("Install bundle from URL [" + bundleUrl + "]"));
        return this.m_bundleContext.installBundle(bundleUrl).getBundleId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long installBundle(String bundleLocation, byte[] bundle) throws BundleException {
        LOG.info((Object)("Install bundle [" + bundleLocation + "] from byte array"));
        ByteArrayInputStream inp = new ByteArrayInputStream(bundle);
        try {
            long l = this.m_bundleContext.installBundle(bundleLocation, (InputStream)inp).getBundleId();
            return l;
        }
        finally {
            try {
                inp.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void startBundle(long bundleId) throws BundleException {
        this.startBundle(this.m_bundleContext.getBundle(bundleId));
    }

    @Override
    public void stopBundle(long bundleId) throws BundleException {
        this.m_bundleContext.getBundle(bundleId).stop();
    }

    @Override
    public void setBundleStartLevel(long bundleId, int startLevel) throws RemoteException, BundleException {
        try {
            StartLevel startLevelService = this.getService(StartLevel.class, 0L);
            startLevelService.setBundleStartLevel(this.m_bundleContext.getBundle(bundleId), startLevel);
        }
        catch (NoSuchServiceException e) {
            throw new BundleException("Cannot get the start level service to set bundle start level");
        }
    }

    @Override
    public void waitForState(long bundleId, int state, long timeoutInMillis) throws TimeoutException {
        Bundle bundle = this.m_bundleContext.getBundle(bundleId);
        if (timeoutInMillis == 0L && bundle.getState() < state) {
            throw new TimeoutException("There is no waiting timeout set and bundle has state '" + RemoteBundleContextImpl.bundleStateToString(bundle.getState()) + "' not '" + RemoteBundleContextImpl.bundleStateToString(state) + "' as expected");
        }
        long startedTrying = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while (bundle.getState() < state && (timeoutInMillis == Long.MAX_VALUE || System.currentTimeMillis() < startedTrying + timeoutInMillis));
        if (bundle.getState() < state) {
            throw new TimeoutException("Timeout passed and bundle has state '" + RemoteBundleContextImpl.bundleStateToString(bundle.getState()) + "' not '" + RemoteBundleContextImpl.bundleStateToString(state) + "' as expected");
        }
    }

    private <T> T getService(Class<T> serviceType, long timeoutInMillis) throws NoSuchServiceException {
        LOG.info((Object)("Look up service [" + serviceType.getName() + "], timeout in " + timeoutInMillis + " millis"));
        ServiceReference ref = this.m_bundleContext.getServiceReference(serviceType.getName());
        if (ref != null) {
            Object service = this.m_bundleContext.getService(ref);
            if (service == null) {
                throw new NoSuchServiceException(serviceType);
            }
            return (T)service;
        }
        throw new NoSuchServiceException(serviceType);
    }

    private void startBundle(Bundle bundle) throws BundleException {
        int bundleState = bundle.getState();
        if (bundleState == 32) {
            return;
        }
        Dictionary bundleHeaders = bundle.getHeaders();
        if (bundleHeaders.get("Fragment-Host") != null) {
            return;
        }
        bundle.start();
        bundleState = bundle.getState();
        if (bundleState != 32) {
            long bundleId = bundle.getBundleId();
            String bundleName = bundle.getSymbolicName();
            String bundleStateStr = RemoteBundleContextImpl.bundleStateToString(bundleState);
            throw new BundleException("Bundle (" + bundleId + ", " + bundleName + ") not started (still " + bundleStateStr + ")");
        }
    }

    private static String bundleStateToString(int bundleState) {
        switch (bundleState) {
            case 32: {
                return "active";
            }
            case 2: {
                return "installed";
            }
            case 4: {
                return "resolved";
            }
            case 8: {
                return "starting";
            }
            case 16: {
                return "stopping";
            }
            case 1: {
                return "uninstalled";
            }
        }
        return "unknown (" + bundleState + ")";
    }
}

