/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.IDeduceBondOrderTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.IValencyChecker;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class SaturationChecker
implements IValencyChecker,
IDeduceBondOrderTool {
    AtomTypeFactory structgenATF;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SaturationChecker.class);

    protected AtomTypeFactory getAtomTypeFactory(IChemObjectBuilder builder) throws CDKException {
        if (this.structgenATF == null) {
            try {
                this.structgenATF = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/structgen_atomtypes.xml", (IChemObjectBuilder)builder);
            }
            catch (Exception exception) {
                logger.debug((Object)exception);
                throw new CDKException("Could not instantiate AtomTypeFactory!", (Throwable)exception);
            }
        }
        return this.structgenATF;
    }

    public boolean hasPerfectConfiguration(IAtom atom, IAtomContainer ac) throws CDKException {
        double bondOrderSum = ac.getBondOrderSum(atom);
        IBond.Order maxBondOrder = ac.getMaximumBondOrder(atom);
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return true;
        }
        logger.debug((Object)"*** Checking for perfect configuration ***");
        try {
            logger.debug((Object)("Checking configuration of atom " + ac.indexOf(atom)));
            logger.debug((Object)("Atom has bondOrderSum = " + bondOrderSum));
            logger.debug((Object)("Atom has max = " + bondOrderSum));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int f = 0; f < atomTypes.length; ++f) {
            if (bondOrderSum != atomTypes[f].getBondOrderSum() || maxBondOrder != atomTypes[f].getMaxBondOrder()) continue;
            try {
                logger.debug((Object)("Atom " + ac.indexOf(atom) + " has perfect configuration"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        try {
            logger.debug((Object)("*** Atom " + ac.indexOf(atom) + " has imperfect configuration ***"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isSaturated(IAtomContainer container) throws CDKException {
        return this.allSaturated(container);
    }

    public boolean allSaturated(IAtomContainer ac) throws CDKException {
        logger.debug((Object)"Are all atoms saturated?");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (this.isSaturated(ac.getAtom(f), ac)) continue;
            return false;
        }
        return true;
    }

    public boolean isUnsaturated(IBond bond, IAtomContainer atomContainer) throws CDKException {
        IAtom[] atoms = BondManipulator.getAtomArray((IBond)bond);
        boolean isUnsaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            isUnsaturated = isUnsaturated && !this.isSaturated(atoms[i], atomContainer);
        }
        return isUnsaturated;
    }

    public boolean isSaturated(IBond bond, IAtomContainer atomContainer) throws CDKException {
        IAtom[] atoms = BondManipulator.getAtomArray((IBond)bond);
        boolean isSaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            isSaturated = isSaturated && this.isSaturated(atoms[i], atomContainer);
        }
        return isSaturated;
    }

    @Override
    public boolean isSaturated(IAtom atom, IAtomContainer ac) throws CDKException {
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return true;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        IBond.Order maxBondOrder = ac.getMaximumBondOrder(atom);
        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        Integer charge = atom.getFormalCharge() == CDKConstants.UNSET ? 0 : atom.getFormalCharge();
        try {
            logger.debug((Object)"*** Checking saturation of atom ", new Object[]{atom.getSymbol(), "" + ac.indexOf(atom) + " ***"});
            logger.debug((Object)("bondOrderSum: " + bondOrderSum));
            logger.debug((Object)("maxBondOrder: " + maxBondOrder));
            logger.debug((Object)("hcount: " + hcount));
        }
        catch (Exception exc) {
            logger.debug((Object)exc);
        }
        for (int f = 0; f < atomTypes.length; ++f) {
            if (bondOrderSum - (double)charge.intValue() + (double)hcount.intValue() != atomTypes[f].getBondOrderSum() || BondManipulator.isHigherOrder((IBond.Order)maxBondOrder, (IBond.Order)atomTypes[f].getMaxBondOrder())) continue;
            logger.debug((Object)"*** Good ! ***");
            return true;
        }
        logger.debug((Object)"*** Bad ! ***");
        return false;
    }

    public boolean isOverSaturated(IAtom atom, IAtomContainer ac) throws CDKException {
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return false;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        IBond.Order maxBondOrder = ac.getMaximumBondOrder(atom);
        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        Integer charge = atom.getFormalCharge() == CDKConstants.UNSET ? 0 : atom.getFormalCharge();
        try {
            logger.debug((Object)("*** Checking saturation of atom " + ac.indexOf(atom) + " ***"));
            logger.debug((Object)("bondOrderSum: " + bondOrderSum));
            logger.debug((Object)("maxBondOrder: " + maxBondOrder));
            logger.debug((Object)("hcount: " + hcount));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int f = 0; f < atomTypes.length; ++f) {
            if (!(bondOrderSum - (double)charge.intValue() + (double)hcount.intValue() > atomTypes[f].getBondOrderSum())) continue;
            logger.debug((Object)"*** Good ! ***");
            return true;
        }
        logger.debug((Object)"*** Bad ! ***");
        return false;
    }

    public double getCurrentMaxBondOrder(IAtom atom, IAtomContainer ac) throws CDKException {
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return 0.0;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        double max = 0.0;
        double current = 0.0;
        for (int f = 0; f < atomTypes.length; ++f) {
            current = (double)hcount.intValue() + bondOrderSum;
            if (!(atomTypes[f].getBondOrderSum() - current > max)) continue;
            max = atomTypes[f].getBondOrderSum() - current;
        }
        return max;
    }

    public void unsaturate(IAtomContainer atomContainer) {
        for (IBond bond : atomContainer.bonds()) {
            bond.setOrder(IBond.Order.SINGLE);
        }
    }

    public void unsaturateBonds(IAtomContainer container) {
        for (IBond bond : container.bonds()) {
            bond.setOrder(IBond.Order.SINGLE);
        }
    }

    public void newSaturate(IAtomContainer atomContainer) throws CDKException {
        logger.info((Object)"Saturating atomContainer by adjusting bond orders...");
        boolean allSaturated = this.allSaturated(atomContainer);
        if (!allSaturated) {
            IBond[] bonds = new IBond[atomContainer.getBondCount()];
            for (int i = 0; i < bonds.length; ++i) {
                bonds[i] = atomContainer.getBond(i);
            }
            boolean succeeded = this.newSaturate(bonds, atomContainer);
            block1: for (int i = 0; i < bonds.length; ++i) {
                if (bonds[i].getOrder() != IBond.Order.DOUBLE || !bonds[i].getFlag(32) || !bonds[i].getBegin().getSymbol().equals("N") || !bonds[i].getEnd().getSymbol().equals("N")) continue;
                int atomtohandle = 0;
                if (bonds[i].getBegin().getSymbol().equals("N")) {
                    atomtohandle = 1;
                }
                List bondstohandle = atomContainer.getConnectedBondsList(bonds[i].getAtom(atomtohandle));
                for (int k = 0; k < bondstohandle.size(); ++k) {
                    IBond bond = (IBond)bondstohandle.get(k);
                    if (bond.getOrder() != IBond.Order.SINGLE || !bond.getFlag(32)) continue;
                    bond.setOrder(IBond.Order.DOUBLE);
                    bonds[i].setOrder(IBond.Order.SINGLE);
                    continue block1;
                }
            }
            if (!succeeded) {
                throw new CDKException("Could not saturate this atomContainer!");
            }
        }
    }

    public boolean newSaturate(IBond[] bonds, IAtomContainer atomContainer) throws CDKException {
        logger.debug((Object)("Saturating bond set of size: " + bonds.length));
        boolean bondsAreFullySaturated = true;
        if (bonds.length > 0) {
            IBond bond = bonds[0];
            int leftBondCount = bonds.length - 1;
            IBond[] leftBonds = new IBond[leftBondCount];
            System.arraycopy(bonds, 1, leftBonds, 0, leftBondCount);
            if (this.isUnsaturated(bond, atomContainer)) {
                if (leftBondCount > 0) {
                    logger.debug((Object)("Recursing with unsaturated bond with #bonds: " + leftBondCount));
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = false;
                }
                if (!bondsAreFullySaturated) {
                    logger.debug((Object)"First try did not work...");
                    boolean couldSaturate = this.newSaturate(bond, atomContainer);
                    if (couldSaturate) {
                        if (leftBondCount > 0) {
                            logger.debug((Object)("Recursing with saturated bond with #bonds: " + leftBondCount));
                            bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer);
                        } else {
                            bondsAreFullySaturated = true;
                        }
                    } else {
                        bondsAreFullySaturated = false;
                    }
                }
            } else if (this.isSaturated(bond, atomContainer)) {
                logger.debug((Object)"This bond is already saturated.");
                if (leftBondCount > 0) {
                    logger.debug((Object)("Recursing with #bonds: " + leftBondCount));
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer);
                } else {
                    bondsAreFullySaturated = true;
                }
            } else {
                logger.debug((Object)"Cannot saturate this bond");
                if (leftBondCount > 0) {
                    logger.debug((Object)("Recursing with saturated bond with #bonds: " + leftBondCount));
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = !this.isUnsaturated(bond, atomContainer);
                }
            }
        }
        logger.debug((Object)("Is bond set fully saturated?: " + bondsAreFullySaturated));
        logger.debug((Object)("Returning to level: " + (bonds.length + 1)));
        return bondsAreFullySaturated;
    }

    public boolean newSaturate(IBond bond, IAtomContainer atomContainer) throws CDKException {
        IAtom[] atoms = BondManipulator.getAtomArray((IBond)bond);
        IAtom atom = atoms[0];
        IAtom partner = atoms[1];
        logger.debug((Object)"  saturating bond: ", new Object[]{atom.getSymbol(), "-", partner.getSymbol()});
        IAtomType[] atomTypes1 = this.getAtomTypeFactory(bond.getBuilder()).getAtomTypes(atom.getSymbol());
        IAtomType[] atomTypes2 = this.getAtomTypeFactory(bond.getBuilder()).getAtomTypes(partner.getSymbol());
        boolean bondOrderIncreased = true;
        while (bondOrderIncreased && !this.isSaturated(bond, atomContainer)) {
            logger.debug((Object)"Can increase bond order");
            bondOrderIncreased = false;
            for (int atCounter1 = 0; atCounter1 < atomTypes1.length && !bondOrderIncreased; ++atCounter1) {
                IAtomType aType1 = atomTypes1[atCounter1];
                logger.debug((Object)"  condidering atom type: ", new Object[]{aType1});
                if (!this.couldMatchAtomType(atomContainer, atom, aType1)) continue;
                logger.debug((Object)"  trying atom type: ", new Object[]{aType1});
                for (int atCounter2 = 0; atCounter2 < atomTypes2.length && !bondOrderIncreased; ++atCounter2) {
                    IAtomType aType2 = atomTypes2[atCounter2];
                    logger.debug((Object)"  condidering partner type: ", new Object[]{aType1});
                    if (!this.couldMatchAtomType(atomContainer, partner, atomTypes2[atCounter2])) continue;
                    logger.debug((Object)"    with atom type: ", new Object[]{aType2});
                    if (!BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)aType2.getMaxBondOrder()) || !BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)aType1.getMaxBondOrder())) {
                        logger.debug((Object)"Bond order not increased: atoms has reached (or exceeded) maximum bond order for this atom type");
                        continue;
                    }
                    if (!BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)aType2.getMaxBondOrder()) || !BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)aType1.getMaxBondOrder())) continue;
                    BondManipulator.increaseBondOrder((IBond)bond);
                    logger.debug((Object)("Bond order now " + bond.getOrder()));
                    bondOrderIncreased = true;
                }
            }
        }
        return this.isSaturated(bond, atomContainer);
    }

    public boolean couldMatchAtomType(IAtomContainer atomContainer, IAtom atom, IAtomType atomType) {
        logger.debug((Object)"   ... matching atom ", new Object[]{atom.getSymbol(), " vs ", atomType});
        if (atomContainer.getBondOrderSum(atom) + (double)atom.getImplicitHydrogenCount().intValue() < atomType.getBondOrderSum()) {
            logger.debug((Object)"    Match!");
            return true;
        }
        logger.debug((Object)"    No Match");
        return false;
    }

    @Override
    public void saturate(IAtomContainer atomContainer) throws CDKException {
        IAtom partner = null;
        IAtom atom = null;
        List partners = null;
        IAtomType[] atomTypes1 = null;
        IAtomType[] atomTypes2 = null;
        IBond bond = null;
        for (int i = 1; i < 4; ++i) {
            block1: for (int f = 0; f < atomContainer.getAtomCount(); ++f) {
                atom = atomContainer.getAtom(f);
                logger.debug((Object)"symbol: ", new Object[]{atom.getSymbol()});
                atomTypes1 = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
                if (atomTypes1.length <= 0) continue;
                logger.debug((Object)"first atom type: ", new Object[]{atomTypes1[0]});
                if (atomContainer.getConnectedBondsCount(atom) != i) continue;
                Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
                if (atom.getFlag(32) && atomContainer.getBondOrderSum(atom) < atomTypes1[0].getBondOrderSum() - (double)hcount.intValue()) {
                    partners = atomContainer.getConnectedAtomsList(atom);
                    for (int g = 0; g < partners.size(); ++g) {
                        partner = (IAtom)partners.get(g);
                        logger.debug((Object)("Atom has " + partners.size() + " partners"));
                        atomTypes2 = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(partner.getSymbol());
                        if (atomTypes2.length == 0) {
                            return;
                        }
                        hcount = partner.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : partner.getImplicitHydrogenCount();
                        if (!atomContainer.getBond(partner, atom).getFlag(32) || !(atomContainer.getBondOrderSum(partner) < atomTypes2[0].getBondOrderSum() - (double)hcount.intValue())) continue;
                        logger.debug((Object)("Partner has " + atomContainer.getBondOrderSum(partner) + ", may have: " + atomTypes2[0].getBondOrderSum()));
                        bond = atomContainer.getBond(atom, partner);
                        logger.debug((Object)("Bond order was " + bond.getOrder()));
                        BondManipulator.increaseBondOrder((IBond)bond);
                        logger.debug((Object)("Bond order now " + bond.getOrder()));
                        break;
                    }
                }
                Double bondOrderSum = atomTypes1[0].getBondOrderSum() == CDKConstants.UNSET ? 0.0 : atomTypes1[0].getBondOrderSum();
                Integer hydrogenCount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
                Double atomContainerBondOrderSum = atomContainer.getBondOrderSum(atom);
                if (atomContainerBondOrderSum == CDKConstants.UNSET) {
                    atomContainerBondOrderSum = 0.0;
                }
                if (!(atomContainerBondOrderSum < bondOrderSum - (double)hydrogenCount.intValue())) continue;
                logger.debug((Object)("Atom has " + atomContainerBondOrderSum + ", may have: " + bondOrderSum));
                partners = atomContainer.getConnectedAtomsList(atom);
                for (int g = 0; g < partners.size(); ++g) {
                    partner = (IAtom)partners.get(g);
                    logger.debug((Object)("Atom has " + partners.size() + " partners"));
                    atomTypes2 = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(partner.getSymbol());
                    if (atomTypes2.length == 0) {
                        return;
                    }
                    Double bos2 = atomTypes2[0].getBondOrderSum();
                    Integer hc2 = partner.getImplicitHydrogenCount();
                    Double acbos2 = atomContainer.getBondOrderSum(partner);
                    if (bos2 == CDKConstants.UNSET) {
                        bos2 = 0.0;
                    }
                    if (hc2 == CDKConstants.UNSET) {
                        hc2 = 0;
                    }
                    if (acbos2 == CDKConstants.UNSET) {
                        acbos2 = 0.0;
                    }
                    if (!(acbos2 < bos2 - (double)hc2.intValue())) continue;
                    logger.debug((Object)("Partner has " + acbos2 + ", may have: " + bos2));
                    bond = atomContainer.getBond(atom, partner);
                    logger.debug((Object)("Bond order was " + bond.getOrder()));
                    BondManipulator.increaseBondOrder((IBond)bond);
                    logger.debug((Object)("Bond order now " + bond.getOrder()));
                    continue block1;
                }
            }
        }
    }

    public void saturateRingSystems(IAtomContainer atomContainer) throws CDKException {
        IRingSet rs = Cycles.sssr((IAtomContainer)((IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer}))).toRingSet();
        List ringSets = RingPartitioner.partitionRings((IRingSet)rs);
        IAtomContainer ac = null;
        IAtom atom = null;
        for (int f = 0; f < ringSets.size(); ++f) {
            rs = (IRingSet)ringSets.get(f);
            List containers = RingSetManipulator.getAllAtomContainers((IRingSet)rs);
            for (int counter = 0; counter < containers.size(); ++counter) {
                int g;
                ac = (IAtomContainer)containers.get(counter);
                int[] temp = new int[ac.getAtomCount()];
                for (g = 0; g < ac.getAtomCount(); ++g) {
                    atom = ac.getAtom(g);
                    temp[g] = atom.getImplicitHydrogenCount();
                    atom.setImplicitHydrogenCount(Integer.valueOf(atomContainer.getConnectedBondsCount(atom) - ac.getConnectedBondsCount(atom) - temp[g]));
                }
                this.saturate(ac);
                for (g = 0; g < ac.getAtomCount(); ++g) {
                    atom = ac.getAtom(g);
                    atom.setImplicitHydrogenCount(Integer.valueOf(temp[g]));
                }
            }
        }
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, IAtomContainer container) throws CDKException {
        return this.calculateNumberOfImplicitHydrogens(atom, container, false);
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom) throws CDKException {
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        return this.calculateNumberOfImplicitHydrogens(atom, 0.0, 0.0, bonds, false);
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, IAtomContainer container, boolean throwExceptionForUnknowAtom) throws CDKException {
        return this.calculateNumberOfImplicitHydrogens(atom, container.getBondOrderSum(atom), container.getConnectedSingleElectronsCount(atom), container.getConnectedBondsList(atom), throwExceptionForUnknowAtom);
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, double bondOrderSum, double singleElectronSum, List<IBond> connectedBonds, boolean throwExceptionForUnknowAtom) throws CDKException {
        int missingHydrogen = 0;
        if (!(atom instanceof IPseudoAtom)) {
            if (atom.getAtomicNumber() != null && atom.getAtomicNumber() == 1 || atom.getSymbol().equals("H")) {
                missingHydrogen = (int)(1.0 - bondOrderSum - singleElectronSum - (double)atom.getFormalCharge().intValue());
            } else {
                logger.info((Object)"Calculating number of missing hydrogen atoms");
                IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
                if (atomTypes.length == 0 && throwExceptionForUnknowAtom) {
                    return 0;
                }
                logger.debug((Object)("Found atomtypes: " + atomTypes.length));
                if (atomTypes.length > 0) {
                    Double tmpBondOrderSum;
                    IAtomType defaultAtom = atomTypes[0];
                    logger.debug((Object)"DefAtom: ", new Object[]{defaultAtom});
                    Integer formalCharge = atom.getFormalCharge();
                    if (formalCharge == null) {
                        formalCharge = 0;
                    }
                    if ((tmpBondOrderSum = defaultAtom.getBondOrderSum()) == null) {
                        tmpBondOrderSum = 0.0;
                    }
                    missingHydrogen = (int)(tmpBondOrderSum - bondOrderSum - singleElectronSum + (double)formalCharge.intValue());
                    if (atom.getFlag(32)) {
                        boolean subtractOne = true;
                        for (int i = 0; i < connectedBonds.size(); ++i) {
                            IBond conBond = connectedBonds.get(i);
                            if (conBond.getOrder() != IBond.Order.DOUBLE && !conBond.getFlag(32)) continue;
                            subtractOne = false;
                        }
                        if (subtractOne) {
                            --missingHydrogen;
                        }
                    }
                    logger.debug((Object)"Atom: ", new Object[]{atom.getSymbol()});
                    logger.debug((Object)("  max bond order: " + tmpBondOrderSum));
                    logger.debug((Object)("  bond order sum: " + bondOrderSum));
                    logger.debug((Object)("  charge        : " + formalCharge));
                } else {
                    logger.warn((Object)"Could not find atom type for ", new Object[]{atom.getSymbol()});
                }
            }
        }
        return missingHydrogen;
    }
}

