/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.internal.storage.dfs.BlockBasedFile;
import org.openrewrite.jgit.internal.storage.dfs.DeltaBaseCache;
import org.openrewrite.jgit.internal.storage.dfs.DfsBlock;
import org.openrewrite.jgit.internal.storage.dfs.DfsCachedPack;
import org.openrewrite.jgit.internal.storage.dfs.DfsObjDatabase;
import org.openrewrite.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.openrewrite.jgit.internal.storage.dfs.DfsObjectToPack;
import org.openrewrite.jgit.internal.storage.dfs.DfsPackDescription;
import org.openrewrite.jgit.internal.storage.dfs.DfsPackFile;
import org.openrewrite.jgit.internal.storage.dfs.DfsReaderIoStats;
import org.openrewrite.jgit.internal.storage.dfs.DfsReaderOptions;
import org.openrewrite.jgit.internal.storage.file.BitmapIndexImpl;
import org.openrewrite.jgit.internal.storage.file.PackBitmapIndex;
import org.openrewrite.jgit.internal.storage.file.PackIndex;
import org.openrewrite.jgit.internal.storage.file.PackReverseIndex;
import org.openrewrite.jgit.internal.storage.pack.CachedPack;
import org.openrewrite.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.openrewrite.jgit.internal.storage.pack.ObjectToPack;
import org.openrewrite.jgit.internal.storage.pack.PackOutputStream;
import org.openrewrite.jgit.internal.storage.pack.PackWriter;
import org.openrewrite.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.AsyncObjectLoaderQueue;
import org.openrewrite.jgit.lib.AsyncObjectSizeQueue;
import org.openrewrite.jgit.lib.BitmapIndex;
import org.openrewrite.jgit.lib.InflaterCache;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectLoader;
import org.openrewrite.jgit.lib.ObjectReader;
import org.openrewrite.jgit.lib.ProgressMonitor;
import org.openrewrite.jgit.util.BlockList;

public class DfsReader
extends ObjectReader
implements ObjectReuseAsIs {
    private static final int MAX_RESOLVE_MATCHES = 256;
    final byte[] tempId = new byte[20];
    final DfsObjDatabase db;
    final DfsReaderIoStats.Accumulator stats = new DfsReaderIoStats.Accumulator();
    private Inflater inf;
    private DfsBlock block;
    private DeltaBaseCache baseCache;
    private DfsPackFile last;
    private boolean avoidUnreachable;
    private static final Comparator<FoundObject<?>> FOUND_OBJECT_SORT = (a, b) -> {
        int cmp = a.packIndex - b.packIndex;
        if (cmp == 0) {
            cmp = Long.signum(a.offset - b.offset);
        }
        return cmp;
    };
    private static final Comparator<DfsObjectToPack> OFFSET_SORT = (a, b) -> Long.signum(a.getOffset() - b.getOffset());
    private static final Comparator<DfsPackFile> PACK_SORT_FOR_REUSE = Comparator.comparing(DfsPackFile::getPackDescription, DfsPackDescription.reuseComparator());

    protected DfsReader(DfsObjDatabase db) {
        this.db = db;
        this.streamFileThreshold = db.getReaderOptions().getStreamFileThreshold();
    }

    DfsReaderOptions getOptions() {
        return this.db.getReaderOptions();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache(this);
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return this.db.newReader();
    }

    @Override
    public void setAvoidUnreachableObjects(boolean avoid) {
        this.avoidUnreachable = avoid;
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        for (DfsPackFile pack : this.db.getPacks()) {
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (bitmapIndex == null) continue;
            return new BitmapIndexImpl(bitmapIndex);
        }
        return null;
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        for (DfsPackFile pack : this.db.getPacks()) {
            PackBitmapIndex bitmapIndex = pack.getBitmapIndex(this);
            if (!needBitmap.removeAllOrNone(bitmapIndex)) continue;
            return Collections.singletonList(new DfsCachedPack(pack));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        DfsObjDatabase.PackList packList = this.db.getPackList();
        this.resolveImpl(packList, id, matches);
        if (matches.size() < 256 && packList.dirty()) {
            ++this.stats.scanPacks;
            this.resolveImpl(this.db.scanPacks(packList), id, matches);
        }
        return matches;
    }

    private void resolveImpl(DfsObjDatabase.PackList packList, AbbreviatedObjectId id, HashSet<ObjectId> matches) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            if (this.skipGarbagePack(pack)) continue;
            pack.resolve(this, matches, id, 256);
            if (matches.size() >= 256) break;
        }
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        if (this.last != null && !this.skipGarbagePack(this.last) && this.last.hasObject(this, objectId)) {
            return true;
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        if (this.hasImpl(packList, objectId)) {
            return true;
        }
        if (packList.dirty()) {
            ++this.stats.scanPacks;
            return this.hasImpl(this.db.scanPacks(packList), objectId);
        }
        return false;
    }

    private boolean hasImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            if (pack == this.last || this.skipGarbagePack(pack) || !pack.hasObject(this, objectId)) continue;
            this.last = pack;
            return true;
        }
        return false;
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr;
        if (this.last != null && !this.skipGarbagePack(this.last) && (ldr = this.last.get(this, objectId)) != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ldr = this.openImpl(packList, objectId);
        if (ldr != null) {
            return DfsReader.checkType(ldr, objectId, typeHint);
        }
        if (packList.dirty()) {
            ++this.stats.scanPacks;
            ldr = this.openImpl(this.db.scanPacks(packList), objectId);
            if (ldr != null) {
                return DfsReader.checkType(ldr, objectId, typeHint);
            }
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    private static ObjectLoader checkType(ObjectLoader ldr, AnyObjectId id, int typeHint) throws IncorrectObjectTypeException {
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(id.copy(), typeHint);
        }
        return ldr;
    }

    private ObjectLoader openImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            ObjectLoader ldr;
            if (pack == this.last || this.skipGarbagePack(pack) || (ldr = pack.get(this, objectId)) == null) continue;
            this.last = pack;
            return ldr;
        }
        return null;
    }

    @Override
    public Set<ObjectId> getShallowCommits() {
        return Collections.emptySet();
    }

    private <T extends ObjectId> Iterable<FoundObject<T>> findAll(Iterable<T> objectIds) throws IOException {
        LinkedList<ObjectId> pending = new LinkedList<ObjectId>();
        for (ObjectId id : objectIds) {
            pending.add(id);
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        ArrayList<FoundObject<T>> r = new ArrayList<FoundObject<T>>();
        this.findAllImpl(packList, pending, r);
        if (!pending.isEmpty() && packList.dirty()) {
            ++this.stats.scanPacks;
            this.findAllImpl(this.db.scanPacks(packList), pending, r);
        }
        for (ObjectId t : pending) {
            r.add(new FoundObject<ObjectId>(t));
        }
        Collections.sort(r, FOUND_OBJECT_SORT);
        return r;
    }

    private <T extends ObjectId> void findAllImpl(DfsObjDatabase.PackList packList, Collection<T> pending, List<FoundObject<T>> r) {
        DfsPackFile[] packs = packList.packs;
        if (packs.length == 0) {
            return;
        }
        int lastIdx = 0;
        DfsPackFile lastPack = packs[lastIdx];
        Iterator<T> it = pending.iterator();
        block4: while (it.hasNext()) {
            ObjectId t = (ObjectId)it.next();
            if (!this.skipGarbagePack(lastPack)) {
                try {
                    long p = lastPack.findOffset(this, t);
                    if (0L < p) {
                        r.add(new FoundObject<ObjectId>(t, lastIdx, lastPack, p));
                        it.remove();
                        continue;
                    }
                }
                catch (IOException p) {
                    // empty catch block
                }
            }
            for (int i = 0; i < packs.length; ++i) {
                DfsPackFile pack;
                if (i == lastIdx || this.skipGarbagePack(pack = packs[i])) continue;
                try {
                    long p = pack.findOffset(this, t);
                    if (0L >= p) continue;
                    r.add(new FoundObject<ObjectId>(t, i, pack, p));
                    it.remove();
                    lastIdx = i;
                    lastPack = pack;
                    continue block4;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.last = lastPack;
    }

    private boolean skipGarbagePack(DfsPackFile pack) {
        return this.avoidUnreachable && pack.isGarbage();
    }

    @Override
    public <T extends ObjectId> AsyncObjectLoaderQueue<T> open(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectLoaderQueue<T>(){
            private FoundObject<T> cur;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public ObjectLoader open() throws IOException {
                if (this.cur.pack == null) {
                    throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                }
                return this.cur.pack.load(DfsReader.this, this.cur.offset);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public <T extends ObjectId> AsyncObjectSizeQueue<T> getObjectSize(Iterable<T> objectIds, boolean reportMissing) {
        Iterable<FoundObject<T>> order;
        IOException error = null;
        try {
            order = this.findAll(objectIds);
        }
        catch (IOException e) {
            order = Collections.emptyList();
            error = e;
        }
        final Iterator<FoundObject<T>> idItr = order.iterator();
        final IOException findAllError = error;
        return new AsyncObjectSizeQueue<T>(){
            private FoundObject<T> cur;
            private long sz;

            @Override
            public boolean next() throws MissingObjectException, IOException {
                if (idItr.hasNext()) {
                    this.cur = (FoundObject)idItr.next();
                    if (this.cur.pack == null) {
                        throw new MissingObjectException((ObjectId)this.cur.id, JGitText.get().unknownObjectType2);
                    }
                    this.sz = this.cur.pack.getObjectSize(DfsReader.this, this.cur.offset);
                    return true;
                }
                if (findAllError != null) {
                    throw findAllError;
                }
                return false;
            }

            @Override
            public T getCurrent() {
                return this.cur.id;
            }

            @Override
            public ObjectId getObjectId() {
                return this.cur.id;
            }

            @Override
            public long getSize() {
                return this.sz;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public void release() {
            }
        };
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz;
        if (this.last != null && !this.skipGarbagePack(this.last) && 0L <= (sz = this.last.getObjectSize(this, objectId))) {
            return sz;
        }
        DfsObjDatabase.PackList packList = this.db.getPackList();
        long sz2 = this.getObjectSizeImpl(packList, objectId);
        if (0L <= sz2) {
            return sz2;
        }
        if (packList.dirty() && 0L <= (sz2 = this.getObjectSizeImpl(packList, objectId))) {
            return sz2;
        }
        if (typeHint == -1) {
            throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
        }
        throw new MissingObjectException(objectId.copy(), typeHint);
    }

    private long getObjectSizeImpl(DfsObjDatabase.PackList packList, AnyObjectId objectId) throws IOException {
        for (DfsPackFile pack : packList.packs) {
            long sz;
            if (pack == this.last || this.skipGarbagePack(pack) || 0L > (sz = pack.getObjectSize(this, objectId))) continue;
            this.last = pack;
            return sz;
        }
        return -1L;
    }

    @Override
    public DfsObjectToPack newObjectToPack(AnyObjectId objectId, int type) {
        return new DfsObjectToPack(objectId, type);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        List<DfsPackFile> packs = this.sortPacksForSelectRepresentation();
        this.trySelectRepresentation(packer, monitor, objects, packs, false);
        List<DfsPackFile> garbage = this.garbagePacksForSelectRepresentation();
        if (!garbage.isEmpty() && DfsReader.checkGarbagePacks(objects)) {
            this.trySelectRepresentation(packer, monitor, objects, garbage, true);
        }
    }

    private void trySelectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects, List<DfsPackFile> packs, boolean skipFound) throws IOException {
        for (DfsPackFile pack : packs) {
            List<DfsObjectToPack> tmp = this.findAllFromPack(pack, objects, skipFound);
            if (tmp.isEmpty()) continue;
            Collections.sort(tmp, OFFSET_SORT);
            PackReverseIndex rev = pack.getReverseIdx(this);
            DfsObjectRepresentation rep = new DfsObjectRepresentation(pack);
            for (DfsObjectToPack otp : tmp) {
                pack.representation(rep, otp.getOffset(), this, rev);
                otp.setOffset(0L);
                packer.select(otp, rep);
                if (otp.isFound()) continue;
                otp.setFound();
                monitor.update(1);
            }
        }
    }

    private List<DfsPackFile> sortPacksForSelectRepresentation() throws IOException {
        DfsPackFile[] packs = this.db.getPacks();
        ArrayList<DfsPackFile> sorted = new ArrayList<DfsPackFile>(packs.length);
        for (DfsPackFile p : packs) {
            if (p.getPackDescription().getPackSource() == DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) continue;
            sorted.add(p);
        }
        Collections.sort(sorted, PACK_SORT_FOR_REUSE);
        return sorted;
    }

    private List<DfsPackFile> garbagePacksForSelectRepresentation() throws IOException {
        DfsPackFile[] packs = this.db.getPacks();
        ArrayList<DfsPackFile> garbage = new ArrayList<DfsPackFile>(packs.length);
        for (DfsPackFile p : packs) {
            if (p.getPackDescription().getPackSource() != DfsObjDatabase.PackSource.UNREACHABLE_GARBAGE) continue;
            garbage.add(p);
        }
        return garbage;
    }

    private static boolean checkGarbagePacks(Iterable<ObjectToPack> objects) {
        for (ObjectToPack otp : objects) {
            if (((DfsObjectToPack)otp).isFound()) continue;
            return true;
        }
        return false;
    }

    private List<DfsObjectToPack> findAllFromPack(DfsPackFile pack, Iterable<ObjectToPack> objects, boolean skipFound) throws IOException {
        BlockList<DfsObjectToPack> tmp = new BlockList<DfsObjectToPack>();
        PackIndex idx = pack.getPackIndex(this);
        for (ObjectToPack obj : objects) {
            long p;
            DfsObjectToPack otp = (DfsObjectToPack)obj;
            if (skipFound && otp.isFound() || 0L >= (p = idx.findOffset(otp)) || pack.isCorrupt(p)) continue;
            otp.setOffset(p);
            tmp.add(otp);
        }
        return tmp;
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate) throws IOException, StoredObjectRepresentationNotAvailableException {
        DfsObjectToPack src = (DfsObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        for (ObjectToPack otp : list) {
            out.writeObject(otp);
        }
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack) throws IOException {
        ((DfsCachedPack)pack).copyAsIs(out, this);
    }

    int copy(BlockBasedFile file, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        if (cnt == 0) {
            return 0;
        }
        long length = file.length;
        if (0L <= length && length <= position) {
            return 0;
        }
        int need = cnt;
        do {
            this.pin(file, position);
            int r = this.block.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
            if (length >= 0L) continue;
            length = file.length;
        } while (0 < need && position < length);
        return cnt - need;
    }

    int inflate(DfsPackFile pack, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        long start = System.nanoTime();
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.block.setInput(position, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                this.stats.inflatedBytes += (long)dstoff;
                this.stats.inflationMicros += BlockBasedFile.elapsedMicros(start);
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.block.setInput(position, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    DfsBlock quickCopy(DfsPackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.block.contains(p.key, pos + (cnt - 1L))) {
            return this.block;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(BlockBasedFile file, long position) throws IOException {
        if (this.block == null || !this.block.contains(file.key, position)) {
            this.block = null;
            this.block = file.getOrLoadBlock(position, this);
        }
    }

    void unpin() {
        this.block = null;
    }

    public DfsReaderIoStats getIoStats() {
        return new DfsReaderIoStats(this.stats);
    }

    @Override
    public void close() {
        this.last = null;
        this.block = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }

    private static class FoundObject<T extends ObjectId> {
        final T id;
        final DfsPackFile pack;
        final long offset;
        final int packIndex;

        FoundObject(T objectId, int packIdx, DfsPackFile pack, long offset) {
            this.id = objectId;
            this.pack = pack;
            this.offset = offset;
            this.packIndex = packIdx;
        }

        FoundObject(T objectId) {
            this.id = objectId;
            this.pack = null;
            this.offset = 0L;
            this.packIndex = 0;
        }
    }
}

