/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.circular;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.circular.CircularReferenceConfigurer;
import de.danielbechler.diff.circular.CircularReferenceDetector;
import de.danielbechler.diff.circular.CircularReferenceDetectorFactory;
import de.danielbechler.diff.circular.CircularReferenceExceptionHandler;
import de.danielbechler.diff.circular.CircularReferenceMatchingMode;
import de.danielbechler.diff.node.DiffNode;

public class CircularReferenceService
implements CircularReferenceConfigurer,
CircularReferenceDetectorFactory,
CircularReferenceExceptionHandler {
    private final ObjectDifferBuilder objectDifferBuilder;
    private CircularReferenceMatchingMode circularReferenceMatchingMode = CircularReferenceMatchingMode.EQUALITY_OPERATOR;
    private CircularReferenceExceptionHandler circularReferenceExceptionHandler = new CircularReferenceExceptionHandler(){

        @Override
        public void onCircularReferenceException(DiffNode node) {
            String message = "Detected circular reference in node at path {}. Going deeper would cause an infinite loop, so I'll stop looking at this instance along the current path.";
        }
    };

    public CircularReferenceService(ObjectDifferBuilder objectDifferBuilder) {
        this.objectDifferBuilder = objectDifferBuilder;
    }

    @Override
    public CircularReferenceConfigurer matchCircularReferencesUsing(CircularReferenceMatchingMode matchingMode) {
        this.circularReferenceMatchingMode = matchingMode;
        return this;
    }

    @Override
    public CircularReferenceConfigurer handleCircularReferenceExceptionsUsing(CircularReferenceExceptionHandler exceptionHandler) {
        this.circularReferenceExceptionHandler = exceptionHandler;
        return this;
    }

    @Override
    public ObjectDifferBuilder and() {
        return this.objectDifferBuilder;
    }

    @Override
    public CircularReferenceDetector createCircularReferenceDetector() {
        if (this.circularReferenceMatchingMode == CircularReferenceMatchingMode.EQUALS_METHOD) {
            return new CircularReferenceDetector(CircularReferenceDetector.ReferenceMatchingMode.EQUALS_METHOD);
        }
        if (this.circularReferenceMatchingMode == CircularReferenceMatchingMode.EQUALITY_OPERATOR) {
            return new CircularReferenceDetector(CircularReferenceDetector.ReferenceMatchingMode.EQUALITY_OPERATOR);
        }
        throw new IllegalStateException();
    }

    @Override
    public void onCircularReferenceException(DiffNode node) {
        if (this.circularReferenceExceptionHandler != null) {
            this.circularReferenceExceptionHandler.onCircularReferenceException(node);
        }
    }
}

