/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.time.Duration;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class MavenRepository
implements Serializable {
    public static final MavenRepository MAVEN_LOCAL_USER_NEUTRAL = new MavenRepository("local", new File("~/.m2/repository").toString(), "true", "true", true, null, null, null, false);
    public static final MavenRepository MAVEN_LOCAL_DEFAULT = new MavenRepository("local", Paths.get(System.getProperty("user.home"), ".m2", "repository").toUri().toString(), "true", "true", true, null, null, null, false);
    public static final MavenRepository MAVEN_CENTRAL = new MavenRepository("central", "https://repo.maven.apache.org/maven2", "true", "false", true, null, null, null, true);
    private final @Nullable String id;
    private final String uri;
    private final @Nullable String releases;
    private final @Nullable String snapshots;
    private boolean knownToExist;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private final @Nullable String username;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private final @Nullable String password;
    private final @Nullable Duration timeout;
    private @Nullable Boolean deriveMetadataIfMissing;

    @Deprecated
    @JsonIgnore
    public MavenRepository(@Nullable String id, String uri, @Nullable String releases, @Nullable String snapshots, @Nullable String username, @Nullable String password) {
        this(id, uri, releases, snapshots, false, username, password, null, null);
    }

    @Deprecated
    @JsonIgnore
    public MavenRepository(@Nullable String id, String uri, @Nullable String releases, @Nullable String snapshots, boolean knownToExist, @Nullable String username, @Nullable String password, @Nullable Boolean deriveMetadataIfMissing) {
        this(id, uri, releases, snapshots, knownToExist, username, password, null, deriveMetadataIfMissing);
    }

    @JsonIgnore
    public MavenRepository(@Nullable String id, String uri, @Nullable String releases, @Nullable String snapshots, boolean knownToExist, @Nullable String username, @Nullable String password, @Nullable Duration timeout, @Nullable Boolean deriveMetadataIfMissing) {
        this.id = id;
        this.uri = uri;
        this.releases = releases;
        this.snapshots = snapshots;
        this.knownToExist = knownToExist;
        this.username = username;
        this.password = password;
        this.timeout = timeout;
        this.deriveMetadataIfMissing = deriveMetadataIfMissing;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenRepository)) {
            return false;
        }
        MavenRepository other = (MavenRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKnownToExist() != other.isKnownToExist()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$releases = this.getReleases();
        String other$releases = other.getReleases();
        if (this$releases == null ? other$releases != null : !this$releases.equals(other$releases)) {
            return false;
        }
        String this$snapshots = this.getSnapshots();
        String other$snapshots = other.getSnapshots();
        return !(this$snapshots == null ? other$snapshots != null : !this$snapshots.equals(other$snapshots));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MavenRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKnownToExist() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $releases = this.getReleases();
        result = result * 59 + ($releases == null ? 43 : $releases.hashCode());
        String $snapshots = this.getSnapshots();
        result = result * 59 + ($snapshots == null ? 43 : $snapshots.hashCode());
        return result;
    }

    @Generated
    public @Nullable String getId() {
        return this.id;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public @Nullable String getReleases() {
        return this.releases;
    }

    @Generated
    public @Nullable String getSnapshots() {
        return this.snapshots;
    }

    @Generated
    public boolean isKnownToExist() {
        return this.knownToExist;
    }

    @Generated
    public @Nullable String getUsername() {
        return this.username;
    }

    @Generated
    public @Nullable String getPassword() {
        return this.password;
    }

    @Generated
    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public @Nullable Boolean getDeriveMetadataIfMissing() {
        return this.deriveMetadataIfMissing;
    }

    @Generated
    public void setKnownToExist(boolean knownToExist) {
        this.knownToExist = knownToExist;
    }

    @Generated
    public void setDeriveMetadataIfMissing(@Nullable Boolean deriveMetadataIfMissing) {
        this.deriveMetadataIfMissing = deriveMetadataIfMissing;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MavenRepository(id=" + this.getId() + ", uri=" + this.getUri() + ", releases=" + this.getReleases() + ", snapshots=" + this.getSnapshots() + ", knownToExist=" + this.isKnownToExist() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", timeout=" + this.getTimeout() + ", deriveMetadataIfMissing=" + this.getDeriveMetadataIfMissing() + ")";
    }

    @Generated
    public MavenRepository(@Nullable String id, String uri, @Nullable String releases, @Nullable String snapshots, @Nullable String username, @Nullable String password, @Nullable Duration timeout) {
        this.id = id;
        this.uri = uri;
        this.releases = releases;
        this.snapshots = snapshots;
        this.username = username;
        this.password = password;
        this.timeout = timeout;
    }

    @NonNull
    @Generated
    public MavenRepository withId(@Nullable String id) {
        return this.id == id ? this : new MavenRepository(id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password, this.timeout, this.deriveMetadataIfMissing);
    }

    @NonNull
    @Generated
    public MavenRepository withUri(String uri) {
        return this.uri == uri ? this : new MavenRepository(this.id, uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password, this.timeout, this.deriveMetadataIfMissing);
    }

    @NonNull
    @Generated
    public MavenRepository withReleases(@Nullable String releases) {
        return this.releases == releases ? this : new MavenRepository(this.id, this.uri, releases, this.snapshots, this.knownToExist, this.username, this.password, this.timeout, this.deriveMetadataIfMissing);
    }

    @NonNull
    @Generated
    public MavenRepository withSnapshots(@Nullable String snapshots) {
        return this.snapshots == snapshots ? this : new MavenRepository(this.id, this.uri, this.releases, snapshots, this.knownToExist, this.username, this.password, this.timeout, this.deriveMetadataIfMissing);
    }

    @NonNull
    @Generated
    public MavenRepository withKnownToExist(boolean knownToExist) {
        return this.knownToExist == knownToExist ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, knownToExist, this.username, this.password, this.timeout, this.deriveMetadataIfMissing);
    }

    @NonNull
    @Generated
    public MavenRepository withUsername(@Nullable String username) {
        return this.username == username ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, username, this.password, this.timeout, this.deriveMetadataIfMissing);
    }

    @NonNull
    @Generated
    public MavenRepository withPassword(@Nullable String password) {
        return this.password == password ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, password, this.timeout, this.deriveMetadataIfMissing);
    }

    @NonNull
    @Generated
    public MavenRepository withTimeout(@Nullable Duration timeout) {
        return this.timeout == timeout ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password, timeout, this.deriveMetadataIfMissing);
    }

    public static class Builder {
        private String id;
        private String uri;
        private String releases;
        private String snapshots;
        private boolean knownToExist;
        private String username;
        private String password;
        private Boolean deriveMetadataIfMissing;
        private Duration timeout;

        private Builder() {
        }

        public MavenRepository build() {
            return new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password, this.timeout, this.deriveMetadataIfMissing);
        }

        public Builder releases(boolean releases) {
            this.releases = Boolean.toString(releases);
            return this;
        }

        public Builder releases(String releases) {
            this.releases = releases;
            return this;
        }

        public Builder snapshots(boolean snapshots) {
            this.snapshots = Boolean.toString(snapshots);
            return this;
        }

        public Builder snapshots(String snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public Builder username(String username) {
            if (username.startsWith("${env.")) {
                this.username = Builder.resolveEnvironmentProperty(username);
                return this;
            }
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            if (password.startsWith("${env.")) {
                this.password = Builder.resolveEnvironmentProperty(password);
                return this;
            }
            this.password = password;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        private static @Nullable String resolveEnvironmentProperty(@Nullable String rawProperty) {
            if (rawProperty == null) {
                return null;
            }
            String propertyName = rawProperty.replace("${env.", "").replace("}", "");
            return System.getenv(propertyName);
        }

        @Generated
        public String id() {
            return this.id;
        }

        @Generated
        public String uri() {
            return this.uri;
        }

        @Generated
        public String releases() {
            return this.releases;
        }

        @Generated
        public String snapshots() {
            return this.snapshots;
        }

        @Generated
        public boolean knownToExist() {
            return this.knownToExist;
        }

        @Generated
        public String username() {
            return this.username;
        }

        @Generated
        public String password() {
            return this.password;
        }

        @Generated
        public Boolean deriveMetadataIfMissing() {
            return this.deriveMetadataIfMissing;
        }

        @Generated
        public Duration timeout() {
            return this.timeout;
        }

        @NonNull
        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @NonNull
        @Generated
        public Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @NonNull
        @Generated
        public Builder knownToExist(boolean knownToExist) {
            this.knownToExist = knownToExist;
            return this;
        }

        @NonNull
        @Generated
        public Builder deriveMetadataIfMissing(Boolean deriveMetadataIfMissing) {
            this.deriveMetadataIfMissing = deriveMetadataIfMissing;
            return this;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.knownToExist() != other.knownToExist()) {
                return false;
            }
            Boolean this$deriveMetadataIfMissing = this.deriveMetadataIfMissing();
            Boolean other$deriveMetadataIfMissing = other.deriveMetadataIfMissing();
            if (this$deriveMetadataIfMissing == null ? other$deriveMetadataIfMissing != null : !((Object)this$deriveMetadataIfMissing).equals(other$deriveMetadataIfMissing)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$uri = this.uri();
            String other$uri = other.uri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$releases = this.releases();
            String other$releases = other.releases();
            if (this$releases == null ? other$releases != null : !this$releases.equals(other$releases)) {
                return false;
            }
            String this$snapshots = this.snapshots();
            String other$snapshots = other.snapshots();
            if (this$snapshots == null ? other$snapshots != null : !this$snapshots.equals(other$snapshots)) {
                return false;
            }
            String this$username = this.username();
            String other$username = other.username();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            Duration this$timeout = this.timeout();
            Duration other$timeout = other.timeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.knownToExist() ? 79 : 97);
            Boolean $deriveMetadataIfMissing = this.deriveMetadataIfMissing();
            result = result * 59 + ($deriveMetadataIfMissing == null ? 43 : ((Object)$deriveMetadataIfMissing).hashCode());
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $uri = this.uri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $releases = this.releases();
            result = result * 59 + ($releases == null ? 43 : $releases.hashCode());
            String $snapshots = this.snapshots();
            result = result * 59 + ($snapshots == null ? 43 : $snapshots.hashCode());
            String $username = this.username();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            Duration $timeout = this.timeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenRepository.Builder(id=" + this.id() + ", uri=" + this.uri() + ", releases=" + this.releases() + ", snapshots=" + this.snapshots() + ", knownToExist=" + this.knownToExist() + ", username=" + this.username() + ", password=" + this.password() + ", deriveMetadataIfMissing=" + this.deriveMetadataIfMissing() + ", timeout=" + this.timeout() + ")";
        }
    }
}

