/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public class FindEmptyClasses
extends Recipe {
    public String getDisplayName() {
        return "Find empty classes";
    }

    public String getDescription() {
        return "Find empty classes without annotations that do not implement an interface or extend a class.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2094");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getType() != null && JavaType.FullyQualified.Kind.Class.equals((Object)classDecl.getType().getKind()) && (classDecl.getBody() == null || classDecl.getBody().getStatements().isEmpty()) && classDecl.getLeadingAnnotations().isEmpty() && classDecl.getExtends() == null && classDecl.getImplements() == null) {
                    return (J)SearchResult.found((Tree)classDecl);
                }
                return super.visitClassDeclaration(classDecl, ctx);
            }
        };
    }
}

