/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.format.LineEndingsCount;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.style.GeneralFormatStyle;

public class AutodetectGeneralFormatStyle
extends JavaIsoVisitor<LineEndingsCount> {
    AutodetectJavadocVisitor javadocVisitor = new AutodetectJavadocVisitor();

    public static GeneralFormatStyle autodetectGeneralFormatStyle(JavaSourceFile j) {
        LineEndingsCount count = new LineEndingsCount();
        new AutodetectGeneralFormatStyle().visit(j, count);
        if (count.lf >= count.crlf) {
            return new GeneralFormatStyle(false);
        }
        return new GeneralFormatStyle(true);
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, LineEndingsCount count) {
        AutodetectGeneralFormatStyle.processString(space.getWhitespace(), count);
        for (Comment comment : space.getComments()) {
            if (comment instanceof TextComment) {
                AutodetectGeneralFormatStyle.processString(((TextComment)comment).getText(), count);
                continue;
            }
            if (!(comment instanceof Javadoc)) continue;
            this.javadocVisitor.visit((Javadoc)((Object)comment), count);
        }
        return space;
    }

    private static void processString(String s, LineEndingsCount count) {
        for (int i = 0; i < s.length(); ++i) {
            char current = s.charAt(i);
            char next = '\u0000';
            if (i < s.length() - 1) {
                next = s.charAt(i + 1);
            }
            if (current == '\r' && next == '\n') {
                ++count.crlf;
                ++i;
                continue;
            }
            if (current != '\n') continue;
            ++count.lf;
        }
    }

    private class AutodetectJavadocVisitor
    extends JavadocVisitor<LineEndingsCount> {
        public AutodetectJavadocVisitor() {
            super(AutodetectGeneralFormatStyle.this);
        }

        @Override
        public Javadoc visitLineBreak(Javadoc.LineBreak lineBreak, LineEndingsCount lineEndingsCount) {
            AutodetectGeneralFormatStyle.processString(lineBreak.getMargin(), lineEndingsCount);
            return lineBreak;
        }
    }
}

