/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.search.FindGradleProject;
import org.openrewrite.gradle.util.DistributionInfos;
import org.openrewrite.gradle.util.GradleWrapper;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.text.PlainText;

public class UpdateGradleWrapper
extends ScanningRecipe<GradleWrapperState> {
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. Defaults to the latest release available from services.gradle.org if not specified.", example="7.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Distribution type", description="The distribution of Gradle to use. \"bin\" includes Gradle binaries. \"all\" includes Gradle binaries, source code, and documentation. Defaults to \"bin\".", valid={"bin", "all"}, required=false)
    private final @Nullable String distribution;
    @Option(displayName="Add if missing", description="Add a Gradle wrapper, if it's missing. Defaults to `true`.", required=false)
    private final @Nullable Boolean addIfMissing;
    @Option(example="https://services.gradle.org/distributions/gradle-${version}-${distribution}.zip", displayName="Wrapper URI", description="The URI of the Gradle wrapper distribution. Lookup of available versions still requires access to https://services.gradle.org When this is specified the exact literal values supplied for `version` and `distribution` will be interpolated into this string wherever `${version}` and `${distribution}` appear respectively. Defaults to https://services.gradle.org/distributions/gradle-${version}-${distribution}.zip.", required=false)
    private final @Nullable String wrapperUri;
    @Option(example="29e49b10984e585d8118b7d0bc452f944e386458df27371b49b4ac1dec4b7fda", displayName="SHA-256 checksum", description="The SHA-256 checksum of the Gradle distribution. If specified, the recipe will add the checksum along with the custom distribution URL.", required=false)
    private final @Nullable String distributionChecksum;
    private transient @Nullable GradleWrapper gradleWrapper;

    public String getDisplayName() {
        return "Update Gradle wrapper";
    }

    public String getDescription() {
        return "Update the version of Gradle used in an existing Gradle wrapper. Queries services.gradle.org to determine the available releases, but prefers the artifact repository URL which already exists within the wrapper properties file. If your artifact repository does not contain the same Gradle distributions as services.gradle.org, then the recipe may suggest a version which is not available in your artifact repository.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.wrapperUri != null && (this.version != null || this.distribution != null)) {
            return Validated.invalid((String)"wrapperUri", (Object)this.wrapperUri, (String)"WrapperUri cannot be used with version and/or distribution parameter");
        }
        if (this.wrapperUri == null && this.distributionChecksum != null) {
            return Validated.invalid((String)"distributionChecksum", (Object)this.distributionChecksum, (String)"DistributionChecksum can only be used with wrapperUri");
        }
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    private GradleWrapper getGradleWrapper(ExecutionContext ctx) {
        if (this.gradleWrapper == null) {
            if (this.wrapperUri != null) {
                this.gradleWrapper = GradleWrapper.create(URI.create(this.wrapperUri), ctx);
                return this.gradleWrapper;
            }
            try {
                this.gradleWrapper = GradleWrapper.create(this.distribution, this.version, null, ctx);
            }
            catch (Exception e) {
                if (!StringUtils.isBlank((String)this.version) && Semver.validate((String)this.version, null).getValue() instanceof ExactVersion) {
                    this.gradleWrapper = new GradleWrapper(this.version, new DistributionInfos("", null, null));
                    return this.gradleWrapper;
                }
                throw new IllegalArgumentException("Could not reach services.gradle.org. To use this recipe in environments where services.gradle.org is unavailable specify a wrapperUri or exact version.", e);
            }
        }
        return this.gradleWrapper;
    }

    public GradleWrapperState getInitialValue(ExecutionContext ctx) {
        return new GradleWrapperState();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final GradleWrapperState acc) {
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{new PropertiesVisitor<ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                if (!super.isAcceptable(sourceFile, (Object)ctx)) {
                    return false;
                }
                if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_PROPERTIES_LOCATION)) {
                    acc.addGradleWrapperProperties = false;
                } else if (!PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.properties")) {
                    return false;
                }
                Optional maybeBuildTool = sourceFile.getMarkers().findFirst(BuildTool.class);
                if (!maybeBuildTool.isPresent()) {
                    return false;
                }
                BuildTool buildTool = (BuildTool)maybeBuildTool.get();
                if (buildTool.getType() != BuildTool.Type.Gradle) {
                    return false;
                }
                String gradleWrapperVersion = UpdateGradleWrapper.this.getGradleWrapper(ctx).getVersion();
                VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpdateGradleWrapper.this.version) ? "latest.release" : UpdateGradleWrapper.this.version), null).getValue());
                int compare = versionComparator.compare(null, buildTool.getVersion(), gradleWrapperVersion);
                if (compare < 0) {
                    acc.needsWrapperUpdate = true;
                    acc.updatedMarker = buildTool.withVersion(gradleWrapperVersion);
                    return true;
                }
                return compare == 0;
            }

            public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
                if (!"distributionUrl".equals(entry.getKey())) {
                    return entry;
                }
                String currentDistributionUrl = entry.getValue().getText();
                if (UpdateGradleWrapper.this.gradleWrapper == null) {
                    UpdateGradleWrapper.this.getGradleWrapper(ctx);
                }
                if (StringUtils.isBlank((String)UpdateGradleWrapper.this.gradleWrapper.getDistributionUrl()) && !StringUtils.isBlank((String)UpdateGradleWrapper.this.version) && Semver.validate((String)UpdateGradleWrapper.this.version, null).getValue() instanceof ExactVersion) {
                    String newDownloadUrl = currentDistributionUrl.replace("\\", "").replaceAll("(.*gradle-)(\\d+\\.\\d+(?:\\.\\d+)?)(.*-(?:bin|all).zip)", "$1" + UpdateGradleWrapper.this.gradleWrapper.getVersion() + "$3");
                    UpdateGradleWrapper.this.gradleWrapper = new GradleWrapper(UpdateGradleWrapper.this.version, new DistributionInfos(newDownloadUrl, null, null));
                }
                String wrapperHost = currentDistributionUrl.substring(0, currentDistributionUrl.lastIndexOf("/")) + "/gradle-";
                if (StringUtils.isBlank((String)UpdateGradleWrapper.this.wrapperUri) && !StringUtils.isBlank((String)UpdateGradleWrapper.this.gradleWrapper.getDistributionUrl()) && !UpdateGradleWrapper.this.gradleWrapper.getPropertiesFormattedUrl().startsWith(wrapperHost)) {
                    String newDownloadUrl = UpdateGradleWrapper.this.gradleWrapper.getDistributionUrl().replace("\\", "").replaceAll("(.*gradle-)(\\d+\\.\\d+(?:\\.\\d+)?)(.*-(?:bin|all).zip)", wrapperHost + UpdateGradleWrapper.this.gradleWrapper.getVersion() + "$3");
                    UpdateGradleWrapper.this.gradleWrapper = new GradleWrapper(UpdateGradleWrapper.this.gradleWrapper.getVersion(), new DistributionInfos(newDownloadUrl, null, null));
                }
                if (!UpdateGradleWrapper.this.gradleWrapper.getPropertiesFormattedUrl().equals(currentDistributionUrl)) {
                    acc.needsWrapperUpdate = true;
                }
                return entry;
            }
        }, new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                if (new FindGradleProject(FindGradleProject.SearchCriteria.Marker).getVisitor().visitNonNull((Tree)sourceFile, (Object)ctx) != sourceFile) {
                    acc.gradleProject = true;
                }
                if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_JAR_LOCATION)) {
                    acc.addGradleWrapperJar = false;
                    return true;
                }
                if (sourceFile instanceof PlainText) {
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_BATCH_LOCATION)) {
                        acc.addGradleBatchScript = false;
                        return true;
                    }
                    if (PathUtils.equalIgnoringSeparators((Path)sourceFile.getSourcePath(), (Path)GradleWrapper.WRAPPER_SCRIPT_LOCATION)) {
                        acc.addGradleShellScript = false;
                        return true;
                    }
                }
                return false;
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                return tree;
            }
        }});
    }

    public Collection<SourceFile> generate(GradleWrapperState acc, ExecutionContext ctx) {
        if (Boolean.FALSE.equals(this.addIfMissing)) {
            return Collections.emptyList();
        }
        if (!acc.gradleProject) {
            return Collections.emptyList();
        }
        if (!(acc.addGradleWrapperJar || acc.addGradleWrapperProperties || acc.addGradleBatchScript || acc.addGradleShellScript)) {
            return Collections.emptyList();
        }
        ArrayList<SourceFile> gradleWrapperFiles = new ArrayList<SourceFile>();
        ZonedDateTime now = ZonedDateTime.now();
        GradleWrapper gradleWrapper = this.getGradleWrapper(ctx);
        if (acc.addGradleWrapperProperties) {
            String checksum;
            String string = checksum = gradleWrapper.getDistributionChecksum() == null ? null : gradleWrapper.getDistributionChecksum().getHexValue();
            if (this.wrapperUri != null && this.distributionChecksum != null && checksum == null) {
                checksum = this.distributionChecksum;
            }
            Properties.File gradleWrapperProperties = (Properties.File)((SourceFile)new PropertiesParser().parse(new String[]{"distributionBase=GRADLE_USER_HOME\ndistributionPath=wrapper/dists\ndistributionUrl=" + gradleWrapper.getPropertiesFormattedUrl() + "\n" + (checksum == null ? "" : "distributionSha256Sum=" + checksum + "\n") + "zipStoreBase=GRADLE_USER_HOME\nzipStorePath=wrapper/dists"}).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not parse as properties"))).withSourcePath(GradleWrapper.WRAPPER_PROPERTIES_LOCATION);
            gradleWrapperFiles.add((SourceFile)gradleWrapperProperties);
        }
        FileAttributes wrapperScriptAttributes = new FileAttributes(now, now, now, true, true, true, 1L);
        if (acc.addGradleShellScript) {
            String gradlewText = this.unixScript(gradleWrapper, ctx);
            PlainText gradlew = PlainText.builder().text(gradlewText).sourcePath(GradleWrapper.WRAPPER_SCRIPT_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            gradleWrapperFiles.add((SourceFile)gradlew);
        }
        if (acc.addGradleBatchScript) {
            String gradlewBatText = this.batchScript(gradleWrapper, ctx);
            PlainText gradlewBat = PlainText.builder().text(gradlewBatText).sourcePath(GradleWrapper.WRAPPER_BATCH_LOCATION).fileAttributes(wrapperScriptAttributes).build();
            gradleWrapperFiles.add((SourceFile)gradlewBat);
        }
        if (acc.addGradleWrapperJar) {
            gradleWrapperFiles.add((SourceFile)gradleWrapper.wrapperJar());
        }
        return gradleWrapperFiles;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final GradleWrapperState acc) {
        if (!acc.needsWrapperUpdate) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Optional maybeCurrentMarker;
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (acc.updatedMarker != null && (maybeCurrentMarker = sourceFile.getMarkers().findFirst(BuildTool.class)).isPresent()) {
                    BuildTool currentMarker = (BuildTool)maybeCurrentMarker.get();
                    if (currentMarker.getType() != BuildTool.Type.Gradle) {
                        return sourceFile;
                    }
                    VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)(StringUtils.isBlank((String)UpdateGradleWrapper.this.version) ? "latest.release" : UpdateGradleWrapper.this.version), null).getValue());
                    int compare = versionComparator.compare(null, currentMarker.getVersion(), acc.updatedMarker.getVersion());
                    if (compare < 0) {
                        sourceFile = (SourceFile)sourceFile.withMarkers(sourceFile.getMarkers().setByType((Marker)acc.updatedMarker));
                    } else {
                        return sourceFile;
                    }
                }
                GradleWrapper gradleWrapper = UpdateGradleWrapper.this.getGradleWrapper(ctx);
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradlew")) {
                    PlainText gradlew;
                    String gradlewText = UpdateGradleWrapper.this.unixScript(gradleWrapper, ctx);
                    if (!gradlewText.equals((gradlew = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile)).getText())) {
                        gradlew = gradlew.withText(gradlewText);
                    }
                    return gradlew;
                }
                if (sourceFile instanceof PlainText && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradlew.bat")) {
                    PlainText gradlewBat;
                    String gradlewBatText = UpdateGradleWrapper.this.batchScript(gradleWrapper, ctx);
                    if (!gradlewBatText.equals((gradlewBat = (PlainText)UpdateGradleWrapper.setExecutable(sourceFile)).getText())) {
                        gradlewBat = gradlewBat.withText(gradlewBatText);
                    }
                    return gradlewBat;
                }
                if (sourceFile instanceof Properties.File && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.properties")) {
                    return new WrapperPropertiesVisitor(gradleWrapper).visitNonNull((Tree)sourceFile, ctx);
                }
                if ((sourceFile instanceof Quark || sourceFile instanceof Remote) && PathUtils.matchesGlob((Path)sourceFile.getSourcePath(), (String)"**/gradle/wrapper/gradle-wrapper.jar")) {
                    return gradleWrapper.wrapperJar(sourceFile);
                }
                return sourceFile;
            }
        };
    }

    private static <T extends SourceFile> T setExecutable(T sourceFile) {
        FileAttributes attributes = sourceFile.getFileAttributes();
        if (attributes == null) {
            ZonedDateTime now = ZonedDateTime.now();
            return (T)sourceFile.withFileAttributes(new FileAttributes(now, now, now, true, true, true, 1L));
        }
        if (!attributes.isExecutable()) {
            return (T)sourceFile.withFileAttributes(attributes.withExecutable(true));
        }
        return sourceFile;
    }

    private String unixScript(GradleWrapper gradleWrapper, ExecutionContext ctx) {
        HashMap<String, String> binding = new HashMap<String, String>();
        String defaultJvmOpts = this.defaultJvmOpts(gradleWrapper);
        binding.put("defaultJvmOpts", StringUtils.isNotEmpty((String)defaultJvmOpts) ? "'" + defaultJvmOpts + "'" : "");
        binding.put("classpath", "$APP_HOME/gradle/wrapper/gradle-wrapper.jar");
        String gradlewTemplate = StringUtils.readFully((InputStream)gradleWrapper.gradlew().getInputStream(ctx));
        return this.renderTemplate(gradlewTemplate, binding, "\n");
    }

    private String batchScript(GradleWrapper gradleWrapper, ExecutionContext ctx) {
        HashMap<String, String> binding = new HashMap<String, String>();
        binding.put("defaultJvmOpts", this.defaultJvmOpts(gradleWrapper));
        binding.put("classpath", "%APP_HOME%\\gradle\\wrapper\\gradle-wrapper.jar");
        String gradlewBatTemplate = StringUtils.readFully((InputStream)gradleWrapper.gradlewBat().getInputStream(ctx));
        return this.renderTemplate(gradlewBatTemplate, binding, "\r\n");
    }

    private String defaultJvmOpts(GradleWrapper gradleWrapper) {
        VersionComparator gradle53VersionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)"[5.3,)", null).getValue());
        VersionComparator gradle50VersionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)"[5.0,)", null).getValue());
        if (gradle53VersionComparator.isValid(null, gradleWrapper.getVersion())) {
            return "\"-Xmx64m\" \"-Xms64m\"";
        }
        if (gradle50VersionComparator.isValid(null, gradleWrapper.getVersion())) {
            return "\"-Xmx64m\"";
        }
        return "";
    }

    private String renderTemplate(String source, Map<String, String> parameters, String lineSeparator) {
        HashMap<String, String> binding = new HashMap<String, String>(parameters);
        binding.put("applicationName", "Gradle");
        binding.put("optsEnvironmentVar", "GRADLE_OPTS");
        binding.put("exitEnvironmentVar", "GRADLE_EXIT_CONSOLE");
        binding.put("mainClassName", "org.gradle.wrapper.GradleWrapperMain");
        binding.put("appNameSystemProperty", "org.gradle.appname");
        binding.put("appHomeRelativePath", "");
        binding.put("modulePath", "");
        String script = source;
        for (Map.Entry variable : binding.entrySet()) {
            script = script.replace("${" + (String)variable.getKey() + "}", (CharSequence)variable.getValue()).replace("$" + (String)variable.getKey(), (CharSequence)variable.getValue());
        }
        script = script.replaceAll("(?sm)<% /\\*.*?\\*/ %>", "");
        script = script.replaceAll("(?sm)<% if \\( mainClassName\\.startsWith\\('--module '\\) \\) \\{.*?} %>", "");
        script = script.replaceAll("(?sm)<% if \\( appNameSystemProperty \\) \\{.*?%>(.*?)<% } %>", "$1");
        script = script.replace("\\$", "$");
        script = script.replaceAll("DIRNAME=\\.\\\\[\r\n]", "DIRNAME=.");
        script = script.replace("\\\\", "\\");
        script = script.replaceAll("\r\n|\r|\n", lineSeparator);
        return script;
    }

    @Generated
    public UpdateGradleWrapper(@Nullable String version, @Nullable String distribution, @Nullable Boolean addIfMissing, @Nullable String wrapperUri, @Nullable String distributionChecksum) {
        this.version = version;
        this.distribution = distribution;
        this.addIfMissing = addIfMissing;
        this.wrapperUri = wrapperUri;
        this.distributionChecksum = distributionChecksum;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateGradleWrapper)) {
            return false;
        }
        UpdateGradleWrapper other = (UpdateGradleWrapper)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        if (this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$distribution = this.getDistribution();
        String other$distribution = other.getDistribution();
        if (this$distribution == null ? other$distribution != null : !this$distribution.equals(other$distribution)) {
            return false;
        }
        String this$wrapperUri = this.getWrapperUri();
        String other$wrapperUri = other.getWrapperUri();
        if (this$wrapperUri == null ? other$wrapperUri != null : !this$wrapperUri.equals(other$wrapperUri)) {
            return false;
        }
        String this$distributionChecksum = this.getDistributionChecksum();
        String other$distributionChecksum = other.getDistributionChecksum();
        return !(this$distributionChecksum == null ? other$distributionChecksum != null : !this$distributionChecksum.equals(other$distributionChecksum));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpdateGradleWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $distribution = this.getDistribution();
        result = result * 59 + ($distribution == null ? 43 : $distribution.hashCode());
        String $wrapperUri = this.getWrapperUri();
        result = result * 59 + ($wrapperUri == null ? 43 : $wrapperUri.hashCode());
        String $distributionChecksum = this.getDistributionChecksum();
        result = result * 59 + ($distributionChecksum == null ? 43 : $distributionChecksum.hashCode());
        return result;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getDistribution() {
        return this.distribution;
    }

    @Generated
    public @Nullable Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    @Generated
    public @Nullable String getWrapperUri() {
        return this.wrapperUri;
    }

    @Generated
    public @Nullable String getDistributionChecksum() {
        return this.distributionChecksum;
    }

    public static class GradleWrapperState {
        boolean gradleProject = false;
        boolean needsWrapperUpdate = false;
        @Nullable BuildTool updatedMarker;
        boolean addGradleWrapperProperties = true;
        boolean addGradleWrapperJar = true;
        boolean addGradleShellScript = true;
        boolean addGradleBatchScript = true;

        @Generated
        public GradleWrapperState() {
        }

        @Generated
        public boolean isGradleProject() {
            return this.gradleProject;
        }

        @Generated
        public boolean isNeedsWrapperUpdate() {
            return this.needsWrapperUpdate;
        }

        @Generated
        public @Nullable BuildTool getUpdatedMarker() {
            return this.updatedMarker;
        }

        @Generated
        public boolean isAddGradleWrapperProperties() {
            return this.addGradleWrapperProperties;
        }

        @Generated
        public boolean isAddGradleWrapperJar() {
            return this.addGradleWrapperJar;
        }

        @Generated
        public boolean isAddGradleShellScript() {
            return this.addGradleShellScript;
        }

        @Generated
        public boolean isAddGradleBatchScript() {
            return this.addGradleBatchScript;
        }

        @Generated
        public void setGradleProject(boolean gradleProject) {
            this.gradleProject = gradleProject;
        }

        @Generated
        public void setNeedsWrapperUpdate(boolean needsWrapperUpdate) {
            this.needsWrapperUpdate = needsWrapperUpdate;
        }

        @Generated
        public void setUpdatedMarker(@Nullable BuildTool updatedMarker) {
            this.updatedMarker = updatedMarker;
        }

        @Generated
        public void setAddGradleWrapperProperties(boolean addGradleWrapperProperties) {
            this.addGradleWrapperProperties = addGradleWrapperProperties;
        }

        @Generated
        public void setAddGradleWrapperJar(boolean addGradleWrapperJar) {
            this.addGradleWrapperJar = addGradleWrapperJar;
        }

        @Generated
        public void setAddGradleShellScript(boolean addGradleShellScript) {
            this.addGradleShellScript = addGradleShellScript;
        }

        @Generated
        public void setAddGradleBatchScript(boolean addGradleBatchScript) {
            this.addGradleBatchScript = addGradleBatchScript;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleWrapperState)) {
                return false;
            }
            GradleWrapperState other = (GradleWrapperState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isGradleProject() != other.isGradleProject()) {
                return false;
            }
            if (this.isNeedsWrapperUpdate() != other.isNeedsWrapperUpdate()) {
                return false;
            }
            if (this.isAddGradleWrapperProperties() != other.isAddGradleWrapperProperties()) {
                return false;
            }
            if (this.isAddGradleWrapperJar() != other.isAddGradleWrapperJar()) {
                return false;
            }
            if (this.isAddGradleShellScript() != other.isAddGradleShellScript()) {
                return false;
            }
            if (this.isAddGradleBatchScript() != other.isAddGradleBatchScript()) {
                return false;
            }
            BuildTool this$updatedMarker = this.getUpdatedMarker();
            BuildTool other$updatedMarker = other.getUpdatedMarker();
            return !(this$updatedMarker == null ? other$updatedMarker != null : !this$updatedMarker.equals(other$updatedMarker));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof GradleWrapperState;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isGradleProject() ? 79 : 97);
            result = result * 59 + (this.isNeedsWrapperUpdate() ? 79 : 97);
            result = result * 59 + (this.isAddGradleWrapperProperties() ? 79 : 97);
            result = result * 59 + (this.isAddGradleWrapperJar() ? 79 : 97);
            result = result * 59 + (this.isAddGradleShellScript() ? 79 : 97);
            result = result * 59 + (this.isAddGradleBatchScript() ? 79 : 97);
            BuildTool $updatedMarker = this.getUpdatedMarker();
            result = result * 59 + ($updatedMarker == null ? 43 : $updatedMarker.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpdateGradleWrapper.GradleWrapperState(gradleProject=" + this.isGradleProject() + ", needsWrapperUpdate=" + this.isNeedsWrapperUpdate() + ", updatedMarker=" + this.getUpdatedMarker() + ", addGradleWrapperProperties=" + this.isAddGradleWrapperProperties() + ", addGradleWrapperJar=" + this.isAddGradleWrapperJar() + ", addGradleShellScript=" + this.isAddGradleShellScript() + ", addGradleBatchScript=" + this.isAddGradleBatchScript() + ")";
        }
    }

    private static class WrapperPropertiesVisitor
    extends PropertiesVisitor<ExecutionContext> {
        private static final String DISTRIBUTION_SHA_256_SUM_KEY = "distributionSha256Sum";
        private final GradleWrapper gradleWrapper;

        public WrapperPropertiesVisitor(GradleWrapper gradleWrapper) {
            this.gradleWrapper = gradleWrapper;
        }

        public Properties visitFile(Properties.File file, ExecutionContext ctx) {
            Properties p = super.visitFile(file, (Object)ctx);
            Set checksumKey = FindProperties.find((Properties)p, (String)DISTRIBUTION_SHA_256_SUM_KEY, (Boolean)false);
            if (checksumKey.isEmpty() && this.gradleWrapper.getDistributionChecksum() != null) {
                Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, this.gradleWrapper.getDistributionChecksum().getHexValue());
                Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, DISTRIBUTION_SHA_256_SUM_KEY, "", Properties.Entry.Delimiter.EQUALS, propertyValue);
                List contentList = ListUtils.concat((List)((Properties.File)p).getContent(), (Object)entry);
                p = ((Properties.File)p).withContent(contentList);
            } else if (!checksumKey.isEmpty() && this.gradleWrapper.getDistributionChecksum() == null) {
                List contentList = ListUtils.map((List)((Properties.File)p).getContent(), c -> {
                    if (c instanceof Properties.Entry && DISTRIBUTION_SHA_256_SUM_KEY.equals(((Properties.Entry)c).getKey())) {
                        return null;
                    }
                    return c;
                });
                p = ((Properties.File)p).withContent(contentList);
            }
            return p;
        }

        public Properties visitEntry(Properties.Entry entry, ExecutionContext ctx) {
            if ("distributionUrl".equals(entry.getKey())) {
                Properties.Value value = entry.getValue();
                return entry.withValue(value.withText(this.gradleWrapper.getPropertiesFormattedUrl()));
            }
            if (DISTRIBUTION_SHA_256_SUM_KEY.equals(entry.getKey()) && this.gradleWrapper.getDistributionChecksum() != null) {
                return entry.withValue(entry.getValue().withText(this.gradleWrapper.getDistributionChecksum().getHexValue()));
            }
            return entry;
        }
    }
}

