/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.Marker;
import org.openrewrite.semver.DependencyMatcher;

public final class RemoveDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="The dependency configuration", description="The dependency configuration to remove from.", example="api", required=false)
    private final @Nullable String configuration;

    public String getDisplayName() {
        return "Remove a Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupId, this.artifactId);
    }

    public String getDescription() {
        return "Removes a single dependency from the dependencies section of the `build.gradle`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            final GradleDependency.Matcher gradleDependencyMatcher;
            final DependencyMatcher depMatcher;
            GradleProject gradleProject;
            {
                this.gradleDependencyMatcher = new GradleDependency.Matcher().configuration(RemoveDependency.this.configuration).groupId(RemoveDependency.this.groupId).artifactId(RemoveDependency.this.artifactId);
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(RemoveDependency.this.groupId + ":" + RemoveDependency.this.artifactId)).getValue());
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return cu;
                }
                this.gradleProject = (GradleProject)maybeGp.get();
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                if (g != cu) {
                    g = g.withMarkers(g.getMarkers().setByType((Marker)this.updateGradleModel(this.gradleProject)));
                }
                return g;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.Return visitReturn(J.Return return_, ExecutionContext ctx) {
                boolean dependencyInvocation = return_.getExpression() instanceof J.MethodInvocation && this.gradleDependencyMatcher.get((Tree)return_.getExpression(), this.getCursor()).isPresent();
                J.Return r = super.visitReturn(return_, (Object)ctx);
                if (dependencyInvocation && r.getExpression() == null) {
                    return null;
                }
                return r;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (this.gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                    return null;
                }
                return m;
            }

            private GradleProject updateGradleModel(GradleProject gp) {
                Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
                HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
                boolean anyChanged = false;
                for (GradleDependencyConfiguration gdc : nameToConfiguration.values()) {
                    if (!StringUtils.isBlank((String)RemoveDependency.this.configuration) && RemoveDependency.this.configuration.equals(gdc.getName())) {
                        newNameToConfiguration.put(gdc.getName(), gdc);
                        continue;
                    }
                    GradleDependencyConfiguration newGdc = gdc;
                    newGdc = newGdc.withRequested(ListUtils.map(gdc.getRequested(), requested -> {
                        if (this.depMatcher.matches(requested.getGroupId(), requested.getArtifactId())) {
                            return null;
                        }
                        return requested;
                    }));
                    anyChanged |= (newGdc = newGdc.withDirectResolved(ListUtils.map(gdc.getDirectResolved(), resolved -> {
                        if (this.depMatcher.matches(resolved.getGroupId(), resolved.getArtifactId())) {
                            return null;
                        }
                        return resolved;
                    }))) != gdc;
                    newNameToConfiguration.put(newGdc.getName(), newGdc);
                }
                if (anyChanged) {
                    gp = gp.withNameToConfiguration(newNameToConfiguration);
                }
                return gp;
            }
        });
    }

    @Generated
    public RemoveDependency(String groupId, String artifactId, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.configuration = configuration;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveDependency)) {
            return false;
        }
        RemoveDependency other = (RemoveDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

