/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Repeat;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;

public class UseLambdaForFunctionalInterface
extends Recipe {
    public String getDisplayName() {
        return "Use lambda expressions instead of anonymous classes";
    }

    public String getDescription() {
        return "Instead of anonymous class declarations, use a lambda where possible. Using lambdas to replace anonymous classes can lead to more expressive and maintainable code, improve code readability, reduce code duplication, and achieve better performance in some cases.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1604");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Repeat.repeatUntilStable((TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Enum) {
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }

            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                JavaType.FullyQualified type;
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
                this.updateCursor((Tree)n);
                if (n.getBody() != null && n.getBody().getStatements().size() == 1 && n.getBody().getStatements().get(0) instanceof J.MethodDeclaration && n.getClazz() != null && (type = TypeUtils.asFullyQualified((JavaType)n.getClazz().getType())) != null && type.getKind() == JavaType.FullyQualified.Kind.Interface) {
                    JavaType.Method sam = UseLambdaForFunctionalInterface.getSamCompatible((JavaType)type);
                    if (sam == null) {
                        return n;
                    }
                    if (UseLambdaForFunctionalInterface.usesThis(this.getCursor()) || UseLambdaForFunctionalInterface.shadowsLocalVariable(this.getCursor()) || UseLambdaForFunctionalInterface.usedAsStatement(this.getCursor()) || UseLambdaForFunctionalInterface.fieldInitializerReferencingUninitializedField(this.getCursor())) {
                        return n;
                    }
                    JavaType.FullyQualified typedInterface = null;
                    JavaType.FullyQualified anonymousClass = TypeUtils.asFullyQualified((JavaType)n.getType());
                    if (anonymousClass != null) {
                        typedInterface = anonymousClass.getInterfaces().stream().filter(i -> i.getFullyQualifiedName().equals(type.getFullyQualifiedName())).findFirst().orElse(null);
                    }
                    if (typedInterface == null) {
                        return n;
                    }
                    StringBuilder templateBuilder = new StringBuilder();
                    J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)n.getBody().getStatements().get(0);
                    if (methodDeclaration.getTypeParameters() != null && !methodDeclaration.getTypeParameters().isEmpty()) {
                        return n;
                    }
                    if (methodDeclaration.getParameters().get(0) instanceof J.Empty) {
                        templateBuilder.append("() -> {");
                    } else {
                        templateBuilder.append(methodDeclaration.getParameters().stream().map(param -> ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)param).getVariables().get(0)).getSimpleName()).collect(Collectors.joining(",", "(", ") -> {")));
                    }
                    JavaType returnType = sam.getReturnType();
                    if (JavaType.Primitive.Void != returnType) {
                        templateBuilder.append("return ").append(this.valueOfType(returnType)).append(';');
                    }
                    templateBuilder.append('}');
                    J.Lambda lambda = (J.Lambda)JavaTemplate.builder((String)templateBuilder.toString()).contextSensitive().build().apply(this.getCursor(), n.getCoordinates().replace(), new Object[0]);
                    lambda = lambda.withType((JavaType)typedInterface);
                    lambda = (J.Lambda)new UnnecessaryParenthesesVisitor().visitNonNull((Tree)lambda, (Object)ctx, this.getCursor().getParentOrThrow());
                    J.Block lambdaBody = methodDeclaration.getBody();
                    assert (lambdaBody != null);
                    lambda = lambda.withBody((J)lambdaBody.withPrefix(Space.format((String)" ")));
                    lambda = (J.Lambda)new LambdaBlockToExpression().getVisitor().visitNonNull((Tree)lambda, (Object)ctx, this.getCursor().getParentOrThrow());
                    this.doAfterVisit(new RemoveUnusedImports().getVisitor());
                    return this.autoFormat(this.maybeAddCast(lambda, newClass), ctx);
                }
                return n;
            }

            private J maybeAddCast(J.Lambda lambda, J.NewClass original) {
                J parent = (J)this.getCursor().getParentTreeCursor().getValue();
                if (parent instanceof MethodCall) {
                    MethodCall method = (MethodCall)parent;
                    List arguments = method.getArguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        Expression argument = (Expression)arguments.get(i);
                        if (argument != original || !this.methodArgumentRequiresCast(lambda, method, i) || original.getClazz() == null) continue;
                        return new J.TypeCast(Tree.randomId(), lambda.getPrefix(), Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)original.getClazz())), (Expression)lambda.withPrefix(Space.format((String)" ")));
                    }
                }
                return lambda;
            }

            private boolean methodArgumentRequiresCast(J.Lambda lambda, MethodCall method, int argumentIndex) {
                JavaType.FullyQualified lambdaType = TypeUtils.asFullyQualified((JavaType)lambda.getType());
                if (lambdaType == null) {
                    return false;
                }
                String lambdaFqn = lambdaType.getFullyQualifiedName();
                JavaType.Method methodType = method.getMethodType();
                if (methodType == null) {
                    return false;
                }
                if (!TypeUtils.isOfClassType((JavaType)((JavaType)methodType.getParameterTypes().get(argumentIndex)), (String)lambdaFqn)) {
                    return true;
                }
                int count = 0;
                for (JavaType.Method maybeAmbiguous : methodType.getDeclaringType().getMethods()) {
                    if (!methodType.getName().equals(maybeAmbiguous.getName()) || methodType.getParameterTypes().size() != maybeAmbiguous.getParameterTypes().size() || !this.areMethodsAmbiguous(UseLambdaForFunctionalInterface.getSamCompatible((JavaType)methodType.getParameterTypes().get(argumentIndex)), UseLambdaForFunctionalInterface.getSamCompatible((JavaType)maybeAmbiguous.getParameterTypes().get(argumentIndex)))) continue;
                    ++count;
                }
                if (count >= 2) {
                    return true;
                }
                return UseLambdaForFunctionalInterface.hasGenerics(lambda);
            }

            private boolean areMethodsAmbiguous(// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Method m1, // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable JavaType.Method m2) {
                if (m1 == null || m2 == null || m1.getParameterTypes().size() != m2.getParameterTypes().size()) {
                    return false;
                }
                if (m1 == m2) {
                    return true;
                }
                for (int i = 0; i < m1.getParameterTypes().size(); ++i) {
                    JavaType m2i;
                    JavaType m1i = (JavaType)m1.getParameterTypes().get(i);
                    if (TypeUtils.isAssignableTo((JavaType)m1i, (JavaType)(m2i = (JavaType)m2.getParameterTypes().get(i))) || TypeUtils.isAssignableTo((JavaType)m2i, (JavaType)m1i)) continue;
                    return false;
                }
                return true;
            }

            private String valueOfType(@Nullable JavaType type) {
                JavaType.Primitive primitive = TypeUtils.asPrimitive((JavaType)type);
                if (primitive != null) {
                    switch (primitive) {
                        case Boolean: {
                            return "true";
                        }
                        case Byte: 
                        case Char: 
                        case Int: 
                        case Double: 
                        case Float: 
                        case Long: 
                        case Short: {
                            return "0";
                        }
                        case String: 
                        case Null: {
                            return "null";
                        }
                    }
                    return "";
                }
                return "null";
            }
        });
    }

    private static boolean usesThis(Cursor cursor) {
        J.NewClass n = (J.NewClass)cursor.getValue();
        assert (n.getBody() != null);
        final AtomicBoolean hasThis = new AtomicBoolean(false);
        new JavaVisitor<Integer>(){

            public J visitIdentifier(J.Identifier ident, Integer integer) {
                if (ident.getSimpleName().equals("this")) {
                    hasThis.set(true);
                }
                return super.visitIdentifier(ident, (Object)integer);
            }
        }.visit((Tree)n.getBody(), (Object)0, cursor);
        return hasThis.get();
    }

    private static List<String> parameterNames(J.MethodDeclaration method) {
        return method.getParameters().stream().filter(J.VariableDeclarations.class::isInstance).map(v -> ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)v).getVariables().get(0)).getSimpleName()).collect(Collectors.toList());
    }

    private static List<String> classFields(J.ClassDeclaration classDeclaration) {
        return classDeclaration.getBody().getStatements().stream().filter(J.VariableDeclarations.class::isInstance).map(v -> ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)v).getVariables().get(0)).getSimpleName()).collect(Collectors.toList());
    }

    private static boolean usedAsStatement(Cursor cursor) {
        Iterator path = cursor.getParentOrThrow().getPath();
        Object last = cursor.getValue();
        while (path.hasNext()) {
            Object next = path.next();
            if (next instanceof J.Block) {
                return true;
            }
            if (next instanceof J && !(next instanceof J.MethodInvocation)) {
                return false;
            }
            if (next instanceof J.MethodInvocation) {
                for (Expression argument : ((J.MethodInvocation)next).getArguments()) {
                    if (argument != last) continue;
                    return false;
                }
            }
            if (!(next instanceof J)) continue;
            last = next;
        }
        return false;
    }

    private static boolean fieldInitializerReferencingUninitializedField(Cursor cursor) {
        J.NewClass n = (J.NewClass)cursor.getValue();
        assert (n.getBody() != null);
        Cursor parent = cursor.dropParentUntil(is -> is instanceof J.VariableDeclarations.NamedVariable || is instanceof SourceFile);
        Object parentValue = parent.getValue();
        if (!(parentValue instanceof J.VariableDeclarations.NamedVariable)) {
            return false;
        }
        J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)cursor.firstEnclosing(J.VariableDeclarations.NamedVariable.class);
        if (variable == null || variable.getInitializer() == null) {
            return false;
        }
        parent = cursor.dropParentUntil(is -> is instanceof J.MethodDeclaration || is instanceof J.ClassDeclaration || is instanceof SourceFile);
        parentValue = parent.getValue();
        if (!(parentValue instanceof J.ClassDeclaration) || ((J.ClassDeclaration)parentValue).getType() == null) {
            return false;
        }
        final JavaType.FullyQualified owner = ((J.ClassDeclaration)parentValue).getType();
        final AtomicBoolean referencesUninitializedFinalField = new AtomicBoolean(false);
        new JavaIsoVisitor<Integer>(){

            public J.Identifier visitIdentifier(J.Identifier ident, Integer integer) {
                if (referencesUninitializedFinalField.get()) {
                    return ident;
                }
                if (ident.getFieldType() != null && ident.getFieldType().hasFlags(new Flag[]{Flag.Final}) && !ident.getFieldType().hasFlags(new Flag[]{Flag.HasInit}) && owner.equals(ident.getFieldType().getOwner())) {
                    referencesUninitializedFinalField.set(true);
                }
                return super.visitIdentifier(ident, (Object)integer);
            }
        }.visit((Tree)n.getBody(), (Object)0, cursor);
        return referencesUninitializedFinalField.get();
    }

    private static boolean shadowsLocalVariable(Cursor cursor) {
        final J.NewClass n = (J.NewClass)cursor.getValue();
        assert (n.getBody() != null);
        final AtomicBoolean hasShadow = new AtomicBoolean(false);
        final ArrayList<String> localVariables = new ArrayList<String>();
        final ArrayList nameScopeBlocks = new ArrayList();
        J nameScope = (J)cursor.dropParentUntil(p -> {
            if (p instanceof J.Block) {
                nameScopeBlocks.add((J.Block)p);
            }
            return p instanceof J.MethodDeclaration || p instanceof J.ClassDeclaration;
        }).getValue();
        if (nameScope instanceof J.MethodDeclaration) {
            J.MethodDeclaration m = (J.MethodDeclaration)nameScope;
            localVariables.addAll(UseLambdaForFunctionalInterface.parameterNames(m));
            J.ClassDeclaration c = (J.ClassDeclaration)cursor.firstEnclosing(J.ClassDeclaration.class);
            assert (c != null);
            localVariables.addAll(UseLambdaForFunctionalInterface.classFields(c));
        } else {
            J.ClassDeclaration c = (J.ClassDeclaration)nameScope;
            localVariables.addAll(UseLambdaForFunctionalInterface.classFields(c));
        }
        new JavaVisitor<List<String>>(){

            public J visitVariable(J.VariableDeclarations.NamedVariable variable, List<String> variables) {
                variables.add(variable.getSimpleName());
                return variable;
            }

            public J visitBlock(J.Block block, List<String> strings) {
                return nameScopeBlocks.contains(block) ? super.visitBlock(block, strings) : block;
            }

            public J visitNewClass(J.NewClass newClass, List<String> variables) {
                if (newClass == n) {
                    this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
                }
                return newClass;
            }

            public @Nullable J visit(@Nullable Tree tree, List<String> variables) {
                if (this.getCursor().getNearestMessage("stop") != null) {
                    return (J)tree;
                }
                return (J)super.visit(tree, variables);
            }
        }.visit((Tree)nameScope, localVariables);
        new JavaVisitor<Integer>(){

            public J visitVariable(J.VariableDeclarations.NamedVariable variable, Integer integer) {
                if (localVariables.contains(variable.getSimpleName())) {
                    hasShadow.set(true);
                }
                return super.visitVariable(variable, (Object)integer);
            }
        }.visit((Tree)n.getBody(), (Object)0, cursor);
        return hasShadow.get();
    }

    private static boolean hasGenerics(J.Lambda lambda) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        new JavaVisitor<AtomicBoolean>(){

            public J visitMethodInvocation(J.MethodInvocation method, AtomicBoolean atomicBoolean) {
                if (method.getMethodType() != null && method.getMethodType().getParameterTypes().stream().anyMatch(p -> p instanceof JavaType.Parameterized && ((JavaType.Parameterized)p).getTypeParameters().stream().anyMatch(t -> t instanceof JavaType.GenericTypeVariable))) {
                    atomicBoolean.set(true);
                }
                return super.visitMethodInvocation(method, (Object)atomicBoolean);
            }
        }.visit((Tree)lambda.getBody(), (Object)atomicBoolean);
        return atomicBoolean.get();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable JavaType.Method getSamCompatible(@Nullable JavaType type) {
        JavaType.Method sam = null;
        JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)type);
        if (fullyQualified == null) {
            return null;
        }
        for (JavaType.Method method : fullyQualified.getMethods()) {
            if (method.hasFlags(new Flag[]{Flag.Default}) || method.hasFlags(new Flag[]{Flag.Static})) continue;
            if (sam != null) {
                return null;
            }
            sam = method;
        }
        return sam;
    }
}

