/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.ignore;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.openapitools.codegen.ignore.rules.DirectoryRule;
import org.openapitools.codegen.ignore.rules.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenIgnoreProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(CodegenIgnoreProcessor.class);
    private File ignoreFile = null;
    private List<Rule> exclusionRules = new ArrayList<Rule>();
    private List<Rule> inclusionRules = new ArrayList<Rule>();

    public CodegenIgnoreProcessor(String baseDirectory) {
        this(baseDirectory, ".openapi-generator-ignore");
    }

    public CodegenIgnoreProcessor(String baseDirectory, String ignoreFile) {
        File directory = new File(baseDirectory);
        File targetIgnoreFile = new File(directory, ignoreFile);
        if (directory.exists() && directory.isDirectory()) {
            this.loadFromFile(targetIgnoreFile);
        } else {
            this.LOGGER.info("Output directory ({}) does not exist, or is inaccessible. No file (.openapi-generator-ignore) will be evaluated.", (Object)baseDirectory);
        }
    }

    public CodegenIgnoreProcessor(File targetIgnoreFile) {
        this.loadFromFile(targetIgnoreFile);
    }

    private void loadFromFile(File targetIgnoreFile) {
        if (targetIgnoreFile.exists() && targetIgnoreFile.isFile()) {
            try {
                this.loadCodegenRules(targetIgnoreFile);
                this.ignoreFile = targetIgnoreFile;
            }
            catch (IOException e) {
                this.LOGGER.error(String.format(Locale.ROOT, "Could not process %s.", targetIgnoreFile.getName()), (Object)e.getMessage());
            }
        } else if (!".swagger-codegen-ignore".equals(targetIgnoreFile.getName())) {
            File legacyIgnoreFile = new File(targetIgnoreFile.getParentFile(), ".swagger-codegen-ignore");
            if (legacyIgnoreFile.exists() && legacyIgnoreFile.isFile()) {
                this.LOGGER.info(String.format(Locale.ROOT, "Legacy support: '%s' file renamed to '%s'.", legacyIgnoreFile.getName(), targetIgnoreFile.getName()));
                try {
                    Files.move(legacyIgnoreFile.toPath(), targetIgnoreFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.loadFromFile(targetIgnoreFile);
                }
                catch (IOException e) {
                    this.LOGGER.error(String.format(Locale.ROOT, "Could not rename file: %s", e.getMessage()));
                }
            } else {
                this.LOGGER.info(String.format(Locale.ROOT, "No %s file found.", targetIgnoreFile.getName()));
            }
        } else {
            this.LOGGER.info(String.format(Locale.ROOT, "No %s file found.", targetIgnoreFile.getName()));
        }
    }

    void loadCodegenRules(File codegenIgnore) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(codegenIgnore);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                Rule rule;
                if (line.length() == 0 || (rule = Rule.create(line)) == null) continue;
                if (Boolean.TRUE.equals(rule.getNegated())) {
                    this.inclusionRules.add(rule);
                    continue;
                }
                this.exclusionRules.add(rule);
            }
        }
    }

    public boolean allowsFile(File targetFile) {
        Rule.Operation op;
        Rule current;
        int i;
        if (this.ignoreFile == null) {
            return true;
        }
        File file = new File(this.ignoreFile.getAbsoluteFile().getParentFile().toURI().relativize(targetFile.toURI()).getPath());
        boolean directoryExcluded = false;
        boolean exclude = false;
        if (this.exclusionRules.size() == 0 && this.inclusionRules.size() == 0) {
            return true;
        }
        block6: for (i = 0; i < this.exclusionRules.size(); ++i) {
            current = this.exclusionRules.get(i);
            op = current.evaluate(file.getPath());
            switch (op) {
                case EXCLUDE: {
                    exclude = true;
                    if (!(current instanceof DirectoryRule)) continue block6;
                    directoryExcluded = true;
                    continue block6;
                }
                case INCLUDE: {
                    continue block6;
                }
                case NOOP: {
                    continue block6;
                }
                case EXCLUDE_AND_TERMINATE: {
                    i = this.exclusionRules.size();
                }
            }
        }
        if (exclude) {
            for (i = 0; exclude && i < this.inclusionRules.size(); ++i) {
                current = this.inclusionRules.get(i);
                op = current.evaluate(file.getPath());
                if (!op.equals((Object)Rule.Operation.INCLUDE)) continue;
                if (current instanceof DirectoryRule && directoryExcluded) {
                    exclude = false;
                    continue;
                }
                if (directoryExcluded) continue;
                exclude = false;
            }
        }
        return Boolean.FALSE.equals(exclude);
    }

    public List<Rule> getInclusionRules() {
        return Collections.unmodifiableList(this.inclusionRules);
    }

    public List<Rule> getExclusionRules() {
        return Collections.unmodifiableList(this.exclusionRules);
    }
}

