/*
 * #%L
 * Wikitty :: ui-zk
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.ui;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.Wikitty;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.event.ListDataEvent;

/**
 *
 * @author sherkhan
 */
public class WikittyModel extends AbstractListModel implements BindingListModel {

    List<Wikitty> _wikitties = new ArrayList<Wikitty>();

    @Override
    public Object getElementAt(int index) {
        return _wikitties.get(index);
    }

    @Override
    public int getSize() {
        return _wikitties.size();
    }

    @Override
    public int indexOf(Object obj) {
        return _wikitties.indexOf(obj);
    }

    public void setWikitties(List<Wikitty> wikitties) {
        _wikitties = new ArrayList<Wikitty>(wikitties);
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }

    public void addData(Wikitty newData) {
        _wikitties.add(newData);
        fireEvent(ListDataEvent.INTERVAL_ADDED, _wikitties.size() - 1, _wikitties.size() - 1);
    }

    public void removeData(Wikitty data) {
        int interval = _wikitties.indexOf(data);
        _wikitties.remove(data);
        fireEvent(ListDataEvent.INTERVAL_REMOVED, interval, interval);
    }

    public void reload() {
        fireEvent(ListDataEvent.CONTENTS_CHANGED, -1, -1);
    }
}
