/*
 * #%L
 * Wikitty :: ui-zk
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.ui;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

/**
 *
 * @author sherkhan
 */
public class Model {

    protected WikittyService _service = null;

    public Model(WikittyService service) {
        _service = service;
    }

    /*
     * Create
     */
    public void create(Wikitty wikitty) {
        _service.store(null, wikitty);
    }

    /*
     * Retrieve
     */
    public List<WikittyExtension> retrieveWikittyExtensions() {
        List<String> ids = _service.getAllExtensionIds(null);
        List<WikittyExtension> extensions = new ArrayList<WikittyExtension>();
        for (String id : ids) {
            WikittyExtension wikittyExtension = _service.restoreExtension(null, id);
            wikittyExtension = _service.restoreExtensionLastVersion(null, wikittyExtension.getName());
            if (extensions.contains(wikittyExtension) == false) {
                extensions.add(wikittyExtension);
            }
        }
        return extensions;
    }

    public List<Wikitty> retrieveWikittiesByExtensionName(String extensionName) {
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, extensionName).criteria();
        List<Wikitty> wikitties = _service.findAllByCriteria(null, criteria).cast(null, _service).getAll();
        return wikitties;
    }

    public List<Wikitty> retrieveWikittiesByKeyword(String search) {
        Criteria criteria = Search.query().keyword(search).criteria();
        List<Wikitty> wikitties = _service.findAllByCriteria(null, criteria).cast(null, _service).getAll();
        return wikitties;
    }

    /*
     * Update
     */
    public void update(Wikitty wikitty) {
        _service.store(null, wikitty);
    }

    /*
     * Delete
     */
    public void deleteWikittyById(String id) {
        _service.delete(null, id);
    }
}
