/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp.managed.BasicManagedDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;

public class WikittyJDBCUtil {
    private static Log log = LogFactory.getLog(WikittyJDBCUtil.class);
    public static final String COL_EXTENSION = "extension_list";
    public static final String COL_VERSION = "version";
    public static final String COL_ID = "id";
    public static final String COL_NAME = "name";
    public static final String COL_REQUIRES = "requires";
    public static final String COL_TAGVALUES = "tagvalues";
    public static final String COL_FIELDNAME = "fieldName";
    public static final String COL_FIELDTYPE = "fieldType";
    public static final String COL_BINARY_VALUE = "binaryValue";
    public static final String COL_BOOLEAN_VALUE = "booleanValue";
    public static final String COL_NUMBER_VALUE = "numberValue";
    public static final String COL_TEXT_VALUE = "textValue";
    public static final String COL_DATE_VALUE = "dateValue";
    public static final String COL_DELETION_DATE = "deletionDate";
    public static final String QUERY_SELECT = "jdbc.queries.select";
    public static final String QUERY_SELECT_NOTDELETED = "jdbc.queries.select.notdeleted";
    public static final String QUERY_SELECT_WHERE = "jdbc.queries.select.where";
    public static final String QUERY_SELECT_TWO_WHERE = "jdbc.queries.select.two.where";
    public static final String QUERY_SELECT_WHERE_NOTDELETED = "jdbc.queries.select.where.notdeleted";
    public static final String QUERY_CREATION_WIKITTY_ADMIN_TEST = "jdbc.queries.creation.wikitty.admin.test";
    public static final String QUERY_CREATION_WIKITTY_ADMIN = "jdbc.queries.creation.wikitty.admin";
    public static final String QUERY_CREATION_WIKITTY_DATA_TEST_BINARY = "jdbc.queries.creation.wikitty.data.test.binary";
    public static final String QUERY_CREATION_WIKITTY_DATA_ALTER_BINARY = "jdbc.queries.creation.wikitty.data.alter.binary";
    public static final String QUERY_CREATION_WIKITTY_DATA_TEST = "jdbc.queries.creation.wikitty.data.test";
    public static final String QUERY_CREATION_WIKITTY_DATA = "jdbc.queries.creation.wikitty.data";
    public static final String QUERY_INSERT_WIKITTY_ADMIN = "jdbc.queries.insert.wikitty.admin";
    public static final String QUERY_UPDATE_WIKITTY_ADMIN = "jdbc.queries.update.wikitty.admin";
    public static final String QUERY_INSERT_WIKITTY_DATA = "jdbc.queries.insert.wikitty.data";
    public static final String QUERY_DELETE_WIKITTY_ADMIN = "jdbc.queries.delete.wikitty.admin";
    public static final String QUERY_DELETE_WIKITTY_DATA = "jdbc.queries.delete.wikitty.data";
    public static final String QUERY_CLEAR_EXTENSION = "jdbc.queries.clear.extension";
    public static final String QUERY_CLEAR_WIKITTY = "jdbc.queries.clear.wikitty";
    public static final String QUERY_DELETE_EXTENSION_ADMIN = "jdbc.queries.delete.extension.admin";
    public static final String QUERY_DELETE_EXTENSION_DATA = "jdbc.queries.delete.extension.data";
    public static final String QUERY_CREATION_EXTENSION_ADMIN_TEST = "jdbc.queries.creation.extension.admin.test";
    public static final String QUERY_CREATION_EXTENSION_ADMIN = "jdbc.queries.creation.extension.admin";
    public static final String QUERY_CREATION_EXTENSION_DATA_TEST = "jdbc.queries.creation.extension.data.test";
    public static final String QUERY_CREATION_EXTENSION_DATA = "jdbc.queries.creation.extension.data";
    public static final String QUERY_INSERT_EXTENSION_ADMIN = "jdbc.queries.insert.extension.admin";
    public static final String QUERY_INSERT_EXTENSION_DATA = "jdbc.queries.insert.extension.data";
    protected static String TABLE_WIKITTY_ADMIN = "wikitty_admin";
    protected static String TABLE_WIKITTY_DATA = "wikitty_data";
    protected static String TABLE_EXTENSION_ADMIN = "extension_admin";
    protected static String TABLE_EXTENSION_DATA = "extension_data";
    private static Map<String, BasicManagedDataSource> dataSources = new HashMap<String, BasicManagedDataSource>();

    public static synchronized Properties loadQuery(ApplicationConfig config) {
        Properties result = null;
        List wikittyQueryFiles = config.getOptionAsList(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_QUERY_FILE.getKey()).getOption();
        for (String file : wikittyQueryFiles) {
            result = new Properties(result);
            InputStream streamQuery = null;
            try {
                URL url = ClassLoader.getSystemResource(file);
                if (url == null) {
                    ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                    url = contextClassLoader.getResource(file);
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Reading resource from: " + url));
                }
                streamQuery = url.openStream();
                result.load(streamQuery);
            }
            catch (IOException eee) {
                try {
                    throw new WikittyException(String.format("Unable to load property file '%s'", file), (Throwable)eee);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(streamQuery);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)streamQuery);
        }
        return result;
    }

    public static synchronized Connection getConnection(ApplicationConfig conf) {
        String driver = conf.getOption(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_DRIVER.getKey());
        String host = conf.getOption(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_URL.getKey());
        String username = conf.getOption(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_LOGIN.getKey());
        String password = conf.getOption(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_PASSWORD.getKey());
        String xaDataSourceClassName = conf.getOption(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_XADATASOURCE.getKey());
        try {
            BasicManagedDataSource dataSource;
            TransactionManager transactionManager = com.arjuna.ats.jta.TransactionManager.transactionManager();
            String jdbcUrl = String.format("%s:%s@%s", username, password, host);
            if (!dataSources.containsKey(jdbcUrl)) {
                log.info((Object)("Creating BasicManagedDataSource for: " + jdbcUrl));
                dataSource = new BasicManagedDataSource();
                if (xaDataSourceClassName != null) {
                    XADataSource xaDataSource = (XADataSource)Class.forName(xaDataSourceClassName).newInstance();
                    BeanMap beanMap = new BeanMap((Object)xaDataSource);
                    Set fields = beanMap.keySet();
                    for (Map.Entry<Object, Object> properties : conf.getFlatOptions().entrySet()) {
                        String propertyName = (String)properties.getKey();
                        if (!propertyName.startsWith(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_XADATASOURCE.getKey() + "." + xaDataSourceClassName + ".")) continue;
                        if (fields.contains(propertyName = propertyName.replaceFirst(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_XADATASOURCE.getKey() + "." + xaDataSourceClassName + ".", ""))) {
                            String propertyValue = (String)properties.getValue();
                            BeanUtils.setProperty((Object)xaDataSource, (String)propertyName, (Object)propertyValue);
                            continue;
                        }
                        log.warn((Object)("Invalid property " + propertyName + " for XADatasource " + Arrays.toString(fields.toArray())));
                    }
                    dataSource.setXaDataSourceInstance(xaDataSource);
                } else {
                    log.warn((Object)"No xadatasource is used, data integrity is not guarantee");
                }
                dataSource.setDriverClassName(driver);
                dataSource.setUrl(host);
                dataSource.setUsername(username);
                dataSource.setPassword(password);
                dataSource.setTransactionManager(transactionManager);
                dataSources.put(jdbcUrl, dataSource);
            }
            dataSource = dataSources.get(jdbcUrl);
            Connection connection = dataSource.getConnection();
            return connection;
        }
        catch (Exception eee) {
            String msg = String.format("Can't connect to database %s %s with login %s", driver, host, username);
            log.error((Object)msg, (Throwable)eee);
            throw new WikittyException(msg, (Throwable)eee);
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            log.error((Object)"SQLException while closing connection", (Throwable)e);
        }
    }

    public static synchronized Connection getJDBCConnection(ApplicationConfig config) {
        try {
            Connection connection = WikittyJDBCUtil.getConnection(config);
            connection.setAutoCommit(false);
            return connection;
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't set connection auto commit to false", (Throwable)eee);
        }
    }

    public static void commitJDBCConnection(Connection connection) {
        try {
            connection.commit();
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't commit transaction", (Throwable)eee);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException eee) {
                throw new WikittyException("Can't close connection", (Throwable)eee);
            }
        }
    }

    public static void rollbackJDBCConnection(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException eee) {
            throw new WikittyException("Can't rollback transaction", (Throwable)eee);
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException eee) {
                throw new WikittyException("Can't close connection", (Throwable)eee);
            }
        }
    }

    public static void doQuery(Connection connection, String query, Object ... args) throws SQLException {
        PreparedStatement sta = connection.prepareStatement(query);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Date) {
                sta.setObject(i + 1, args[i], 93);
                continue;
            }
            sta.setObject(i + 1, args[i]);
        }
        sta.execute();
    }
}

