/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelBuilder;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugene.models.object.ObjectModelTransformer;
import org.nuiton.eugene.models.object.ObjectModelType;
import org.nuiton.wikitty.generator.WikittyTagValue;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyPurifierTransformer
extends ObjectModelTransformer<ObjectModel>
implements WikittyTagValue {
    private static final Log log = LogFactory.getLog(WikittyPurifierTransformer.class);
    protected Map<ObjectModelClass, List<String>> namesUsedByClass = new HashMap<ObjectModelClass, List<String>>();
    protected List<ObjectModelClass> processedClasses = new ArrayList<ObjectModelClass>();
    protected ObjectModelBuilder builder;

    protected void processClass(ObjectModel model, ObjectModelClass clazz) {
        if (this.isVerbose()) {
            log.info((Object)("will purify " + clazz.getQualifiedName()));
        }
        ArrayList<String> attributeNames = new ArrayList<String>();
        List<ObjectModelClass> allClasses = WikittyTransformerUtil.getAllSuperClasses(model, clazz);
        allClasses.add(clazz);
        for (ObjectModelClass superClass : allClasses) {
            superClass = model.getClass(superClass.getQualifiedName());
            for (ObjectModelAttribute attribute : superClass.getAttributes()) {
                String attributeName = attribute.hasTagValue("alternativeName") ? attribute.getTagValue("alternativeName") : attribute.getName();
                if (attributeNames.contains(attributeName)) {
                    attributeName = attributeName + "From" + superClass.getName();
                    this.builder.addTagValue((ObjectModelElement)clazz, "alternativeName." + superClass.getName() + "." + attribute.getName(), attributeName);
                }
                attributeNames.add(attributeName);
            }
        }
    }

    public void transformFromModel(ObjectModel model) {
        for (ObjectModelClass clazz : model.getClasses()) {
            ObjectModelClass clone;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will clone " + clazz.getQualifiedName()));
            }
            if (!WikittyTransformerUtil.isBusinessEntity(clone = this.cloneClass(clazz, true))) continue;
            this.processClass(model, clone);
        }
    }

    protected Template<ObjectModel> initOutputTemplate() {
        return new ObjectModelGenerator();
    }

    protected void debugOutputModel() {
    }

    protected ObjectModel initOutputModel() {
        this.builder = new ObjectModelBuilder(((ObjectModel)this.getModel()).getName());
        ObjectModel model = this.builder.getModel();
        return model;
    }

    @Deprecated
    public ObjectModelClass cloneClass(ObjectModelClass source, boolean cloneDocumentation) {
        ObjectModelClass outputClass = this.builder.createClass(source.getName(), source.getPackageName(), new ObjectModelModifier[0]);
        this.cloneClassifier((ObjectModelClassifier)source, (ObjectModelClassifier)outputClass, cloneDocumentation);
        for (ObjectModelClass superClass : source.getSuperclasses()) {
            this.builder.addSuperclass(outputClass, superClass.getQualifiedName());
        }
        if (!CollectionUtils.isEmpty((Collection)source.getInnerClassifiers())) {
            for (ObjectModelClassifier classifier : source.getInnerClassifiers()) {
                ObjectModelClassifier innerClassifierClone = this.cloneClassifier(classifier, cloneDocumentation);
                this.builder.addInnerClassifier(outputClass, ObjectModelType.OBJECT_MODEL_CLASSIFIER, innerClassifierClone.getName(), new ObjectModelModifier[0]);
            }
        }
        return outputClass;
    }

    @Deprecated
    public ObjectModelClassifier cloneClassifier(ObjectModelClassifier source, boolean cloneDocumentation) {
        ObjectModelInterface clone = null;
        if (source.isInterface()) {
            clone = this.cloneInterface((ObjectModelInterface)source, cloneDocumentation);
        } else if (source.isClass()) {
            clone = this.cloneClass((ObjectModelClass)source, cloneDocumentation);
        } else if (source.isEnum()) {
            clone = this.cloneEnumeration((ObjectModelEnumeration)source, cloneDocumentation);
        } else {
            log.error((Object)("strange classifier " + source));
        }
        return clone;
    }

    @Deprecated
    public ObjectModelInterface cloneInterface(ObjectModelInterface source, boolean cloneDocumentation) {
        ObjectModelInterface outputInterface = this.builder.createInterface(source.getName(), source.getPackageName());
        this.cloneClassifier((ObjectModelClassifier)source, (ObjectModelClassifier)outputInterface, cloneDocumentation);
        return outputInterface;
    }

    @Deprecated
    public ObjectModelEnumeration cloneEnumeration(ObjectModelEnumeration source, boolean cloneDocumentation) {
        ObjectModelEnumeration outputEnumeration = this.builder.createEnumeration(source.getName(), source.getPackageName());
        this.cloneClassifier((ObjectModelClassifier)source, (ObjectModelClassifier)outputEnumeration, cloneDocumentation);
        for (String literal : source.getLiterals()) {
            this.builder.addLiteral(outputEnumeration, literal);
        }
        return outputEnumeration;
    }

    @Deprecated
    protected void cloneClassifier(ObjectModelClassifier source, ObjectModelClassifier destination, boolean copyDocumentation) {
        this.cloneTagValues((ObjectModelElement)source, (ObjectModelElement)destination);
        this.cloneStereotypes(source, destination);
        for (ObjectModelAttribute attribute : source.getAttributes()) {
            this.cloneAttribute(attribute, destination, copyDocumentation, new ObjectModelModifier[0]);
        }
        for (ObjectModelInterface interfacez : source.getInterfaces()) {
            this.builder.addInterface(destination, interfacez.getQualifiedName());
        }
        for (ObjectModelOperation operation : source.getOperations()) {
            this.cloneOperation(operation, destination, copyDocumentation, new ObjectModelModifier[0]);
        }
    }

    @Deprecated
    public ObjectModelOperation cloneOperation(ObjectModelOperation source, ObjectModelClassifier destination, boolean cloneDocumentation, ObjectModelModifier ... modifiers) {
        ObjectModelOperation outputOperation = this.cloneOperationSignature(source, destination, cloneDocumentation, modifiers);
        boolean opAbstract = false;
        for (ObjectModelModifier modifier : modifiers) {
            if (modifier != ObjectModelModifier.ABSTRACT) continue;
            opAbstract = true;
            break;
        }
        if (!opAbstract) {
            this.builder.setOperationBody(outputOperation, source.getBodyCode());
        }
        return outputOperation;
    }

    @Deprecated
    protected void cloneTagValues(ObjectModelElement source, ObjectModelElement destination) {
        Map tags = source.getTagValues();
        for (Map.Entry entry : tags.entrySet()) {
            this.builder.addTagValue(destination, (String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Deprecated
    protected void cloneStereotypes(ObjectModelClassifier source, ObjectModelClassifier destination) {
        Collection stereotypes = source.getStereotypes();
        for (String stereotype : stereotypes) {
            this.builder.addStereotype((ObjectModelElement)destination, stereotype);
        }
    }

    @Deprecated
    public ObjectModelOperation cloneOperationSignature(ObjectModelOperation source, ObjectModelClassifier destination, boolean cloneDocumentation, ObjectModelModifier ... modifiers) {
        ObjectModelOperation outputOperation = this.builder.addOperation(destination, source.getName(), source.getReturnType(), modifiers);
        if (cloneDocumentation && GeneratorUtil.hasDocumentation((ObjectModelElement)source)) {
            this.builder.setDocumentation((ObjectModelElement)outputOperation, source.getDocumentation());
        }
        for (ObjectModelParameter parameter : source.getParameters()) {
            ObjectModelParameter outputParam = this.builder.addParameter(outputOperation, parameter.getType(), parameter.getName());
            if (!cloneDocumentation || !GeneratorUtil.hasDocumentation((ObjectModelElement)parameter)) continue;
            this.builder.setDocumentation((ObjectModelElement)outputParam, parameter.getDocumentation());
        }
        for (String exception : source.getExceptions()) {
            this.builder.addException(outputOperation, exception);
        }
        this.cloneTagValues((ObjectModelElement)source, (ObjectModelElement)outputOperation);
        return outputOperation;
    }

    @Deprecated
    protected ObjectModelAttribute cloneAttribute(ObjectModelAttribute source, ObjectModelClassifier destination, boolean cloneDocumentation, ObjectModelModifier ... modifiers) {
        ObjectModelAttribute outputAttribute = this.builder.addAttribute(destination, source.getName(), source.getType(), source.getDefaultValue(), modifiers);
        this.cloneTagValues((ObjectModelElement)source, (ObjectModelElement)outputAttribute);
        if (cloneDocumentation) {
            this.builder.setDocumentation((ObjectModelElement)outputAttribute, source.getDocumentation());
        }
        for (String comment : source.getComments()) {
            this.builder.addComment((ObjectModelElement)outputAttribute, comment);
        }
        this.builder.setMinMultiplicity(outputAttribute, source.getMinMultiplicity());
        this.builder.setMaxMultiplicity(outputAttribute, source.getMaxMultiplicity());
        this.builder.setNavigable(outputAttribute, source.isNavigable());
        return outputAttribute;
    }
}

