/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyDTOGenerator
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(WikittyDTOGenerator.class);
    protected Map<ObjectModelClass, ObjectModelClass> processedClasses = new HashMap<ObjectModelClass, ObjectModelClass>();
    protected Pattern toStringTagValuePattern = Pattern.compile("\\{(([^|}])*)(?:\\|([^}]*))?\\}");
    protected Map<String, String> attributeToGetterName = new HashMap<String, String>();
    protected List<ObjectModelClass> entitiesWithInheritedOperations = new ArrayList<ObjectModelClass>();

    public void transformFromModel(ObjectModel model) {
        ArrayList<ObjectModelClass> modelBoth = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz) && !WikittyTransformerUtil.isMetaExtension(clazz)) continue;
            log.info((Object)("will treate class " + clazz.getQualifiedName()));
            modelBoth.add(clazz);
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClass = this.createClass(this.businessEntityToDTOName(clazz), clazz.getPackageName());
            this.processedClasses.put(clazz, abstractClass);
            this.addInterface((ObjectModelClassifier)abstractClass, clazz.getQualifiedName());
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (WikittyTransformerUtil.isMetaExtension(clazz)) {
                this.addMetaExtensionOperations(clazz, this.processedClasses.get(clazz));
                continue;
            }
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addInheritedOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClassForThisEntity = this.processedClasses.get(clazz);
            this.addConstructors(abstractClassForThisEntity);
            this.addToString(clazz, abstractClassForThisEntity);
            this.addBusinessEntityMethods(clazz, abstractClassForThisEntity);
            this.addModelOperations(clazz, abstractClassForThisEntity);
        }
        this.processedClasses.clear();
    }

    protected void addSerialVersionUID(ObjectModelClass clazz) {
        Random random = new Random();
        Long serialVersionUIDs = random.nextLong();
        this.addConstant((ObjectModelClassifier)clazz, "serialVersionUID", "long", serialVersionUIDs.toString() + "L", ObjectModelModifier.PRIVATE);
    }

    protected void addConstructors(ObjectModelClass clazz) {
        ObjectModelOperation constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n");
        constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "String", "wikittyId");
        this.setOperationBody(constructor, "\n        this.wikittyId=wikittyId;\n");
    }

    protected void addOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            String getterName;
            if (!attribute.isNavigable()) continue;
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            this.addImport((ObjectModelClassifier)abstractClass, attribute.getType());
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeInSet = WikittyTransformerUtil.generateResultType(attribute, true);
                String attributeTypeInSetImpl = null;
                String collectionType = WikittyTransformerUtil.getCollectionTypeName(attribute);
                if (Set.class.getSimpleName().equals(collectionType)) {
                    this.addImport((ObjectModelClassifier)abstractClass, Set.class);
                    this.addImport((ObjectModelClassifier)abstractClass, LinkedHashSet.class);
                    attributeTypeInSetImpl = "LinkedHashSet<String>";
                }
                if (List.class.getSimpleName().equals(collectionType)) {
                    this.addImport((ObjectModelClassifier)abstractClass, List.class);
                    this.addImport((ObjectModelClassifier)abstractClass, ArrayList.class);
                    attributeTypeInSetImpl = "ArrayList<String>";
                }
                ObjectModelAttribute modelAttribute = this.addAttribute((ObjectModelClassifier)abstractClass, attributeName + " = new " + attributeTypeInSetImpl + "()", attributeTypeInSet);
                String annotation = "WikittyField(fqn=\"" + businessEntity.getName() + "." + attributeName + "\")";
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)modelAttribute, annotation);
                this.addImport((ObjectModelClassifier)abstractClass, "org.nuiton.wikitty.entities.WikittyField");
                getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeTypeInSet, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
                String getterBody = "\n        return " + attributeName + ";\n" + "";
                this.setOperationBody(getter, getterBody);
                getterName = "set" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeTypeInSet, attributeName);
                String setterBody = "\n        if (" + attributeName + " == null){\n" + "            this." + attributeName + " = new " + attributeTypeInSetImpl + "();\n" + "        } else {\n" + "            // make copy to prevent modification of source collection\n" + "            this." + attributeName + "=new " + attributeTypeInSetImpl + "(" + attributeName + ");\n" + "        }\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(setter, setterBody);
                String addAllName = "addAll" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)abstractClass, addAllName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)addAll, "Override");
                this.addParameter(addAll, attributeTypeInSet, attributeName);
                String addAllBody = "\n        if (this." + attributeName + " == null){\n" + "            this." + attributeName + " = new " + attributeTypeInSetImpl + "();\n" + "        }\n" + "        this." + attributeName + ".addAll(" + attributeName + ");\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(addAll, addAllBody);
                String addName = "add" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)abstractClass, addName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)adder, "Override");
                this.addParameter(adder, attributeType, "element");
                String adderBody = "\n        if (this." + attributeName + " == null){\n" + "            this." + attributeName + " = new " + attributeTypeInSetImpl + "();\n" + "        }\n" + "        this." + attributeName + ".add(element);\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)abstractClass, removeName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)remover, "Override");
                this.addParameter(remover, attributeType, "element");
                String removerBody = "\n        " + attributeName + ".remove(element);\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)abstractClass, clearName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)clear, "Override");
                String clearBody = "\n        " + attributeName + ".clear();\n" + "        modificationCount++;\n" + "";
                this.setOperationBody(clear, clearBody);
            } else {
                this.addImport((ObjectModelClassifier)abstractClass, attribute.getType());
                ObjectModelAttribute modelAttribute = this.addAttribute((ObjectModelClassifier)abstractClass, attributeName, attributeType);
                String annotation = "WikittyField(fqn=\"" + businessEntity.getName() + "." + attributeName + "\")";
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)modelAttribute, annotation);
                this.addImport((ObjectModelClassifier)abstractClass, "org.nuiton.wikitty.entities.WikittyField");
                getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeType, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
                this.setOperationBody(getter, "\n        return " + attributeName + ";\n" + "");
                String setterName = "set" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, setterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeType, attributeName);
                this.setOperationBody(setter, "\n        this." + attributeName + "=" + attributeName + ";\n" + "        modificationCount++;\n" + "");
            }
            this.attributeToGetterName.put(businessEntity.getName() + "." + attributeName, getterName);
        }
    }

    protected void addInheritedOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            this.addInheritedOperations(superClass, abstractClass);
            if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
            this.addOperations(superClass, abstractClass);
        }
        this.entitiesWithInheritedOperations.add(businessEntity);
    }

    protected void addToString(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        String toStringOperationBody;
        if (businessEntity.hasTagValue("toString")) {
            String toStringPattern = businessEntity.getTagValue("toString");
            Matcher matcher = this.toStringTagValuePattern.matcher(toStringPattern);
            while (matcher.find()) {
                String wholeMatch = matcher.group(0);
                String variableName = matcher.group(1);
                String defaultValue = matcher.group(3);
                if (defaultValue == null) {
                    defaultValue = "";
                }
                if (this.attributeToGetterName.containsKey(variableName)) {
                    String getterName = this.attributeToGetterName.get(variableName);
                    toStringPattern = toStringPattern.replace(wholeMatch, "\"\n             + " + getterName + "().toString() +\n" + "             \"");
                    continue;
                }
                log.warn((Object)("no field " + variableName + " in " + businessEntity.getQualifiedName()));
                toStringPattern = toStringPattern.replace(wholeMatch, defaultValue);
            }
            toStringOperationBody = "\n        return \"" + toStringPattern + "\";\n" + "";
        } else {
            toStringOperationBody = "\n        return \"dto:\"+getWikittyId()+\":\"+getWikittyVersion();\n";
        }
        ObjectModelOperation toString = this.addOperation((ObjectModelClassifier)abstractClass, "toString", "String", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)toString, "Override");
        this.setOperationBody(toString, toStringOperationBody);
    }

    protected void addMetaExtensionOperations(ObjectModelClass metaExtension, ObjectModelClass abstractClassForThisMetaExtension) {
        this.addOperations(metaExtension, abstractClassForThisMetaExtension);
    }

    protected String businessEntityToDTOName(ObjectModelClass clazz) {
        return clazz.getName() + "DTO";
    }

    protected void addBusinessEntityMethods(ObjectModelClass entity, ObjectModelClass dtoClass) {
        String entityName = entity.getName();
        String dtoClassName = this.businessEntityToDTOName(entity);
        this.addAttribute((ObjectModelClassifier)dtoClass, "wikittyId", "String");
        this.addAttribute((ObjectModelClassifier)dtoClass, "modificationCount = 0", "int");
        ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)dtoClass, "getWikittyId", "String", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getter, "Override");
        this.setOperationBody(getter, "\n        return wikittyId;\n");
        ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)dtoClass, "setWikittyId", "void", new ObjectModelModifier[0]);
        this.addParameter(setter, "String", "wikittyId");
        this.setOperationBody(setter, "\n        this.wikittyId=wikittyId;\n");
        this.addAttribute((ObjectModelClassifier)dtoClass, "wikittyVersion", "String");
        ObjectModelOperation getWikittyVersion = this.addOperation((ObjectModelClassifier)dtoClass, "getWikittyVersion", "String", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getWikittyVersion, "Override");
        this.setOperationBody(getWikittyVersion, "\n        String result = wikittyVersion;\n        if (modificationCount > 0) {\n            result += \".\" + modificationCount;\n        }\n        return result;\n");
        ObjectModelOperation setWikittyVersion = this.addOperation((ObjectModelClassifier)dtoClass, "setWikittyVersion", "void", new ObjectModelModifier[0]);
        this.addParameter(setWikittyVersion, "String", "wikittyVersion");
        this.setOperationBody(setWikittyVersion, "\n        this.wikittyVersion=wikittyVersion;\n        modificationCount=0;\n");
        this.addImport((ObjectModelClassifier)dtoClass, PropertyChangeListener.class);
        this.addImport((ObjectModelClassifier)dtoClass, Collection.class);
        ObjectModelOperation addPropertyChangeListener = this.addOperation((ObjectModelClassifier)dtoClass, "addPropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)addPropertyChangeListener, "Override");
        this.addParameter(addPropertyChangeListener, "PropertyChangeListener", "listener");
        this.setOperationBody(addPropertyChangeListener, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation removePropertyChangeListener = this.addOperation((ObjectModelClassifier)dtoClass, "removePropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)removePropertyChangeListener, "Override");
        this.addParameter(removePropertyChangeListener, "PropertyChangeListener", "listener");
        this.setOperationBody(removePropertyChangeListener, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation addPropertyChangeListener2 = this.addOperation((ObjectModelClassifier)dtoClass, "addPropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)addPropertyChangeListener2, "Override");
        this.addParameter(addPropertyChangeListener2, "String", "property");
        this.addParameter(addPropertyChangeListener2, "PropertyChangeListener", "listener");
        this.setOperationBody(addPropertyChangeListener2, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation removePropertyChangeListener2 = this.addOperation((ObjectModelClassifier)dtoClass, "removePropertyChangeListener", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)removePropertyChangeListener2, "Override");
        this.addParameter(removePropertyChangeListener2, "String", "property");
        this.addParameter(removePropertyChangeListener2, "PropertyChangeListener", "listener");
        this.setOperationBody(removePropertyChangeListener2, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getExtensionFields = this.addOperation((ObjectModelClassifier)dtoClass, "getExtensionFields", "Collection<String>", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getExtensionFields, "Override");
        this.addParameter(getExtensionFields, "String", "ext");
        this.setOperationBody(getExtensionFields, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getExtensionNames = this.addOperation((ObjectModelClassifier)dtoClass, "getExtensionNames", "Collection<String>", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getExtensionNames, "Override");
        this.setOperationBody(getExtensionNames, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation getField = this.addOperation((ObjectModelClassifier)dtoClass, "getField", "Object", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)getField, "Override");
        this.addParameter(getField, "String", "ext");
        this.addParameter(getField, "String", "fieldName");
        this.setOperationBody(getField, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation setField = this.addOperation((ObjectModelClassifier)dtoClass, "setField", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)setField, "Override");
        this.addParameter(setField, "String", "ext");
        this.addParameter(setField, "String", "fieldName");
        this.addParameter(setField, "Object", "value");
        this.setOperationBody(setField, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        ObjectModelOperation copyFrom = this.addOperation((ObjectModelClassifier)dtoClass, "copyFrom", "void", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)copyFrom, "Override");
        this.addParameter(copyFrom, "BusinessEntity", "source");
        String copyFromBody = "\n        if (!(source instanceof " + entityName + ")){\n" + "            throw new WikittyException(\"Can't copy source object \" + source +\n" + "                    \". They are not of the same type\");\n" + "        }\n" + "\n" + "        " + entityName + " sourceCopy = (" + entityName + ")source;\n" + "";
        copyFromBody = this.addCopyFromAttributes(entity, copyFromBody);
        copyFromBody = copyFromBody + "\n        setWikittyVersion(sourceCopy.getWikittyVersion());\n";
        this.addImport((ObjectModelClassifier)dtoClass, "org.nuiton.wikitty.WikittyException");
        this.addImport((ObjectModelClassifier)dtoClass, "org.nuiton.wikitty.entities.BusinessEntity");
        this.setOperationBody(copyFrom, copyFromBody);
    }

    protected String addCopyFromAttributes(ObjectModelClass businessEntity, String methodBody) {
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
            methodBody = this.addCopyFromAttributes(superClass, methodBody);
        }
        methodBody = this.copyFromAttributesOfClass(businessEntity, methodBody);
        return methodBody;
    }

    protected String copyFromAttributesOfClass(ObjectModelClass businessEntity, String methodBody) {
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            String attributeTypeInSetImpl = null;
            String attributeTypeInSet = null;
            String collectionType = WikittyTransformerUtil.getCollectionTypeName(attribute);
            if (Set.class.getSimpleName().equals(collectionType)) {
                attributeTypeInSet = "Set<String>";
                attributeTypeInSetImpl = "LinkedHashSet<String>";
            }
            if (List.class.getSimpleName().equals(collectionType)) {
                attributeTypeInSet = "List<String>";
                attributeTypeInSetImpl = "ArrayList<String>";
            }
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            String capitalizedAttributeName = StringUtils.capitalize((String)attributeName);
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                methodBody = methodBody + "\n        " + attributeTypeInSet + " " + attributeName + " = sourceCopy.get" + capitalizedAttributeName + "();\n" + "        if (" + attributeName + " != null){\n" + "            set" + capitalizedAttributeName + "(new " + attributeTypeInSetImpl + "(" + attributeName + "));\n" + "        }\n" + "";
                continue;
            }
            methodBody = methodBody + "\n        set" + capitalizedAttributeName + "(sourceCopy.get" + capitalizedAttributeName + "());\n" + "";
        }
        return methodBody;
    }

    protected void addModelOperations(ObjectModelClass businessEntity, ObjectModelClass dtoClass) {
        Collection operations = businessEntity.getOperations();
        for (ObjectModelOperation operation : operations) {
            ObjectModelOperation dtoOperation = this.addOperation((ObjectModelClassifier)dtoClass, operation.getName(), operation.getReturnType(), new ObjectModelModifier[0]);
            Collection parameters = operation.getParameters();
            for (ObjectModelParameter parameter : parameters) {
                this.addParameter(dtoOperation, parameter.getType(), parameter.getName());
            }
            this.addAnnotation((ObjectModelClassifier)dtoClass, (ObjectModelElement)dtoOperation, "Override");
            this.setOperationBody(dtoOperation, "\n        throw new UnsupportedOperationException(\"Not supported yet.\");\n");
        }
    }
}

