/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyAbstractGenerator
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(WikittyAbstractGenerator.class);
    protected Map<ObjectModelClass, ObjectModelClass> processedClasses = new HashMap<ObjectModelClass, ObjectModelClass>();
    protected Pattern toStringTagValuePattern = Pattern.compile("\\{(([^|}])*)(?:\\|([^}]*))?\\}");
    protected Map<String, String> attributeToGetterName = new HashMap<String, String>();
    protected List<ObjectModelClass> entitiesWithInheritedOperations = new ArrayList<ObjectModelClass>();
    protected Map<ObjectModelClass, List<String>> requiredDependencyImports = new HashMap<ObjectModelClass, List<String>>();

    public void transformFromModel(ObjectModel model) {
        ArrayList<ObjectModelClass> modelBoth = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz) && !WikittyTransformerUtil.isMetaExtension(clazz)) continue;
            modelBoth.add(clazz);
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClass = this.createAbstractClass(WikittyTransformerUtil.businessEntityToAbstractName(clazz), clazz.getPackageName());
            this.processedClasses.put(clazz, abstractClass);
            this.setSuperClass(abstractClass, "BusinessEntityImpl");
            this.addInterface((ObjectModelClassifier)abstractClass, clazz.getQualifiedName());
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (WikittyTransformerUtil.isMetaExtension(clazz)) {
                this.addMetaExtensionOperations(clazz, this.processedClasses.get(clazz));
                continue;
            }
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.addInheritedOperations(clazz, this.processedClasses.get(clazz));
        }
        for (ObjectModelClass clazz : modelBoth) {
            ObjectModelClass abstractClassForThisEntity = this.processedClasses.get(clazz);
            this.addImports(abstractClassForThisEntity);
            this.addConstructors(abstractClassForThisEntity);
            this.addConstants(clazz, abstractClassForThisEntity);
            this.addToString(clazz, abstractClassForThisEntity);
        }
        this.processedClasses.clear();
    }

    protected void addImports(ObjectModelClass clazz) {
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.BusinessEntity");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.BusinessEntityImpl");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.Wikitty");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyExtension");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.WikittyUtil");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyUser");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyUserAbstract");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyUserImpl");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyTreeNode");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyTreeNodeAbstract");
        this.addImport((ObjectModelClassifier)clazz, "org.nuiton.wikitty.entities.WikittyTreeNodeImpl");
        this.addImport((ObjectModelClassifier)clazz, List.class);
        this.addImport((ObjectModelClassifier)clazz, ArrayList.class);
        this.addImport((ObjectModelClassifier)clazz, Collection.class);
        this.addImport((ObjectModelClassifier)clazz, Collections.class);
        this.addImport((ObjectModelClassifier)clazz, Set.class);
        this.addImport((ObjectModelClassifier)clazz, Date.class);
        this.addImport((ObjectModelClassifier)clazz, LinkedHashSet.class);
    }

    protected void addSerialVersionUID(ObjectModelClass clazz) {
        Random random = new Random();
        Long serialVersionUIDs = random.nextLong();
        this.addConstant((ObjectModelClassifier)clazz, "serialVersionUID", "long", serialVersionUIDs.toString() + "L", ObjectModelModifier.PRIVATE);
    }

    protected void addConstructors(ObjectModelClass clazz) {
        ObjectModelOperation constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.setOperationBody(constructor, "\n        super();\n");
        constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setOperationBody(constructor, "\n        super(wikitty);\n");
        constructor = this.addConstructor(clazz, ObjectModelModifier.PUBLIC);
        this.addParameter(constructor, "org.nuiton.wikitty.entities.BusinessEntityImpl", "businessEntityImpl");
        this.setOperationBody(constructor, "\n        super(businessEntityImpl.getWikitty());\n");
    }

    protected void addConstants(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        this.addConstant((ObjectModelClassifier)abstractClass, "extensions", "List<WikittyExtension>", null, ObjectModelModifier.PUBLIC);
        this.addConstant((ObjectModelClassifier)abstractClass, "extension" + businessEntity.getName(), "WikittyExtension", null, ObjectModelModifier.PUBLIC);
        ObjectModelOperation getStaticExtensions = this.addOperation((ObjectModelClassifier)abstractClass, "getStaticExtensions", "Collection<WikittyExtension>", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getStaticExtensions, "Override");
        this.setOperationBody(getStaticExtensions, "\n        return extensions;\n");
        ObjectModelOperation staticInitialization = this.addBlock((ObjectModelClassifier)abstractClass, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        ArrayList<String> buildFieldMapExtensionParameters = new ArrayList<String>();
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String wikittyType = WikittyTransformerUtil.typeToWikittyColumn(attribute.getType());
            String multiplicity = "";
            if (attribute.getMinMultiplicity() != 1 || attribute.getMaxMultiplicity() != 1) {
                multiplicity = "[" + attribute.getMinMultiplicity() + "-" + (attribute.getMaxMultiplicity() == -1 ? "*" : Integer.valueOf(attribute.getMaxMultiplicity())) + "]";
            }
            if (attribute.isUnique() && !attribute.getTagValues().containsKey("unique")) {
                attribute.getTagValues().put("unique", "true");
            }
            String tagvalue = "";
            for (Map.Entry tv : attribute.getTagValues().entrySet()) {
                tagvalue = tagvalue + " " + (String)tv.getKey() + "=\\\"" + StringEscapeUtils.escapeJava((String)((String)tv.getValue())) + "\\\"";
            }
            buildFieldMapExtensionParameters.add("                                             \"" + wikittyType + " " + attribute.getName() + "" + multiplicity + "" + tagvalue + "\"");
        }
        String extensionVersion = businessEntity.getTagValue("version");
        if (extensionVersion == null || "".equals(extensionVersion)) {
            extensionVersion = "1.0";
            log.warn((Object)("no version specified in model for " + businessEntity.getQualifiedName() + " using " + extensionVersion));
        }
        String requires = null;
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            this.addImport((ObjectModelClassifier)abstractClass, superClass);
            this.addImport((ObjectModelClassifier)abstractClass, superClass.getQualifiedName() + "Abstract");
            requires = WikittyTransformerUtil.classToExtensionVariableName(superClass, true);
        }
        String buildFieldMapExtensionParametersInLine = StringUtils.join(buildFieldMapExtensionParameters, (String)", \n");
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(businessEntity, false);
        String staticInitializationBody = "\n        extension" + businessEntity.getName() + " =\n" + "                new WikittyExtension(" + extensionVariableName + ",\n" + "                                     \"" + extensionVersion + "\", // version\n" + "                                     " + requires + ",\n" + "                                     WikittyUtil.buildFieldMapExtension( // building field map\n" + "" + buildFieldMapExtensionParametersInLine + "));\n" + "\n" + "        // init extensions\n" + "        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();\n" + "";
        for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
            staticInitializationBody = staticInitializationBody + "\n        exts.addAll(" + superClass.getName() + "Abstract.extensions); \n" + "        // current after requires ones\n" + "";
        }
        staticInitializationBody = staticInitializationBody + "\n        exts.add(extension" + businessEntity.getName() + ");\n" + "        extensions = Collections.unmodifiableList(exts);\n" + "";
        this.setOperationBody(staticInitialization, staticInitializationBody);
    }

    protected void addOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(businessEntity, true);
        String helperClassName = WikittyTransformerUtil.businessEntityToHelperName(businessEntity);
        for (ObjectModelAttribute attribute : businessEntity.getAttributes()) {
            String getterName;
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            String capitalizedAttributeName = StringUtils.capitalize((String)attributeName);
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeSimpleNameInSet = WikittyTransformerUtil.generateResultType(attribute, true);
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeTypeSimpleNameInSet, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
                String getterBody = "\n        " + attributeTypeSimpleNameInSet + " result = " + helperClassName + "." + getterName + "(getWikitty());\n" + "        return result;\n" + "";
                this.setOperationBody(getter, getterBody);
                String setterName = "set" + capitalizedAttributeName;
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, setterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeTypeSimpleNameInSet, attributeName);
                String setterBody = "\n        " + attributeTypeSimpleNameInSet + " oldValue = get" + capitalizedAttributeName + "();\n" + "        " + helperClassName + "." + setterName + "(getWikitty(), " + attributeName + ");\n" + "        getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(setter, setterBody);
                String addAllName = "addAll" + capitalizedAttributeName;
                ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)abstractClass, addAllName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)addAll, "Override");
                this.addParameter(addAll, attributeTypeSimpleNameInSet, attributeName);
                String addAllBody = "\n        " + attributeTypeSimpleNameInSet + " oldValue = get" + capitalizedAttributeName + "();\n" + "        " + helperClassName + "." + addAllName + "(getWikitty(), " + attributeName + ");\n" + "        getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "";
                this.setOperationBody(addAll, addAllBody);
                String addName = "add" + capitalizedAttributeName;
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)abstractClass, addName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)adder, "Override");
                this.addParameter(adder, "String", "element");
                String adderBody = "\n        " + helperClassName + "." + addName + "(getWikitty(), element);\n" + "        getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)abstractClass, removeName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)remover, "Override");
                this.addParameter(remover, "String", "element");
                String removerBody = "\n        " + helperClassName + "." + removeName + "(getWikitty(), element);\n" + "        getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)abstractClass, clearName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)clear, "Override");
                String clearBody = "\n        " + helperClassName + "." + clearName + "(getWikitty());\n" + "        getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "";
                this.setOperationBody(clear, clearBody);
            } else {
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                getterName = "get" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClass, getterName, attributeType, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)getter, "Override");
                this.setOperationBody(getter, "\n        " + attributeType + " value = " + helperClassName + "." + getterName + "(getWikitty());\n" + "        return value;\n" + "");
                String setterName = "set" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClass, setterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeType, attributeName);
                this.setOperationBody(setter, "\n        " + attributeType + " oldValue = " + getterName + "();\n" + "        " + helperClassName + "." + setterName + "(getWikitty(), " + attributeName + ");\n" + "        getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "");
            }
            this.attributeToGetterName.put(businessEntity.getName() + "." + attributeName, getterName);
        }
    }

    protected void addInheritedOperations(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        if (!this.entitiesWithInheritedOperations.contains(businessEntity)) {
            for (ObjectModelClass superClass : businessEntity.getSuperclasses()) {
                List<String> imports = this.requiredDependencyImports.get(businessEntity);
                if (imports == null) {
                    imports = new ArrayList<String>();
                    this.requiredDependencyImports.put(businessEntity, imports);
                }
                this.addInheritedOperations(superClass, this.processedClasses.get(superClass));
                if (!businessEntity.getPackageName().equals(superClass.getPackageName())) {
                    String parentToImport = superClass.getQualifiedName();
                    String helperToImport = superClass.getPackageName() + "." + WikittyTransformerUtil.businessEntityToHelperName(superClass);
                    this.addImport((ObjectModelClassifier)abstractClass, parentToImport);
                    this.addImport((ObjectModelClassifier)abstractClass, helperToImport);
                    imports.add(parentToImport);
                    imports.add(helperToImport);
                }
                List<String> importsNeeded = this.requiredDependencyImports.get(superClass);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(businessEntity + " needs imports " + importsNeeded));
                }
                if (importsNeeded != null) {
                    for (String importNeeded : importsNeeded) {
                        this.addImport((ObjectModelClassifier)abstractClass, importNeeded);
                        imports.add(importNeeded);
                    }
                }
                if (!WikittyTransformerUtil.isBusinessEntity(superClass)) continue;
                for (ObjectModelOperation operation : this.processedClasses.get(superClass).getOperations()) {
                    ObjectModelOperation operationClone = this.cloneOperationSignature(operation, (ObjectModelClassifier)abstractClass, true, new ObjectModelModifier[0]);
                    this.setOperationBody(operationClone, operation.getBodyCode());
                }
            }
            this.entitiesWithInheritedOperations.add(businessEntity);
        }
    }

    protected void addToString(ObjectModelClass businessEntity, ObjectModelClass abstractClass) {
        String toStringOperationBody = null;
        if (businessEntity.hasTagValue("toString")) {
            String toStringPattern = businessEntity.getTagValue("toString");
            Matcher matcher = this.toStringTagValuePattern.matcher(toStringPattern);
            while (matcher.find()) {
                String wholeMatch = matcher.group(0);
                String variableName = matcher.group(1);
                String defaultValue = matcher.group(3);
                if (defaultValue == null) {
                    defaultValue = "";
                }
                if (this.attributeToGetterName.containsKey(variableName)) {
                    String getterName = this.attributeToGetterName.get(variableName);
                    toStringPattern = toStringPattern.replace(wholeMatch, "\"\n             + " + getterName + "().toString() + \n" + "             \"");
                    continue;
                }
                log.warn((Object)("no field " + variableName + " in " + businessEntity.getQualifiedName()));
                toStringPattern = toStringPattern.replace(wholeMatch, defaultValue);
            }
            toStringOperationBody = "\n        return \"" + toStringPattern + "\";\n" + "";
        } else {
            toStringOperationBody = "\n        return getWikitty().toString();\n";
        }
        ObjectModelOperation toString = this.addOperation((ObjectModelClassifier)abstractClass, "toString", "String", new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)abstractClass, (ObjectModelElement)toString, "Override");
        this.setOperationBody(toString, toStringOperationBody);
    }

    protected void addMetaExtensionOperations(ObjectModelClass metaExtension, ObjectModelClass abstractClassForThisMetaExtension) {
        String helperClassName = WikittyTransformerUtil.businessEntityToHelperName(metaExtension);
        ObjectModelAttribute extension = this.addAttribute((ObjectModelClassifier)abstractClassForThisMetaExtension, "extensionForMetaExtension", "org.nuiton.wikitty.entities.WikittyExtension");
        this.setDocumentation((ObjectModelElement)extension, "the metaExtension operations target this extension, may be null");
        ObjectModelOperation setExtensionForMetaExtension = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, "setExtensionForMetaExtension", "void", new ObjectModelModifier[0]);
        this.addParameter(setExtensionForMetaExtension, "org.nuiton.wikitty.entities.WikittyExtension", "extension");
        this.setDocumentation((ObjectModelElement)setExtensionForMetaExtension, String.format("add %s meta-extension on given extension to this entity", metaExtension.getName()));
        this.setOperationBody(setExtensionForMetaExtension, "\n        extensionForMetaExtension = extension;\n        " + helperClassName + ".addMetaExtension(extension, getWikitty());\n" + "");
        for (ObjectModelAttribute attribute : metaExtension.getAttributes()) {
            String getterName;
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeSimpleNameInSet = WikittyTransformerUtil.generateResultType(attribute, true);
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                String attributeNameCapitalized = StringUtils.capitalize((String)attributeName);
                getterName = "get" + attributeNameCapitalized;
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, getterName, attributeTypeSimpleNameInSet, new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)getter, "Override");
                String getterBody = "\n        " + attributeTypeSimpleNameInSet + " result;\n" + "        if (extensionForMetaExtension == null) {\n" + "            result = " + helperClassName + "." + getterName + "(getWikitty());\n" + "        } else {\n" + "            result = " + helperClassName + "." + getterName + "(extensionForMetaExtension.getName(), getWikitty());\n" + "        }\n" + "        return result;\n" + "";
                this.setOperationBody(getter, getterBody);
                String setterName = "set" + attributeNameCapitalized;
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, setterName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)setter, "Override");
                this.addParameter(setter, attributeTypeSimpleNameInSet, "values");
                String setterBody = "\n        if (extensionForMetaExtension == null) {\n            " + helperClassName + "." + setterName + "(getWikitty(), values);\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "        } else {\n" + "            " + helperClassName + "." + setterName + "(extensionForMetaExtension.getName(), getWikitty(), values);\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, null, " + getter.getName() + "());\n" + "        }\n" + "";
                this.setOperationBody(setter, setterBody);
                String addAllName = "addAll" + attributeNameCapitalized;
                ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, addAllName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)addAll, "Override");
                this.addParameter(addAll, attributeTypeSimpleNameInSet, "values");
                String addAllBody = "\n        if (extensionForMetaExtension == null) {\n            " + helperClassName + "." + addAllName + "(getWikitty(), values);\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "        } else {\n" + "            " + helperClassName + "." + addAllName + "(extensionForMetaExtension.getName(), getWikitty(), values);\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, null, " + getter.getName() + "());\n" + "        }\n" + "";
                this.setOperationBody(addAll, addAllBody);
                String addName = "add" + attributeNameCapitalized;
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, addName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)adder, "Override");
                this.addParameter(adder, "String", "element");
                String adderBody = "\n        if (extensionForMetaExtension == null) {\n            " + helperClassName + "." + addName + "(getWikitty(), element);\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "        } else {\n" + "            " + helperClassName + "." + addName + "(extensionForMetaExtension.getName(), getWikitty(), element);\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, null, " + getter.getName() + "());\n" + "        }\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + attributeNameCapitalized;
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, removeName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)remover, "Override");
                this.addParameter(remover, "String", "element");
                String removerBody = "\n        if (extensionForMetaExtension == null) {\n            " + helperClassName + "." + removeName + "(getWikitty(), element);\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "        } else {\n" + "            " + helperClassName + "." + removeName + "(extensionForMetaExtension.getName(), getWikitty(), element);\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, null, " + getter.getName() + "());\n" + "        }\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + attributeNameCapitalized;
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, clearName, "void", new ObjectModelModifier[0]);
                this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)clear, "Override");
                String clearBody = "\n        if (extensionForMetaExtension == null) {\n            " + helperClassName + "." + clearName + "(getWikitty());\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", null, " + getter.getName() + "());\n" + "        } else {\n" + "            " + helperClassName + "." + clearName + "(extensionForMetaExtension.getName(), getWikitty());\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, null, " + getter.getName() + "());\n" + "        }\n" + "";
                this.setOperationBody(clear, clearBody);
                continue;
            }
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            getterName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, getterName, attributeType, new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)getter, "Override");
            this.setOperationBody(getter, "\n        " + attributeType + " value;\n" + "        if (extensionForMetaExtension == null) {\n" + "            value = " + helperClassName + "." + getterName + "(getWikitty());\n" + "        } else {\n" + "            value = " + helperClassName + "." + getterName + "(extensionForMetaExtension.getName(), getWikitty());\n" + "        }\n" + "        return value;\n" + "");
            String setterName = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)abstractClassForThisMetaExtension, setterName, "void", new ObjectModelModifier[0]);
            this.addAnnotation((ObjectModelClassifier)abstractClassForThisMetaExtension, (ObjectModelElement)setter, "Override");
            this.addParameter(setter, attributeType, attributeName);
            this.setOperationBody(setter, "\n        " + attributeType + " oldValue;\n" + "        if (extensionForMetaExtension == null) {\n" + "            oldValue = " + getterName + "();\n" + "            " + helperClassName + "." + setterName + "(getWikitty(), " + attributeName + ");\n" + "            getPropertyChangeSupport().firePropertyChange(" + fieldVariableName + ", oldValue, " + getter.getName() + "());\n" + "        } else {\n" + "            oldValue = " + getterName + "();\n" + "            " + helperClassName + "." + setterName + "(extensionForMetaExtension.getName(), getWikitty(), " + attributeName + ");\n" + "            String fieldName = " + helperClassName + ".getMetaFieldName(extensionForMetaExtension, \"" + attributeName + "\");\n" + "            getPropertyChangeSupport().firePropertyChange(fieldName, oldValue, " + getter.getName() + "());\n" + "        }\n" + "");
        }
    }
}

