/*
 * #%L
 * Wikitty :: generators
 * 
 * $Id: WikittyImplementationGenerator.java 650 2010-12-23 11:44:57Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.5/wikitty-generators/src/main/java/org/nuiton/wikitty/generator/WikittyImplementationGenerator.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;





/**
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.wikitty.generator.WikittyImplementationGenerator"
 */
public class WikittyImplementationGenerator extends ObjectModelTransformerToJava {

    protected Map<ObjectModelClass, ObjectModelClass> processedClasses =
                              new HashMap<ObjectModelClass, ObjectModelClass>();
    
    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (clazz.getOperations().isEmpty()) {

            if (WikittyTransformerUtil.isBusinessEntity(clazz)) {
                ObjectModelClass implementation = prepareImplementation(clazz);
                processBusinessEntity(clazz, implementation);
            }

            if (WikittyTransformerUtil.isMetaExtension(clazz)) {
                ObjectModelClass implementation = prepareImplementation(clazz);
                processMetaExtension(clazz, implementation);
            }
        }
    }

    protected ObjectModelClass prepareImplementation(ObjectModelClass clazz) {
        ObjectModelClass implementation = processedClasses.get(clazz);
        
        if (implementation == null) {

            implementation = createClass(
                    WikittyTransformerUtil.businessEntityToImplementationName(clazz),
                    clazz.getPackageName());

            // TODO 20100811 bleny remove unused imports
            addImport(implementation, WikittyTransformerUtil.BUSINESS_ENTITY_CLASS_FQN);
            addImport(implementation, WikittyTransformerUtil.BUSINESS_ENTITY_WIKITTY_CLASS_FQN);
            addImport(implementation, WikittyTransformerUtil.WIKITTY_CLASS_FQN);
            addImport(implementation, WikittyTransformerUtil.ENTITY_PACKAGE + ".WikittyExtension");
            addImport(implementation, "org.nuiton.wikitty.WikittyUtil");
            addImport(implementation, WikittyTransformerUtil.ENTITY_PACKAGE + ".WikittyUser");
            addImport(implementation, WikittyTransformerUtil.ENTITY_PACKAGE + ".WikittyUserAbstract");
            addImport(implementation, WikittyTransformerUtil.ENTITY_PACKAGE + ".WikittyUserImpl");
            addImport(implementation, WikittyTransformerUtil.ENTITY_PACKAGE + ".WikittyTreeNode");
            addImport(implementation, WikittyTransformerUtil.ENTITY_PACKAGE + ".WikittyTreeNodeAbstract");
            addImport(implementation, WikittyTransformerUtil.ENTITY_PACKAGE + ".WikittyTreeNodeImpl");
            addImport(implementation, List.class);
            addImport(implementation, ArrayList.class);
            addImport(implementation, Collection.class);
            addImport(implementation, Collections.class);
            addImport(implementation, Set.class);
            addImport(implementation, Date.class);
            addImport(implementation, LinkedHashSet.class);

            setSuperClass(implementation, WikittyTransformerUtil.businessEntityToAbstractName(clazz));

            // adding a generated serialVersionUID
            Random random = new Random();
            Long serialVersionUIDs = random.nextLong();
            addConstant(implementation,
            "serialVersionUID",
            "long",
            serialVersionUIDs.toString() + "L",
            ObjectModelModifier.PRIVATE);

            processedClasses.put(clazz, implementation);
        }
        
        return implementation;
    }
    
    protected void processBusinessEntity(ObjectModelClass clazz,
                                         ObjectModelClass implementation) {
        
        // adding constructor
        ObjectModelOperation constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        setOperationBody(constructor, ""
+"\n"
+"        super();\n"
+"");

        constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        addParameter(constructor, WikittyTransformerUtil.WIKITTY_CLASS_FQN, "wikitty");
        setOperationBody(constructor, ""
+"\n"
+"        super(wikitty);\n"
+"");

        constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        addParameter(constructor, WikittyTransformerUtil.BUSINESS_ENTITY_WIKITTY_CLASS_FQN, "businessEntityImpl");
        setOperationBody(constructor, ""
+"\n"
+"        super(businessEntityImpl.getWikitty());\n"
+"");

    }

    protected void processMetaExtension(ObjectModelClass metaExtension,
                                        ObjectModelClass implementation) {


        ObjectModelOperation constructor = addConstructor(implementation, ObjectModelModifier.PUBLIC);
        addParameter(constructor, WikittyTransformerUtil.WIKITTY_EXTENSION_CLASS_FQN, "extension");
        addParameter(constructor, WikittyTransformerUtil.WIKITTY_CLASS_FQN, "wikitty");
        String contractName = WikittyTransformerUtil.businessEntityToContractName(metaExtension);
        setOperationBody(constructor, ""
+"\n"
+"        this.wikitty = wikitty;\n"
+"        setExtensionForMetaExtension(extension);\n"
+"");
    }
}
