package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.models.object.ObjectModelEnumeration;

public class EnumGenerator extends WikengoCommonGenerator {

    @Override
    public String getFilenameForEnumeration(ObjectModelEnumeration enumeration) {
        String fqn = enumeration.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    @Override
    public void generateFromEnumeration(Writer output,
            ObjectModelEnumeration enumeration) throws IOException {

        generateCopyright(output);

        String packageName = enumeration.getPackageName();
        String enumName = enumeration.getName();

output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        generateDocumentation(output, enumeration, "");
output.write("public enum "+enumName+" {\n");
output.write("\n");
output.write("");

        boolean isFirst = true;
        for (String literal: enumeration.getLiterals()) {
            if (isFirst) {
output.write("    ");
            } else {
output.write(", ");
            }
            isFirst = false;
output.write(""+literal+"");            
        }

output.write("\n");
output.write("\n");
output.write("");

output.write("} //"+enumName+"\n");
output.write("");
    }

}
