package org.nuiton.wikitty.entities;

/*
 * #%L
 * Wikitty :: dto
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2010 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;

public class WikittyGroupDTO implements WikittyGroup {

@WikittyField(fqn="WikittyGroup.name")    protected String name;

@WikittyField(fqn="WikittyGroup.members")    protected Set<String> members = new LinkedHashSet<String>();

    protected String wikittyId;

    protected int modificationCount = 0;

    protected String wikittyVersion;

    @Override
    public String getName() {
        return name;
}

    @Override
    public void setName(String name) {
        this.name=name;
        modificationCount++;
}

    @Override
    public Set<String> getMembers() {
        return members;
}

    @Override
    public void setMembers(Set<String> members) {
        if (members == null){
            this.members = new LinkedHashSet<String>();
        } else {
            // make copy to prevent modification of source collection
            this.members=new LinkedHashSet<String>(members);
        }
        modificationCount++;
}

    @Override
    public void addAllMembers(Collection<String> members) {
        if (this.members == null){
            this.members = new LinkedHashSet<String>();
        }
        this.members.addAll(members);
        modificationCount++;
}

    @Override
    public void addMembers(String... element) {
        if (this.members == null){
            this.members = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.members.add(v);
        }
        modificationCount++;
}

    @Override
    public void removeMembers(String... element) {
        if (this.members != null) {
            for (String v : element) {
                members.remove(element);
            }
            modificationCount++;
        }
}

    @Override
    public void clearMembers() {
        if (this.members != null) {
            members.clear();
            modificationCount++;
        }
}

    @Override
    public Set<Wikitty> getMembers(boolean exceptionIfNotLoaded) {
        if (exceptionIfNotLoaded) {
            throw new WikittyException("Preload is not implemented in DTO");
        } else {
            return null;
        }
}

    @Override
    public void setMembersEntity(Collection<Wikitty> members) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : members) {
            tmp.add(e.getWikittyId());
        }
        setMembers(tmp);
}

    @Override
    public void addAllMembersEntity(Collection<Wikitty> members) {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>();
        for (Wikitty e : members) {
            tmp.add(e.getWikittyId());
        }
        addAllMembers(tmp);
}

    @Override
    public void addMembers(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        addMembers(tmp);
}

    @Override
    public void removeMembers(Wikitty... element) {
        String[] tmp = new String[element.length];
        for (int i=0; i<element.length; i++) {
            tmp[i] = element[i].getWikittyId();
        }
        removeMembers(tmp);
}

    public WikittyGroupDTO() {
}

    public WikittyGroupDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public Object getFieldAsObject(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyGroup)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        WikittyGroup sourceCopy = (WikittyGroup)source;

        setName(sourceCopy.getName());

        Set<String> members = sourceCopy.getMembers();
        if (members != null){
            setMembers(new LinkedHashSet<String>(members));
        }

        setWikittyVersion(sourceCopy.getWikittyVersion());
}

} //WikittyGroupDTO
