/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyLabel;

public class WikittyLabelDTO
implements WikittyLabel {
    @WikittyField(fqn="WikittyLabel.labels")
    protected Set<String> labels = new LinkedHashSet<String>();
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;

    public Set<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Set<String> labels) {
        this.labels = labels == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(labels);
        ++this.modificationCount;
    }

    public void addAllLabels(Collection<String> labels) {
        if (this.labels == null) {
            this.labels = new LinkedHashSet<String>();
        }
        this.labels.addAll(labels);
        ++this.modificationCount;
    }

    public void addLabels(String ... element) {
        if (this.labels == null) {
            this.labels = new LinkedHashSet<String>();
        }
        for (String v : element) {
            this.labels.add(v);
        }
        ++this.modificationCount;
    }

    public void removeLabels(String ... element) {
        if (this.labels != null) {
            for (String v : element) {
                this.labels.remove(element);
            }
            ++this.modificationCount;
        }
    }

    public void clearLabels() {
        if (this.labels != null) {
            this.labels.clear();
            ++this.modificationCount;
        }
    }

    public WikittyLabelDTO() {
    }

    public WikittyLabelDTO(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String toString() {
        return "dto:" + this.getWikittyId() + ":" + this.getWikittyVersion();
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String getWikittyVersion() {
        String result = this.wikittyVersion;
        if (this.modificationCount > 0) {
            result = result + "." + this.modificationCount;
        }
        return result;
    }

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion = wikittyVersion;
        this.modificationCount = 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyLabel)) {
            throw new WikittyException("Can't copy source object " + source + ". They are not of the same type");
        }
        WikittyLabel sourceCopy = (WikittyLabel)source;
        Set labels = sourceCopy.getLabels();
        if (labels != null) {
            this.setLabels(new LinkedHashSet<String>(labels));
        }
        this.setWikittyVersion(sourceCopy.getWikittyVersion());
    }
}

