/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryParser;
import org.nuiton.wikitty.query.conditions.Aggregate;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;

public class WikittyQueryMaker {
    private static Log log = LogFactory.getLog(WikittyQueryMaker.class);
    protected WikittyQuery query;
    protected Condition condition;
    protected Deque<Condition> openStack = new LinkedList<Condition>();

    public WikittyQueryMaker() {
    }

    public WikittyQueryMaker(WikittyQuery query) {
        this.query = query;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public WikittyQuery getQuery() {
        if (this.query == null) {
            this.query = new WikittyQuery();
        }
        this.query.setCondition(this.getCondition());
        return this.query;
    }

    protected Deque<Condition> getOpenStack() {
        if (this.openStack == null) {
            throw new WikittyException("You can't create condition if you have used setCondition method or close last condition");
        }
        return this.openStack;
    }

    protected void addCondition(Condition c) {
        this.addCondition(c, false);
    }

    protected void addCondition(Condition c, boolean terminal) {
        Condition parent = this.getOpenStack().peek();
        if (!terminal) {
            this.getOpenStack().push(c);
        }
        if (parent == null) {
            this.condition = c;
        } else {
            parent.addCondition(c);
            if (!terminal) {
                this.closeIfNecessary();
            }
        }
    }

    protected void closeIfNecessary() {
        while (this.getOpenStack().peek() != null && !this.getOpenStack().peek().waitCondition()) {
            this.getOpenStack().poll();
        }
        if (this.getOpenStack().size() == 0) {
            this.openStack = null;
        }
    }

    protected static ConditionValue convertToConditionValue(Object o) {
        ConditionValue result;
        if (o instanceof ConditionValue) {
            result = (ConditionValue)o;
        } else {
            String s = WikittyUtil.toString(o);
            result = new ConditionValueString(s);
        }
        return result;
    }

    public WikittyQueryMaker value(Object value) {
        ConditionValue v = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(v);
        return this;
    }

    public WikittyQueryMaker condition(Condition c) {
        this.addCondition(c, true);
        return this;
    }

    public WikittyQueryMaker parse(String query) {
        if (StringUtils.isNotBlank((CharSequence)query)) {
            WikittyQuery filter = WikittyQueryParser.parse(query);
            this.addCondition(filter.getCondition(), true);
        } else {
            this.addCondition(new True());
        }
        return this;
    }

    public WikittyQueryMaker wikitty(Wikitty w) {
        WikittyQueryMaker result = new WikittyQueryMaker().and();
        result.extContainsAll(w.getExtensionNames());
        for (String fqfieldName : w.fieldNames()) {
            Object value = w.getFqField(fqfieldName);
            if (value == null) continue;
            FieldType type = w.getFieldType(fqfieldName);
            if (type.isCollection()) {
                result.containsAll(fqfieldName, (Collection)value);
                continue;
            }
            result.eq(fqfieldName, value);
        }
        this.addCondition(result.getCondition());
        return this;
    }

    public WikittyQueryMaker wikitty(BusinessEntityImpl e) {
        Wikitty w = e.getWikitty();
        return this.wikitty(w);
    }

    public WikittyQueryMaker containsAll(Element element) {
        this.addCondition(new ContainsAll(element));
        return this;
    }

    public WikittyQueryMaker containsAll(String element) {
        return this.containsAll(Element.get(element));
    }

    public <E> WikittyQueryMaker containsAll(String fqfield, Collection<E> values) {
        return this.containsAll(Element.get(fqfield), values);
    }

    public <E> WikittyQueryMaker containsAll(Element element, Collection<E> values) {
        this.containsAll(element);
        for (E e : values) {
            this.value(e);
        }
        this.close();
        return this;
    }

    public <E> WikittyQueryMaker containsAll(String fqfield, E value1, E ... values) {
        LinkedList<E> l = new LinkedList<E>();
        l.add(value1);
        l.addAll(Arrays.asList(values));
        return this.containsAll(fqfield, l);
    }

    public WikittyQueryMaker containsOne(Element element) {
        this.addCondition(new ContainsOne(element));
        return this;
    }

    public WikittyQueryMaker containsOne(String element) {
        return this.containsOne(Element.get(element));
    }

    public <E> WikittyQueryMaker containsOne(String fqfield, Collection<E> values) {
        return this.containsOne(Element.get(fqfield), values);
    }

    public <E> WikittyQueryMaker containsOne(Element element, Collection<E> values) {
        this.containsOne(element);
        for (E e : values) {
            this.value(e);
        }
        this.close();
        return this;
    }

    public <E> WikittyQueryMaker containsOne(String fqfield, E value1, E ... values) {
        LinkedList<E> l = new LinkedList<E>();
        l.add(value1);
        l.addAll(Arrays.asList(values));
        return this.containsOne(fqfield, l);
    }

    public WikittyQueryMaker eq(Element element) {
        this.addCondition(new Equals(element));
        return this;
    }

    public WikittyQueryMaker eq(String fqfield, Object value) {
        return this.eq(Element.get(fqfield), value);
    }

    public WikittyQueryMaker eq(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new Equals(element, s));
        return this;
    }

    public WikittyQueryMaker eqIgnoreCaseAndAccent(Element element) {
        this.addCondition(new Equals(element, true));
        return this;
    }

    public WikittyQueryMaker eqIgnoreCaseAndAccent(String fqfield, Object value) {
        return this.eqIgnoreCaseAndAccent(Element.get(fqfield), value);
    }

    public WikittyQueryMaker eqIgnoreCaseAndAccent(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new Equals(element, s, true));
        return this;
    }

    public WikittyQueryMaker exteq(String extensionName) {
        return this.eq(Element.EXTENSION, (Object)extensionName);
    }

    public WikittyQueryMaker ideq(Object idOrWikitty) {
        return this.eq(Element.ID, idOrWikitty);
    }

    public WikittyQueryMaker extContainsAll(Collection<String> extensionNames) {
        return this.containsAll(Element.EXTENSION, extensionNames);
    }

    public WikittyQueryMaker extContainsAll(String ext1, String ... exts) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(ext1);
        l.addAll(Arrays.asList(exts));
        return this.containsAll(Element.EXTENSION, l);
    }

    public WikittyQueryMaker extContainsOne(Collection<String> extensionNames) {
        return this.containsOne(Element.EXTENSION, extensionNames);
    }

    public WikittyQueryMaker extContainsOne(String ext1, String ... exts) {
        LinkedList<String> l = new LinkedList<String>();
        l.add(ext1);
        l.addAll(Arrays.asList(exts));
        return this.containsOne(Element.EXTENSION, l);
    }

    public WikittyQueryMaker ne(Element element) {
        this.addCondition(new NotEquals(element));
        return this;
    }

    public WikittyQueryMaker ne(String fqfield, Object value) {
        return this.ne(Element.get(fqfield), value);
    }

    public WikittyQueryMaker ne(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new NotEquals(element, s));
        return this;
    }

    public WikittyQueryMaker neIgnoreCaseAndAccent(Element element) {
        this.addCondition(new NotEquals(element, true));
        return this;
    }

    public WikittyQueryMaker neIgnoreCaseAndAccent(String fqfield, Object value) {
        return this.neIgnoreCaseAndAccent(Element.get(fqfield), value);
    }

    public WikittyQueryMaker neIgnoreCaseAndAccent(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new NotEquals(element, s, true));
        return this;
    }

    public WikittyQueryMaker extne(String extensionName) {
        return this.ne(Element.EXTENSION, (Object)extensionName);
    }

    public WikittyQueryMaker idne(Object idOrWikitty) {
        return this.ne(Element.ID, idOrWikitty);
    }

    public WikittyQueryMaker gt(Element element) {
        this.addCondition(new Greater(element));
        return this;
    }

    public WikittyQueryMaker gt(String fqfield, Object value) {
        return this.gt(Element.get(fqfield), value);
    }

    public WikittyQueryMaker gt(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new Greater(element, s));
        return this;
    }

    public WikittyQueryMaker ge(Element element) {
        this.addCondition(new GreaterOrEquals(element));
        return this;
    }

    public WikittyQueryMaker ge(String fqfield, Object value) {
        return this.ge(Element.get(fqfield), value);
    }

    public WikittyQueryMaker ge(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new GreaterOrEquals(element, s));
        return this;
    }

    public WikittyQueryMaker lt(Element element) {
        this.addCondition(new Less(element));
        return this;
    }

    public WikittyQueryMaker lt(String fqfield, Object value) {
        return this.lt(Element.get(fqfield), value);
    }

    public WikittyQueryMaker lt(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new Less(element, s));
        return this;
    }

    public WikittyQueryMaker le(Element element) {
        this.addCondition(new LessOrEquals(element));
        return this;
    }

    public WikittyQueryMaker le(String fqfield, Object value) {
        return this.le(Element.get(fqfield), value);
    }

    public WikittyQueryMaker le(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new LessOrEquals(element, s));
        return this;
    }

    public WikittyQueryMaker bw(Element element) {
        this.addCondition(new Between(element));
        return this;
    }

    public WikittyQueryMaker bw(String fqfield, Object lowerValue, Object upperValue) {
        return this.bw(Element.get(fqfield), lowerValue, upperValue);
    }

    public WikittyQueryMaker bw(Element element, Object lowerValue, Object upperValue) {
        ConditionValue min = WikittyQueryMaker.convertToConditionValue(lowerValue);
        ConditionValue max = WikittyQueryMaker.convertToConditionValue(upperValue);
        this.addCondition(new Between(element, min, max));
        return this;
    }

    public WikittyQueryMaker sw(String fqfield, String value) {
        return this.sw(Element.get(fqfield), value);
    }

    public WikittyQueryMaker sw(Element element, String value) {
        this.addCondition(new Equals(element, value + "*"));
        return this;
    }

    public WikittyQueryMaker notsw(String fqfield, String value) {
        return this.notsw(Element.get(fqfield), value);
    }

    public WikittyQueryMaker notsw(Element element, String value) {
        this.addCondition(new NotEquals(element, value + "*"));
        return this;
    }

    public WikittyQueryMaker ew(String fqfield, Object value) {
        return this.ew(Element.get(fqfield), value);
    }

    public WikittyQueryMaker ew(Element element, Object value) {
        this.addCondition(new Equals(element, "*" + value));
        return this;
    }

    public WikittyQueryMaker notew(String fqfield, Object value) {
        return this.notew(Element.get(fqfield), value);
    }

    public WikittyQueryMaker notew(Element element, Object value) {
        this.addCondition(new NotEquals(element, "*" + value));
        return this;
    }

    public WikittyQueryMaker keyword() {
        this.addCondition(new Keyword());
        return this;
    }

    public WikittyQueryMaker keyword(Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        this.addCondition(new Keyword().addCondition(s));
        return this;
    }

    public WikittyQueryMaker isNull(String fqfield) {
        return this.isNull(Element.get(fqfield));
    }

    public WikittyQueryMaker isNull(Element element) {
        this.addCondition(new Null(element));
        return this;
    }

    public WikittyQueryMaker isNotNull(String fqfield) {
        return this.isNotNull(Element.get(fqfield));
    }

    public WikittyQueryMaker isNotNull(Element element) {
        this.addCondition(new NotNull(element));
        return this;
    }

    public WikittyQueryMaker rFalse() {
        this.addCondition(new False());
        return this;
    }

    public WikittyQueryMaker rTrue() {
        this.addCondition(new True());
        return this;
    }

    public WikittyQueryMaker like(Element element) {
        this.addCondition(new Like(element));
        return this;
    }

    public WikittyQueryMaker like(String fqfield, Object value) {
        return this.like(Element.get(fqfield), value);
    }

    public WikittyQueryMaker like(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        Like c = new Like(element, s);
        this.addCondition(c);
        return this;
    }

    public WikittyQueryMaker unlike(Element element) {
        this.addCondition(new Unlike(element));
        return this;
    }

    public WikittyQueryMaker unlike(String fqfield, Object value) {
        return this.unlike(Element.get(fqfield), value);
    }

    public WikittyQueryMaker unlike(Element element, Object value) {
        ConditionValue s = WikittyQueryMaker.convertToConditionValue(value);
        Unlike c = new Unlike(element, s);
        this.addCondition(c);
        return this;
    }

    public WikittyQueryMaker not() {
        Not child = new Not();
        this.addCondition(child);
        return this;
    }

    public WikittyQueryMaker or() {
        Or child = new Or(new Condition[0]);
        this.addCondition(child);
        return this;
    }

    public WikittyQueryMaker and() {
        And child = new And(new Condition[0]);
        this.addCondition(child);
        return this;
    }

    public WikittyQueryMaker select(String element) {
        return this.select(Element.get(element));
    }

    public WikittyQueryMaker select(String element, Aggregate aggregate) {
        return this.select(Element.get(element), aggregate);
    }

    public WikittyQueryMaker select(Element element) {
        return this.select(element, null);
    }

    public WikittyQueryMaker select(Element element, Aggregate aggregate) {
        Select child = new Select(element, aggregate);
        this.addCondition(child);
        return this;
    }

    public WikittyQueryMaker close() {
        this.getOpenStack().pop();
        this.closeIfNecessary();
        return this;
    }

    public WikittyQuery end() {
        WikittyQuery result = this.getQuery();
        result.setCondition(this.getCondition());
        this.openStack = null;
        return result;
    }
}

