/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: Select.java 1463 2012-04-05 16:08:38Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.8/wikitty-api/src/main/java/org/nuiton/wikitty/query/conditions/Select.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.query.conditions;

import org.nuiton.wikitty.entities.Element;
import org.apache.commons.lang3.ObjectUtils;

/**
 * Cette condition n'accept pas d'etre utilise dans une autre condition.
 * Il sert a demander l'extraction d'un autre champs que l'id. Si la valeur
 * du champs est retrouvee plusieurs fois, cette valeur n'apparaitra qu'une
 * seule fois dans les resultats (comme 'DISTINCT' en SQL)
 * <p>
 * Il y a donc deux types d'utilisation possible
 * 
 * <pre>
 * SELECT extName.fieldName WHERE condition
 * condition ... IN (SELECT extName.fieldName WHERE other condition)
 * </pre>
 *
 * @author poussin
 * @version $Revision: 1463 $
 *
 * Last update: $Date: 2012-04-05 18:08:38 +0200 (jeu. 05 avril 2012) $
 * by : $Author: bpoussin $
 */
public class Select extends ContainerUnaryOperator implements ConditionValue{

    private static final long serialVersionUID = 1L;

    protected Aggregate aggregate;
    protected Element element;

    public Select(Element element) {
        this.element = element;
    }

    public Select(Element element, Aggregate aggregate) {
        this.element = element;
        this.aggregate = aggregate;
    }

    public Select(Element element, Condition restriction) {
        super(restriction);
        this.element = element;
    }

    public Select(Element element, Aggregate aggregate, Condition restriction) {
        super(restriction);
        this.element = element;
        this.aggregate = aggregate;
    }

    public Aggregate getAggregate() {
        return aggregate;
    }

    public Element getElement() {
        return element;
    }

    @Override
    boolean equalsDeep(Object other) {
        boolean result = super.equalsDeep(other);
        if (result) {
            Select op = (Select)other;
            result = ObjectUtils.equals(this.getElement(), op.getElement());
        }
        return result;
    }
}
