/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryParser;
import org.nuiton.wikitty.query.WikittyQueryResult;

public class FieldTypeConstaintChecker {
    private static Log log = LogFactory.getLog(FieldTypeConstaintChecker.class);
    protected WikittyService ws;
    protected String token;

    public FieldTypeConstaintChecker(WikittyClient client) {
        this.ws = client.getWikittyService();
        this.token = client.getSecurityToken();
    }

    public FieldTypeConstaintChecker(WikittyService ws) {
        this.ws = ws;
    }

    public boolean isValid(String fqfield, FieldType field, Object value, Collection<String> errors) {
        boolean result = true;
        result = result && this.isNotNull(fqfield, field, value, errors);
        result = result && this.isUnique(fqfield, field, value, errors);
        result = result && this.checkPattern(fqfield, field, value, errors);
        result = result && this.checkMin(fqfield, field, value, errors);
        result = result && this.checkMax(fqfield, field, value, errors);
        result = result && this.isAllowed(fqfield, field, value, errors);
        return result;
    }

    public Object getMin(FieldType field) {
        String min = null;
        if (field.hasMinQuery()) {
            String query = field.getMinQuery();
            WikittyQuery q = WikittyQueryParser.parse(query);
            List<String> queryResult = this.ws.findByQuery(this.token, Collections.singletonList(q));
            min = queryResult.get(0);
        }
        if (min == null && field.hasMin()) {
            min = field.getMin();
        }
        Object result = null;
        if (min != null) {
            result = field.getContainedValidObject(min);
        }
        return result;
    }

    public Date getMinAsDate(FieldType field) {
        Date result = (Date)this.getMin(field);
        return result;
    }

    public BigDecimal getMinAsBigDecimal(FieldType field) {
        BigDecimal result = (BigDecimal)this.getMin(field);
        return result;
    }

    public Object getMax(FieldType field) {
        String max = null;
        if (field.hasMaxQuery()) {
            String query = field.getMaxQuery();
            WikittyQuery q = WikittyQueryParser.parse(query);
            List<String> queryResult = this.ws.findByQuery(this.token, Collections.singletonList(q));
            max = queryResult.get(0);
        }
        if (max == null && field.hasMax()) {
            max = field.getMax();
        }
        Object result = null;
        if (max != null) {
            result = field.getContainedValidObject(max);
        }
        return result;
    }

    public Date getMaxAsDate(FieldType field) {
        Date result = (Date)this.getMax(field);
        return result;
    }

    public BigDecimal getMaxAsBigDecimal(FieldType field) {
        BigDecimal result = (BigDecimal)this.getMax(field);
        return result;
    }

    public boolean isAllowed(String fqfield, FieldType field, Object value, Collection<String> errors) {
        boolean result = true;
        if (value != null && (field.hasAllowed() || field.hasAllowedQuery())) {
            switch (field.getType()) {
                case STRING: {
                    if (field.isCollection()) {
                        result = this.isAllowedString(fqfield, field, (Collection)value, errors);
                        break;
                    }
                    result = this.isAllowedString(fqfield, field, Collections.singleton((String)value), errors);
                    break;
                }
                case WIKITTY: {
                    if (field.isCollection()) {
                        result = this.isAllowedWikitty(fqfield, field, (Collection)value, errors);
                        break;
                    }
                    result = this.isAllowedWikitty(fqfield, field, Collections.singleton((String)value), errors);
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    protected boolean isAllowedWikitty(String fqfield, FieldType field, Collection<String> ids, Collection<String> errors) {
        boolean result = false;
        WikittyQuery q = null;
        if (field.hasAllowedQuery()) {
            q = WikittyQueryParser.parse(field.getAllowedQuery());
        } else if (field.hasAllowed()) {
            WikittyQueryMaker maker = new WikittyQueryMaker().or();
            for (String extName : field.getAllowedAsList()) {
                maker.exteq(extName);
            }
            q = maker.end();
        }
        List<String> allowed = null;
        if (q != null) {
            q.setOffset(0);
            q.setLimit(Integer.MAX_VALUE);
            WikittyQuery wq = new WikittyQueryMaker().containsOne(Element.ID, ids).end();
            wq.setOffset(0);
            wq.setLimit(Integer.MAX_VALUE);
            List<WikittyQueryResult<String>> queryResult = this.ws.findAllByQuery(this.token, Arrays.asList(q, wq));
            allowed = queryResult.get(0).getAll();
            List<String> findedIds = queryResult.get(1).getAll();
            result = allowed.containsAll(findedIds);
            if (log.isDebugEnabled() && findedIds.size() != ids.size()) {
                log.debug((Object)String.format("For field '%s' allowed contraint not checked for: %s", fqfield, CollectionUtils.disjunction(findedIds, ids)));
            }
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains unallowed Wikitty values %s allowed %s", fqfield, ids, allowed));
        }
        return result;
    }

    protected boolean isAllowedString(String fqfield, FieldType field, Collection<String> values, Collection<String> errors) {
        boolean result = false;
        List<String> allowed = null;
        if (field.hasAllowed()) {
            allowed = field.getAllowedAsList();
            result = allowed.containsAll(values);
        }
        if (!result && field.hasAllowedQuery()) {
            String query = field.getAllowedQuery();
            WikittyQuery q = WikittyQueryParser.parse(query);
            q.setOffset(0).setLimit(Integer.MAX_VALUE);
            List<WikittyQueryResult<String>> queryResult = this.ws.findAllByQuery(this.token, Collections.singletonList(q));
            allowed = queryResult.get(0).getAll();
            result = allowed.containsAll(values);
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains unallowed string values: %s allowed: %s", fqfield, values, allowed));
        }
        return result;
    }

    public boolean checkPattern(String fqfield, FieldType field, Object value, Collection<String> errors) {
        boolean result = true;
        if (value != null && field.hasPattern() && field.getType() == WikittyTypes.STRING) {
            String pattern = field.getPattern();
            result = Pattern.matches(pattern, (String)value);
            if (errors != null && !result) {
                errors.add(String.format("Field '%s' must match pattern '%s' but value is '%s'", fqfield, pattern, value));
            }
        }
        return result;
    }

    public boolean isNotNull(String fqfield, FieldType field, Object value, Collection<String> errors) {
        boolean result = true;
        if (field.isNotNull()) {
            boolean bl = result = value != null;
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains null value", fqfield));
        }
        return result;
    }

    public boolean isUnique(String fqfield, FieldType field, Object value, Collection<String> errors) {
        boolean result = true;
        if (field.isUnique() && value != null && field.isCollection() && !(value instanceof Set)) {
            Collection c = (Collection)value;
            HashSet s = new HashSet(c);
            boolean bl = result = s.size() == c.size();
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains duplicate value", fqfield));
        }
        return result;
    }

    public boolean checkMin(String fqfield, FieldType field, Object value, Collection<String> errors) {
        boolean result = true;
        if (value != null && (field.hasMin() || field.hasMinQuery())) {
            switch (field.getType()) {
                case DATE: {
                    if (field.isCollection()) {
                        result = this.checkMinDate(fqfield, field, (Collection)value, errors);
                        break;
                    }
                    result = this.checkMinDate(fqfield, field, Collections.singleton((Date)value), errors);
                    break;
                }
                case NUMERIC: {
                    if (field.isCollection()) {
                        result = this.checkMinBigDecimal(fqfield, field, (Collection)value, errors);
                        break;
                    }
                    result = this.checkMinBigDecimal(fqfield, field, Collections.singleton((BigDecimal)value), errors);
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    protected boolean checkMinDate(String fqfield, FieldType field, Collection<Date> values, Collection<String> errors) {
        Date b;
        boolean result = true;
        Date min = this.getMinAsDate(field);
        Iterator<Date> i$ = values.iterator();
        while (i$.hasNext() && (result = min.compareTo(b = i$.next()) <= 0)) {
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains value higher then '%s': %s", fqfield, min, values));
        }
        return result;
    }

    protected boolean checkMinBigDecimal(String fqfield, FieldType field, Collection<BigDecimal> values, Collection<String> errors) {
        BigDecimal b;
        boolean result = true;
        BigDecimal min = this.getMinAsBigDecimal(field);
        Iterator<BigDecimal> i$ = values.iterator();
        while (i$.hasNext() && (result = min.compareTo(b = i$.next()) <= 0)) {
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains value higher then '%s': %s", fqfield, min, values));
        }
        return result;
    }

    public boolean checkMax(String fqfield, FieldType field, Object value, Collection<String> errors) {
        boolean result = true;
        if (value != null && (field.hasMax() || field.hasMaxQuery())) {
            switch (field.getType()) {
                case DATE: {
                    if (field.isCollection()) {
                        result = this.checkMaxDate(fqfield, field, (Collection)value, errors);
                        break;
                    }
                    result = this.checkMaxDate(fqfield, field, Collections.singleton((Date)value), errors);
                    break;
                }
                case NUMERIC: {
                    if (field.isCollection()) {
                        result = this.checkMaxBigDecimal(fqfield, field, (Collection)value, errors);
                        break;
                    }
                    result = this.checkMaxBigDecimal(fqfield, field, Collections.singleton((BigDecimal)value), errors);
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    protected boolean checkMaxDate(String fqfield, FieldType field, Collection<Date> values, Collection<String> errors) {
        Date b;
        boolean result = true;
        Date max = this.getMaxAsDate(field);
        Iterator<Date> i$ = values.iterator();
        while (i$.hasNext() && (result = max.compareTo(b = i$.next()) >= 0)) {
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains value lower then '%s': %s", fqfield, max, values));
        }
        return result;
    }

    protected boolean checkMaxBigDecimal(String fqfield, FieldType field, Collection<BigDecimal> values, Collection<String> errors) {
        BigDecimal b;
        boolean result = true;
        BigDecimal max = this.getMaxAsBigDecimal(field);
        Iterator<BigDecimal> i$ = values.iterator();
        while (i$.hasNext() && (result = max.compareTo(b = i$.next()) >= 0)) {
        }
        if (errors != null && !result) {
            errors.add(String.format("Field '%s' contains value lower then '%s': %s", fqfield, max, values));
        }
        return result;
    }
}

