package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class ProductEntityAbstract extends BusinessEntityImpl implements ProductEntity {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionProductEntity;

    @Override
    public String getName() {
String value = ProductEntityHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
ProductEntityHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_NAME, oldValue, getName());
}

    @Override
    public int getPrice() {
int value = ProductEntityHelper.getPrice(getWikitty());
return value;
}

    @Override
    public void setPrice(int price) {
int oldValue = getPrice();
ProductEntityHelper.setPrice(getWikitty(), price);
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_PRICE, oldValue, getPrice());
}

    @Override
    public Set<String> getColors() {
Set<String> result = ProductEntityHelper.getColors(getWikitty());
return result;
}

    @Override
    public void setColors(Set<String> colors) {
Set<String> oldValue = getColors();
ProductEntityHelper.setColors(getWikitty(), colors);
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_COLORS, oldValue, getColors());
}

    @Override
    public void addAllColors(Collection<String> colors) {
Set<String> oldValue = getColors();
ProductEntityHelper.addAllColors(getWikitty(), colors);
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_COLORS, oldValue, getColors());
}

    @Override
    public void addColors(String... element) {
Set<String> oldValue = getColors();
ProductEntityHelper.addColors(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_COLORS, oldValue, getColors());
}

    @Override
    public void removeColors(String... element) {
Set<String> oldValue = getColors();
ProductEntityHelper.removeColors(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_COLORS, oldValue, getColors());
}

    @Override
    public void clearColors() {
ProductEntityHelper.clearColors(getWikitty());
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_COLORS, null, getColors());
}

    @Override
    public String getCategoryEntity() {
String value = ProductEntityHelper.getCategoryEntity(getWikitty());
return value;
}

    @Override
    public void setCategoryEntity(String categoryEntity) {
String oldValue = getCategoryEntity();
ProductEntityHelper.setCategoryEntity(getWikitty(), categoryEntity);
getPropertyChangeSupport().firePropertyChange(ProductEntity.FIELD_PRODUCTENTITY_CATEGORYENTITY, oldValue, getCategoryEntity());
}

    public ProductEntityAbstract() {
        super();
}

    public ProductEntityAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public ProductEntityAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionProductEntity = new WikittyExtension(EXT_PRODUCTENTITY,
                "0.1", // version
                WikittyUtil.tagValuesToMap(" version=\"0.1\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name unique=\"true\"", 
                                             "Numeric price unique=\"true\"", 
                                             "String colors[0-*] unique=\"true\"", 
                                             "Wikitty categoryEntity[0-1] unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionProductEntity);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return ProductEntityHelper.toString(getWikitty());
}

} //ProductEntityAbstract
