/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;

public class ScriptEvaluator {
    private static Log log = LogFactory.getLog(ScriptEvaluator.class);
    protected static ScriptEngineManager scriptEnginManager;

    public static ScriptEngineManager getScriptEnginManager(ClassLoader classLoader) {
        ScriptEngineManager result;
        if (classLoader != null) {
            result = new ScriptEngineManager(classLoader);
        } else {
            if (scriptEnginManager == null) {
                scriptEnginManager = new ScriptEngineManager();
            }
            result = scriptEnginManager;
        }
        return result;
    }

    public static ScriptEngine getScriptEngin(ClassLoader classLoader, String name, String mimetype) {
        ScriptEngineManager scriptEnginManager = ScriptEvaluator.getScriptEnginManager(classLoader);
        ScriptEngine scriptEngin = scriptEnginManager.getEngineByMimeType(mimetype);
        if (scriptEngin == null) {
            List<ScriptEngineFactory> factories = scriptEnginManager.getEngineFactories();
            String msgFactories = "";
            for (ScriptEngineFactory f : factories) {
                msgFactories = msgFactories + String.format("\n%s extensions: %s mimetypes: %s", f.getEngineName(), f.getExtensions(), f.getMimeTypes());
            }
            throw new WikittyException(String.format("Can't find engine for %s(%s). Available engines: %s", name, mimetype, msgFactories));
        }
        return scriptEngin;
    }

    public static Object eval(ClassLoader classLoader, String name, String script, String mimetype, Map<String, Object> bindings) {
        ScriptEngine scriptEngin = ScriptEvaluator.getScriptEngin(classLoader, name, mimetype);
        Bindings b = scriptEngin.createBindings();
        b.putAll((Map<? extends String, ? extends Object>)bindings);
        try {
            Object result = scriptEngin.eval(script, b);
            return result;
        }
        catch (ScriptException eee) {
            throw new WikittyException(String.format("Can't evaluated script %s(%s=>%s) script was\n%s", name, mimetype, scriptEngin.getFactory().getEngineName(), script), eee);
        }
    }

    public static Map<String, Object> exec(ClassLoader classLoader, String name, String script, String mimetype, Map<String, Object> bindings) {
        ScriptEngine scriptEngin = ScriptEvaluator.getScriptEngin(classLoader, name, mimetype);
        Bindings b = scriptEngin.createBindings();
        b.putAll((Map<? extends String, ? extends Object>)bindings);
        try {
            scriptEngin.eval(script, b);
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e : bindings.entrySet()) {
                Object value = scriptEngin.get(e.getKey());
                result.put(e.getKey(), value);
            }
            return result;
        }
        catch (ScriptException eee) {
            throw new WikittyException(String.format("Can't evaluated script %s(%s=>%s) script was\n%s", name, mimetype, scriptEngin.getFactory().getEngineName(), script), eee);
        }
    }
}

