/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyConfigAction;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.ExtensionFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.services.WikittyServiceDelegator;
import org.nuiton.wikitty.services.WikittyServiceInMemory;
import org.nuiton.wikitty.test.CatalogNode;
import org.nuiton.wikitty.test.CatalogNodeImpl;
import org.nuiton.wikitty.test.Category;
import org.nuiton.wikitty.test.CategoryImpl;
import org.nuiton.wikitty.test.Product;
import org.nuiton.wikitty.test.ProductImpl;

public abstract class WikittyClientAbstractTest {
    private static Log log = LogFactory.getLog(WikittyClientAbstractTest.class);
    protected static ApplicationConfig wikittyConfig;
    protected WikittyClient wikittyClient;
    protected static DateFormat df;
    protected static final String MEDIA_EXTENSION_NAME = "Media";
    protected static final WikittyExtension MEDIA_EXTENSION;
    protected static final String MOVIE_EXTENSION_NAME = "Movies";
    protected static final WikittyExtension MOVIE_EXTENSION;

    protected void assumeTrueSearchEngineCanRunTest() {
        WikittyService ws = this.wikittyClient.getWikittyService();
        while (ws instanceof WikittyServiceDelegator) {
            ws = ((WikittyServiceDelegator)ws).getDelegate();
        }
        boolean isInMomory = ws instanceof WikittyServiceInMemory;
        if (isInMomory) {
            log.warn((Object)"Not yet implemented in memory, skipping");
        }
        Assume.assumeTrue((!isInMomory ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void setUpConfig() {
        wikittyConfig = new ApplicationConfig(WikittyConfigOption.class, WikittyConfigAction.class, null, null);
    }

    protected WikittyClient getWikittyClient() {
        WikittyServiceInMemory wikittyService = new WikittyServiceInMemory(wikittyConfig);
        WikittyClient client = new WikittyClient(wikittyConfig, (WikittyService)wikittyService);
        return client;
    }

    @Before
    public void setUpTestData() throws ParseException {
        this.wikittyClient = this.getWikittyClient();
        this.wikittyClient.clear();
        this.addTestDataInClient(this.wikittyClient);
    }

    protected void addTestDataInClient(WikittyClient client) throws ParseException {
        CategoryImpl sf = new CategoryImpl("sf", "science fiction");
        CategoryImpl history = new CategoryImpl("history", "history");
        CategoryImpl society = new CategoryImpl("society", "soci\u00e9t\u00e9");
        CategoryImpl fantastic = new CategoryImpl("fan", "fantastique");
        CategoryImpl fantaisie = new CategoryImpl("hf", "heroique/fantaisie");
        client.store((BusinessEntity)sf, (BusinessEntity)society, (BusinessEntity[])new Category[]{fantastic, fantaisie, history});
        ProductImpl book42 = new ProductImpl("Answer to life the universe and everything");
        book42.setWikittyVersion("2.0");
        book42.setPrice(4200);
        book42.setPicturePrice(420);
        book42.setPriceFromProduct(42);
        book42.addColors("white", "black");
        book42.setDate(df.parse("December 25, 1983"));
        book42.setCategory(sf.getWikittyId());
        ProductImpl bookIndignez = new ProductImpl("Indignez-vous !");
        bookIndignez.setPrice(1);
        bookIndignez.setPicturePrice(2);
        bookIndignez.setPriceFromProduct(15);
        bookIndignez.setCategory(sf.getWikittyId());
        bookIndignez.addColors("white");
        bookIndignez.setDate(df.parse("April 12, 2011"));
        bookIndignez.setCategory(society.getWikittyId());
        ProductImpl bookLotr = new ProductImpl("Le seigneur des anneaux");
        bookLotr.setPrice(11);
        bookLotr.setPicturePrice(12);
        bookLotr.setPriceFromProduct(100);
        bookLotr.setCategory(sf.getWikittyId());
        bookLotr.setDate(df.parse("July 9, 1953"));
        bookLotr.addColors("red", "blue");
        ProductImpl bookLan = new ProductImpl("Lanfeust");
        bookLan.setWikittyVersion("3.0");
        bookLan.setPrice(0);
        bookLan.setPicturePrice(5);
        bookLan.setPriceFromProduct(13);
        bookLan.setCategory(fantastic.getWikittyId());
        bookLan.addColors("red", "yellow");
        bookLan.setDate(df.parse("January 12, 2002"));
        client.store((BusinessEntity)book42, (BusinessEntity)bookIndignez, (BusinessEntity[])new Product[]{bookLotr, bookLan});
        client.storeExtension(MOVIE_EXTENSION);
        WikittyImpl dieHardMovie = new WikittyImpl();
        dieHardMovie.addExtension(MEDIA_EXTENSION);
        dieHardMovie.addExtension(MOVIE_EXTENSION);
        dieHardMovie.setField(MOVIE_EXTENSION_NAME, "name", (Object)"Die hard 4");
        dieHardMovie.addToField(MOVIE_EXTENSION_NAME, "authors", (Object)"Willis");
        dieHardMovie.setField(MOVIE_EXTENSION_NAME, "date", (Object)"04/02/2009");
        WikittyImpl edgarMovie = new WikittyImpl();
        edgarMovie.addExtension(MEDIA_EXTENSION);
        edgarMovie.addExtension(MOVIE_EXTENSION);
        edgarMovie.setField(MOVIE_EXTENSION_NAME, "name", (Object)"J. Edgar");
        edgarMovie.addToField(MOVIE_EXTENSION_NAME, "authors", (Object)"Eastwood");
        edgarMovie.setField(MOVIE_EXTENSION_NAME, "date", (Object)"25/12/2011");
        WikittyImpl dnrMovie = new WikittyImpl();
        dnrMovie.addExtension(MEDIA_EXTENSION);
        dnrMovie.addExtension(MOVIE_EXTENSION);
        dnrMovie.setField(MOVIE_EXTENSION_NAME, "name", (Object)"The Dark Knight Rises");
        dnrMovie.addToField(MOVIE_EXTENSION_NAME, "authors", (Object)"Nolan");
        dnrMovie.setField(MOVIE_EXTENSION_NAME, "date", (Object)"13/03/2012");
        client.store((Wikitty)dieHardMovie, (Wikitty)edgarMovie, new Wikitty[]{dnrMovie});
        CatalogNodeImpl catalogNode = new CatalogNodeImpl("Catalog");
        CatalogNodeImpl mediaNode = new CatalogNodeImpl(MEDIA_EXTENSION_NAME);
        mediaNode.setParent(catalogNode.getWikittyId());
        CatalogNodeImpl bookNode = new CatalogNodeImpl("Books");
        bookNode.setParent(mediaNode.getWikittyId());
        CatalogNodeImpl bdNode = new CatalogNodeImpl("Bande dessin\u00e9es");
        bdNode.setParent(bookNode.getWikittyId());
        bdNode.addAttachment(new String[]{bookLan.getWikittyId()});
        CatalogNodeImpl newsNode = new CatalogNodeImpl("Nouvelles");
        newsNode.setParent(bookNode.getWikittyId());
        newsNode.addAttachment(new String[]{bookIndignez.getWikittyId()});
        CatalogNodeImpl romanNode = new CatalogNodeImpl("Roman");
        romanNode.setParent(bookNode.getWikittyId());
        romanNode.addAttachment(new String[]{book42.getWikittyId(), bookLotr.getWikittyId()});
        CatalogNodeImpl moviesNode = new CatalogNodeImpl(MOVIE_EXTENSION_NAME);
        moviesNode.setParent(mediaNode.getWikittyId());
        CatalogNodeImpl actionNode = new CatalogNodeImpl("Action");
        actionNode.setParent(moviesNode.getWikittyId());
        actionNode.addAttachment(new String[]{dieHardMovie.getWikittyId(), dnrMovie.getWikittyId()});
        CatalogNodeImpl biopicNode = new CatalogNodeImpl("Biopic");
        biopicNode.setParent(moviesNode.getWikittyId());
        biopicNode.addAttachment(new String[]{edgarMovie.getWikittyId()});
        CatalogNodeImpl otherNode = new CatalogNodeImpl("Everything else");
        otherNode.setParent(catalogNode.getWikittyId());
        client.store((BusinessEntity)catalogNode, (BusinessEntity)mediaNode, (BusinessEntity[])new CatalogNode[]{bookNode, bdNode, newsNode, romanNode, moviesNode, actionNode, biopicNode, otherNode});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importBooks() throws IOException {
        WikittyImportExportService ieService = new WikittyImportExportService(this.wikittyClient);
        InputStreamReader reader = null;
        try {
            InputStream is = WikittyClientAbstractTest.class.getResourceAsStream("/csv/importbooks.csv");
            reader = new InputStreamReader(is);
            ieService.syncImport(WikittyImportExportService.FORMAT.CSV, (Reader)reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importClients() throws IOException {
        String[] importFiles;
        this.wikittyClient.storeExtension(new WikittyExtension("Client", "1.0", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name"})));
        this.wikittyClient.storeExtension(new WikittyExtension("Tag", "1.0", WikittyUtil.buildFieldMapExtension((String[])new String[]{"String tags"})));
        WikittyImportExportService ieService = new WikittyImportExportService(this.wikittyClient);
        for (String importFile : importFiles = new String[]{"/csv/importclient.csv", "/csv/importtree.csv", "/csv/importtree2.csv"}) {
            InputStreamReader reader = null;
            try {
                InputStream is = WikittyClientAbstractTest.class.getResourceAsStream(importFile);
                reader = new InputStreamReader(is);
                ieService.syncImport(WikittyImportExportService.FORMAT.CSV, (Reader)reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    static {
        df = DateFormat.getDateInstance(1, Locale.ENGLISH);
        MEDIA_EXTENSION = ExtensionFactory.create((String)MEDIA_EXTENSION_NAME, (String)"6.0").addField("type", WikittyTypes.STRING).extension();
        MOVIE_EXTENSION = ExtensionFactory.create((String)MOVIE_EXTENSION_NAME, (String)"2.0", (String)MEDIA_EXTENSION_NAME).addField("name", WikittyTypes.STRING).addField("authors", WikittyTypes.STRING).maxOccur(Integer.MAX_VALUE).addField("category", WikittyTypes.WIKITTY).addField("date", WikittyTypes.DATE).extension();
    }
}

