/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyCopyOnWrite;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.services.WikittyCache;
import org.nuiton.wikitty.services.WikittyCacheSimple;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;
import org.nuiton.wikitty.services.WikittyServiceDelegator;

public class WikittyServiceCached
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceCached.class);
    protected WikittyCache cache = null;
    protected RemoteWikittyListener remoteWikittyListener;
    protected boolean allwaysRestoreCopies = false;
    protected long asked = 0L;
    protected long missed = 0L;

    public WikittyServiceCached(ApplicationConfig config, WikittyService ws, WikittyCache cache) {
        super(ws);
        this.cache = cache;
        if (cache == null) {
            if (log.isWarnEnabled()) {
                String cacheClassName = config.getOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICECACHED_COMPONENTS.getKey());
                log.warn((Object)String.format("No cache class implementation available (%s), use simple cache", cacheClassName));
            }
            this.cache = new WikittyCacheSimple(config);
        }
        try {
            this.remoteWikittyListener = new RemoteWikittyListener(this);
            this.addWikittyServiceListener(this.remoteWikittyListener, WikittyService.ServiceListenerType.REMOTE);
        }
        catch (UnsupportedOperationException eee) {
            log.warn((Object)"no WikittyServiceNotifier available, cache don't listen event");
        }
        if (config != null) {
            this.allwaysRestoreCopies = config.getOptionAsBoolean(WikittyConfigOption.WIKITTY_CACHE_RESTORE_COPIES.getKey());
        }
    }

    protected void statAdd(int asked, int missed) {
        this.asked += (long)asked;
        this.missed += (long)missed;
        if (log.isDebugEnabled()) {
            String total = StringUtil.convertMemory((long)Runtime.getRuntime().totalMemory());
            String free = StringUtil.convertMemory((long)Runtime.getRuntime().freeMemory());
            String msg = String.format("cache stat (missed/asked): %s/%s (memory %s/%s [total/free])", this.missed, this.asked, total, free);
            log.debug((Object)msg);
        }
    }

    public long getAsked() {
        return this.asked;
    }

    public long getMissed() {
        return this.missed;
    }

    protected Wikitty wrapWikitty(Wikitty wikitty) {
        Wikitty result = null;
        if (wikitty != null) {
            if (this.allwaysRestoreCopies) {
                try {
                    result = wikitty.clone();
                }
                catch (CloneNotSupportedException eee) {
                    log.error((Object)String.format("Cache doesn't work, unable to clone %s", wikitty), (Throwable)eee);
                }
            } else {
                if (wikitty instanceof WikittyCopyOnWrite) {
                    wikitty = ((WikittyCopyOnWrite)wikitty).getTarget();
                }
                result = new WikittyCopyOnWrite(wikitty);
            }
        }
        return result;
    }

    protected void cacheClearWikitty() {
        this.cache.clearWikitty();
    }

    protected void cacheClearExtension() {
        this.cache.clearExtension();
    }

    protected void cachePutWikitty(Wikitty w) {
        if (w != null) {
            Wikitty old;
            if (w instanceof WikittyCopyOnWrite) {
                w = ((WikittyCopyOnWrite)w).getTarget();
            }
            if ((old = this.cache.getWikitty(w.getWikittyId())) == null || WikittyUtil.versionGreaterThan(w.getWikittyVersion(), old.getWikittyVersion())) {
                this.cache.putWikitty(w);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Replace cached wikitty : new version " + w.getWikittyVersion() + " > old version " + (old == null ? null : old.getWikittyVersion())));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Ignoring putWikittyEvent : new version %s < old version %s", w.getWikittyVersion(), old.getWikittyVersion()));
            }
        }
    }

    protected void cachePutExtension(WikittyExtension ext) {
        if (ext != null) {
            if (!this.cache.existsExtension(ext.getId())) {
                this.cache.putExtension(ext);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Replace cached wikitty extension '%s'", ext.getId()));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Ignoring put wikitty extension for '%s'", ext.getId()));
            }
        }
    }

    protected void cachePutWikitty(Collection<Wikitty> wikitties) {
        for (Wikitty w : wikitties) {
            this.cachePutWikitty(w);
        }
    }

    protected void cachePutExtension(Collection<WikittyExtension> wikitties) {
        for (WikittyExtension w : wikitties) {
            this.cachePutExtension(w);
        }
    }

    protected void cacheRemoveWikitty(String id) {
        if (id != null) {
            this.cache.removeWikitty(id);
        }
    }

    protected void cacheRemoveExtension(String extId) {
        if (extId != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove extension from cache " + extId));
            }
            this.cache.removeExtension(extId);
        }
    }

    protected void cacheRemoveWikitty(Collection<String> ids) {
        for (String id : ids) {
            this.cacheRemoveWikitty(id);
        }
    }

    protected void cacheRemoveExtension(Collection<String> extIds) {
        for (String extId : extIds) {
            this.cacheRemoveExtension(extId);
        }
    }

    protected Wikitty cacheGetWikitty(String id) {
        Wikitty result = null;
        if (id != null) {
            result = this.cache.getWikitty(id);
            result = this.wrapWikitty(result);
        }
        return result;
    }

    protected WikittyExtension cacheGetExtensions(String id) {
        WikittyExtension result = null;
        if (id != null) {
            result = this.cache.getExtension(id);
        }
        return result;
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        WikittyEvent result = this.getDelegate().clear(securityToken);
        this.processEvent(result);
        return result;
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        WikittyEvent result = this.getDelegate().delete(securityToken, ids);
        this.processEvent(result);
        return result;
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        return this.getDelegate().getAllExtensionIds(securityToken);
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        return this.getDelegate().getAllExtensionsRequires(securityToken, extensionName);
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        ArrayList<String> notInCache = new ArrayList<String>();
        LinkedHashMap<String, Wikitty> fromCache = new LinkedHashMap<String, Wikitty>();
        for (String id : ids) {
            Wikitty w = this.cacheGetWikitty(id);
            fromCache.put(id, w);
            if (w != null) continue;
            notInCache.add(id);
        }
        if (!notInCache.isEmpty()) {
            List<Wikitty> missingInCache = this.getDelegate().restore(securityToken, notInCache);
            this.cachePutWikitty(missingInCache);
            for (Wikitty w : missingInCache) {
                if (w == null) continue;
                w = this.wrapWikitty(w);
                fromCache.put(w.getWikittyId(), w);
            }
        }
        this.statAdd(ids.size(), notInCache.size());
        return new ArrayList<Wikitty>(fromCache.values());
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyExtension result = this.getDelegate().restoreExtensionLastVersion(securityToken, name);
        this.cachePutExtension(result);
        return result;
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String wikittyId) {
        WikittyEvent result = this.getDelegate().deleteTree(securityToken, wikittyId);
        this.processEvent(result);
        return result;
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        WikittyEvent result = this.getDelegate().store(securityToken, wikitties, force);
        this.processEvent(result);
        return result;
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyEvent result = this.getDelegate().storeExtension(securityToken, exts);
        this.processEvent(result);
        return result;
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        WikittyEvent result = this.getDelegate().deleteExtension(securityToken, extNames);
        this.processEvent(result);
        return result;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        WikittyExtension result = this.getDelegate().restoreExtension(securityToken, id);
        this.cachePutExtension(result);
        return result;
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        return this.getDelegate().restoreVersion(securityToken, wikittyId, version);
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        WikittyEvent result = this.getDelegate().replay(securityToken, events, force);
        this.processEvent(result);
        return result;
    }

    protected void processEvent(WikittyEvent e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache receive event : " + e));
        }
        if (e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_WIKITTY) || e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_EXTENSION)) {
            this.cacheClearWikitty();
            this.cacheClearExtension();
        } else {
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_WIKITTY)) {
                this.cachePutWikitty(e.getWikitties().values());
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_WIKITTY)) {
                this.cacheRemoveWikitty(e.getRemoveDate().keySet());
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_EXTENSION)) {
                this.cachePutExtension(e.getExtensions().values());
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_EXTENSION)) {
                this.cacheRemoveExtension(e.getDeletedExtensions());
            }
        }
    }

    public static class RemoteWikittyListener
    implements WikittyListener {
        protected WikittyServiceCached wsCached;

        public RemoteWikittyListener(WikittyServiceCached wsCached) {
            this.wsCached = wsCached;
        }

        @Override
        public void clearWikitty(WikittyEvent event) {
            this.wsCached.processEvent(event);
        }

        @Override
        public void putWikitty(WikittyEvent event) {
            this.wsCached.processEvent(event);
        }

        @Override
        public void removeWikitty(WikittyEvent event) {
            this.wsCached.processEvent(event);
        }

        @Override
        public void putExtension(WikittyEvent event) {
            this.wsCached.processEvent(event);
        }

        @Override
        public void removeExtension(WikittyEvent event) {
            this.wsCached.processEvent(event);
        }

        @Override
        public void clearExtension(WikittyEvent event) {
            this.wsCached.processEvent(event);
        }
    }
}

