/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.services.WikittyServiceTransaction;

public class ImportTask
implements Runnable {
    private static Log log = LogFactory.getLog(ImportTask.class);
    WikittyClient client;
    protected WikittyImportExportService.FORMAT format;
    protected Reader reader;
    protected ImportExportMethod importerExporter;

    public ImportTask(WikittyClient client, WikittyImportExportService.FORMAT format, Reader reader) {
        this.client = client;
        this.format = format;
        this.reader = reader;
    }

    @Deprecated
    public ImportTask(String securityToken, ApplicationConfig config, WikittyService ws, WikittyImportExportService.FORMAT format, Reader reader) {
        this(new WikittyClient(config, ws, securityToken), format, reader);
    }

    public WikittyClient getClient() {
        return this.client;
    }

    @Override
    public void run() {
        WikittyServiceTransaction tx = new WikittyServiceTransaction(this.client.getConfig(), this.client.getWikittyService());
        tx.setAutoCommit(1000);
        try {
            long time = 0L;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info((Object)("Import in (ms)" + time));
            }
            WikittyClient txClient = new WikittyClient(this.client.getConfig(), tx, this.client.getSecurityToken());
            ImportExportMethod importer = this.format.ieporter();
            importer.importReader(txClient, this.reader);
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info((Object)("Import in (ms)" + time));
            }
            tx.commit(this.client.getSecurityToken(), true);
        }
        catch (Exception eee) {
            tx.rollback(this.client.getSecurityToken());
            throw new WikittyException("Error during import task", eee);
        }
    }
}

