package org.nuiton.wikitty.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class ProductAbstract extends BusinessEntityImpl implements Product {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionProduct;

    private static final long serialVersionUID = 3559029221323138148L;

    @Override
    public String getName() {
String value = ProductHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
ProductHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_NAME, oldValue, getName());
}

    @Override
    public int getPriceFromProduct() {
int value = ProductHelper.getPrice(getWikitty());
return value;
}

    @Override
    public void setPriceFromProduct(int price) {
int oldValue = getPriceFromProduct();
ProductHelper.setPrice(getWikitty(), price);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_PRICE, oldValue, getPriceFromProduct());
}

    @Override
    public Set<String> getColors() {
Set<String> result = ProductHelper.getColors(getWikitty());
return result;
}

    @Override
    public void setColors(Set<String> colors) {
Set<String> oldValue = getColors();
ProductHelper.setColors(getWikitty(), colors);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_COLORS, oldValue, getColors());
}

    @Override
    public void addAllColors(Collection<String> colors) {
Set<String> oldValue = getColors();
ProductHelper.addAllColors(getWikitty(), colors);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_COLORS, oldValue, getColors());
}

    @Override
    public void addColors(String... element) {
Set<String> oldValue = getColors();
ProductHelper.addColors(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_COLORS, oldValue, getColors());
}

    @Override
    public void removeColors(String... element) {
Set<String> oldValue = getColors();
ProductHelper.removeColors(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_COLORS, oldValue, getColors());
}

    @Override
    public void clearColors() {
ProductHelper.clearColors(getWikitty());
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_COLORS, null, getColors());
}

    @Override
    public Date getDate() {
Date value = ProductHelper.getDate(getWikitty());
return value;
}

    @Override
    public void setDate(Date date) {
Date oldValue = getDate();
ProductHelper.setDate(getWikitty(), date);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_DATE, oldValue, getDate());
}

    @Override
    public String getCategory() {
String value = ProductHelper.getCategory(getWikitty());
return value;
}

    @Override
    public void setCategory(String category) {
String oldValue = getCategory();
ProductHelper.setCategory(getWikitty(), category);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_CATEGORY, oldValue, getCategory());
}

    @Override
    public Category getCategory(boolean exceptionIfNotLoaded) {
Category value = ProductHelper.getCategory(getWikitty(), exceptionIfNotLoaded);
return value;
}

    @Override
    public void setCategory(Category category) {
Category oldValue = getCategory(false);
ProductHelper.setCategory(getWikitty(), category);
getPropertyChangeSupport().firePropertyChange(Product.FIELD_PRODUCT_CATEGORY, oldValue, getCategory());
}

    @Override
    public String getPicture() {
String value = ProductPictureHelper.getPicture(getWikitty());
return value;
}

    @Override
    public void setPicture(String picture) {
String oldValue = getPicture();
ProductPictureHelper.setPicture(getWikitty(), picture);
getPropertyChangeSupport().firePropertyChange(ProductPicture.FIELD_PRODUCTPICTURE_PICTURE, oldValue, getPicture());
}

    @Override
    public int getPicturePrice() {
int value = ProductPictureHelper.getPicturePrice(getWikitty());
return value;
}

    @Override
    public void setPicturePrice(int price) {
int oldValue = getPicturePrice();
ProductPictureHelper.setPicturePrice(getWikitty(), price);
getPropertyChangeSupport().firePropertyChange(ProductPicture.FIELD_PRODUCTPICTURE_PRICE, oldValue, getPicturePrice());
}

    @Override
    public String getDocumentation() {
String value = ProductDocumentationHelper.getDocumentation(getWikitty());
return value;
}

    @Override
    public void setDocumentation(String documentation) {
String oldValue = getDocumentation();
ProductDocumentationHelper.setDocumentation(getWikitty(), documentation);
getPropertyChangeSupport().firePropertyChange(ProductDocumentation.FIELD_PRODUCTDOCUMENTATION_DOCUMENTATION, oldValue, getDocumentation());
}

    @Override
    public int getPrice() {
int value = ProductDocumentationHelper.getPrice(getWikitty());
return value;
}

    @Override
    public void setPrice(int price) {
int oldValue = getPrice();
ProductDocumentationHelper.setPrice(getWikitty(), price);
getPropertyChangeSupport().firePropertyChange(ProductDocumentation.FIELD_PRODUCTDOCUMENTATION_PRICE, oldValue, getPrice());
}

    public ProductAbstract() {
        super();
}

    public ProductAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public ProductAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionProduct = new WikittyExtension(EXT_PRODUCT,
                "3.0", // version
                WikittyUtil.tagValuesToMap(" alternativeName.Product.price=\"priceFromProduct\" version=\"3.0\""), // tag/values
                ProductPicture.EXT_PRODUCTPICTURE + "," + ProductDocumentation.EXT_PRODUCTDOCUMENTATION,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name fieldIndex=\"1\"", 
                                             "Numeric price fieldIndex=\"2\"", 
                                             "String colors[0-*] unique=\"true\" fieldIndex=\"3\"", 
                                             "Date date fieldIndex=\"4\"", 
                                             "Wikitty category[0-1] allowed=\"Category\" fieldIndex=\"5\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.addAll(ProductPictureAbstract.extensions); 
        // current after requires ones

        exts.addAll(ProductDocumentationAbstract.extensions); 
        // current after requires ones

        exts.add(extensionProduct);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return ProductHelper.toString(getWikitty());
}

} //ProductAbstract
