/*
 * #%L
 * Wikitty :: api
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;


public  class WikittyTokenHelper {

    /**
     * WikittyTokenHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyTokenHelper() {// empty
}

    /**
     * getUser :
     * @param wikitty 
     * @return String 
     */

    public static String getUser(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER);
        return value;
}

    /**
     * setUser :
     * @param wikitty 
     * @param user 
     * @return String 
     */

    public static String setUser(Wikitty wikitty, String user) {
        String oldValue = getUser(wikitty);
        wikitty.setField(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER, user);
        return oldValue;
}

    /**
     * getDate :
     * @param wikitty 
     * @return Date 
     */

    public static Date getDate(Wikitty wikitty) {
        Date value = wikitty.getFieldAsDate(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE);
        return value;
}

    /**
     * setDate :
     * @param wikitty 
     * @param date 
     * @return Date 
     */

    public static Date setDate(Wikitty wikitty, Date date) {
        Date oldValue = getDate(wikitty);
        wikitty.setField(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE, date);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER);
            Object f2 = w2.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_USER);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE);
            Object f2 = w2.getFieldAsObject(WikittyToken.EXT_WIKITTYTOKEN, WikittyToken.FIELD_WIKITTYTOKEN_DATE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyToken.EXT_WIKITTYTOKEN);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyTokenAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyTokenHelper
