/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import java.net.URL;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.addons.importexport.ImportExportCSV;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;

public class ImportExportCSVTest {
    private static final Log log = LogFactory.getLog(ImportExportCSVTest.class);
    protected static WikittyService ws;
    protected static final WikittyExtension extensionClient;
    protected static final WikittyExtension extensionTag;

    @BeforeClass
    public static void loadWikittyService() throws Exception {
        WikittyConfig config = new WikittyConfig();
        ws = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
    }

    @Before
    public void clearStorage() throws Exception {
        ws.clear(null);
    }

    public WikittyService getWikittyService() {
        return ws;
    }

    public void setWikittyService(WikittyService wikittyService) {
        ws = wikittyService;
    }

    @Test
    public void testQueryPattern() {
        ImportExportCSV task = new ImportExportCSV();
        Pattern pattern = task.queryPattern;
        Matcher m = pattern.matcher("rtet");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client=4e2e4a93-c412-46b8-beb9-e76e0f16740d");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client=4e2e4a93-c412-46b8-beb9-e76e0f16740d");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client.name=toto");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"Client.name", (Object)m.group(1));
        Assert.assertEquals((Object)"Client", (Object)m.group(2));
        Assert.assertEquals((Object)"name", (Object)m.group(3));
        Assert.assertEquals((Object)"toto", (Object)m.group(4));
        m = pattern.matcher("Client.name=toto");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"toto", (Object)m.group(6));
        m = pattern.matcher("Client.name=\"toto\"");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"toto", (Object)m.group(5));
        m = pattern.matcher("Client.name=\"toto");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client.name=\"to\"to\"");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"to\"to", (Object)m.group(5));
        m = pattern.matcher("Client.name=toto\"");
        Assert.assertFalse((boolean)m.find());
    }

    @Test
    public void testMultipleFieldsParsing() {
        String test = "(sdfsdf),(dfsdf),(fdsfsdfg),(sdfsdfqs)";
        String[] result = StringUtil.split((String)test);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertEquals((Object)"(sdfsdf)", (Object)result[0]);
        Assert.assertEquals((Object)"sdfsdf", (Object)result[0].substring(1, result[0].length() - 1));
        Assert.assertEquals((Object)"(dfsdf)", (Object)result[1]);
        Assert.assertEquals((Object)"(fdsfsdfg)", (Object)result[2]);
        Assert.assertEquals((Object)"(sdfsdfqs)", (Object)result[3]);
        test = "(sdf\",\"sdf),(df()sdf),(fds\"(),()\"fsdfg),(sdfsdfqs)";
        result = StringUtil.split((String)test);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertEquals((Object)"(sdf\",\"sdf)", (Object)result[0]);
        Assert.assertEquals((Object)"(df()sdf)", (Object)result[1]);
        Assert.assertEquals((Object)"(fds\"(),()\"fsdfg)", (Object)result[2]);
        Assert.assertEquals((Object)"(sdfsdfqs)", (Object)result[3]);
        test = "toto ?";
        result = StringUtil.split((String)test);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)"toto ?", (Object)result[0]);
    }

    @Test
    public void testImport() {
        String[] importFiles;
        WikittyProxy proxy = new WikittyProxy(ws);
        proxy.storeExtension(extensionClient);
        proxy.storeExtension(WikittyTreeNodeImpl.extensionWikittyTreeNode);
        proxy.storeExtension(extensionTag);
        WikittyConfig config = new WikittyConfig();
        WikittyImportExportService wsImport = new WikittyImportExportService((ApplicationConfig)config, null, ws);
        for (String importFile : importFiles = new String[]{"/csv/importclient.csv", "/csv/importtree.csv", "/csv/importtree2.csv"}) {
            URL importFileURL = ImportExportCSVTest.class.getResource(importFile);
            wsImport.syncImportFromUri(WikittyImportExportService.FORMAT.CSV, importFileURL.toExternalForm());
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, extensionTag.getName()).criteria();
        PagedResult pagedResult = (PagedResult)ws.findAllByCriteria(null, Collections.singletonList(criteria)).get(0);
        Assert.assertEquals((long)1L, (long)pagedResult.getNumFound());
        Criteria criteria2 = Search.query().eq(extensionClient.getName() + ".name", "Toto").criteria();
        PagedResult pagedResult2 = (PagedResult)ws.findAllByCriteria(null, Collections.singletonList(criteria2)).get(0);
        Assert.assertEquals((long)1L, (long)pagedResult2.getNumFound());
        Criteria criteria3 = Search.query().eq("WikittyTreeNode.name", "MyTreeNode").criteria();
        PagedResult pagedResult3 = proxy.findAllByCriteria(WikittyTreeNode.class, criteria3);
        Assert.assertEquals((long)1L, (long)pagedResult3.getNumFound());
        WikittyTreeNode myTreeNode = (WikittyTreeNode)pagedResult3.getFirst();
        Assert.assertEquals((long)1L, (long)myTreeNode.getAttachment().size());
        Criteria criteria4 = Search.query().eq("WikittyTreeNode.parent", myTreeNode.getWikittyId()).criteria();
        PagedResult pagedResult4 = proxy.findAllByCriteria(WikittyTreeNode.class, criteria4);
        Assert.assertEquals((long)1L, (long)pagedResult4.getNumFound());
        WikittyTreeNode mySubNode = (WikittyTreeNode)pagedResult4.getFirst();
        Assert.assertEquals((Object)"MySubNode", (Object)mySubNode.getName());
        try {
            for (String importFile : importFiles) {
                URL importFileURL = ImportExportCSVTest.class.getResource(importFile);
                wsImport.syncImportFromUri(WikittyImportExportService.FORMAT.CSV, importFileURL.toExternalForm());
            }
        }
        catch (WikittyException eee) {
            Assert.fail();
        }
    }

    static {
        extensionClient = new WikittyExtension("Client", "1.0", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String name"}));
        extensionTag = new WikittyExtension("Tag", "1.0", null, WikittyUtil.buildFieldMapExtension((String[])new String[]{"String tags"}));
    }
}

