package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  class WikittyUserHelper {

    /**
     * WikittyUserHelper :
     * utility class all provided methods are accessible the static way
     */

    private WikittyUserHelper() {// empty
}

    /**
     * getLogin :
     * @param wikitty 
     * @return String 
     */

    public static String getLogin(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
        return value;
}

    /**
     * setLogin :
     * @param wikitty 
     * @param login 
     * @return String 
     */

    public static String setLogin(Wikitty wikitty, String login) {
        String oldValue = getLogin(wikitty);
        wikitty.setField(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN, login);
        return oldValue;
}

    /**
     * getPassword :
     * @param wikitty 
     * @return String 
     */

    public static String getPassword(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
        return value;
}

    /**
     * setPassword :
     * @param wikitty 
     * @param password 
     * @return String 
     */

    public static String setPassword(Wikitty wikitty, String password) {
        String oldValue = getPassword(wikitty);
        wikitty.setField(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD, password);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
            Object f2 = w2.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_LOGIN);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
            Object f2 = w2.getFieldAsObject(WikittyUser.EXT_WIKITTYUSER, WikittyUser.FIELD_WIKITTYUSER_PASSWORD);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WikittyUser.EXT_WIKITTYUSER);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WikittyUserAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WikittyUserHelper
