/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: FieldFactory.java 417 2010-10-15 15:24:44Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-2.2.2/wikitty-api/src/main/java/org/nuiton/wikitty/FieldFactory.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty;

import java.util.HashMap;
import java.util.Map;

import org.nuiton.wikitty.FieldType.TYPE;

public class FieldFactory {
    
    protected ExtensionFactory parentFactory;
    protected String fieldName; 
    protected TYPE type;
    protected int minOccur = 0, maxOccur = 1; 
    protected boolean unique = false;
    protected Map<String, String> tagValues = new HashMap<String, String>();
    
    public FieldFactory(ExtensionFactory parentFactory, String fieldName, TYPE type) {
        this.parentFactory = parentFactory;
        this.fieldName = fieldName;
        this.type = type;
    }
    
    public FieldFactory addField(String name, TYPE type) {
        append();
        return parentFactory.addField(name, type);
    }
    
    public WikittyExtension extension() {
        append();
        return parentFactory.extension();
    }
    
    protected void append() {
        FieldType fieldType = new FieldType(type, minOccur, maxOccur);
        for (Map.Entry<String, String> entry : tagValues.entrySet()) {
            String tag = entry.getKey();
            String value = entry.getValue();
            fieldType.addTagValue(tag, value);
        }
        parentFactory.add(fieldName, fieldType);
    }
    
    public FieldFactory maxOccur(int max) {
        maxOccur = max;
        return this;
    }
    
    public FieldFactory minOccur(int min) {
        minOccur = min;
        return this;
    }
    
    public FieldFactory unique() {
        addTagValue(FieldType.UNIQUE, "true");
        return this;
    }

    public FieldFactory notNull() {
        addTagValue(FieldType.NOT_NULL, "true");
        return this;
    }

    public FieldFactory addTagValue(String tag, String value) {
        tagValues.put(tag, value);
        return this;
    }
}
