package org.nuiton.wikitty;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public  abstract class LabelAbstract extends BusinessEntityWikitty implements Label {

    public static final List<WikittyExtension> extensions;
    public static final WikittyExtension extensionLabel;
    /**
     * getLabels :
     * @return Set<String> 
     */

    @Override
    public Set<String> getLabels() {
        Set<String> result = LabelHelper.getLabels(getWikitty());
        return result;
}

    /**
     * addLabels :
     * @param element 
     */

    @Override
    public void addLabels(String element) {
        LabelHelper.addLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Label.FIELD_LABEL_LABELS, null, getLabels());
}

    /**
     * removeLabels :
     * @param element 
     */

    @Override
    public void removeLabels(String element) {
        LabelHelper.removeLabels(getWikitty(), element);
        getPropertyChangeSupport().firePropertyChange(Label.FIELD_LABEL_LABELS, null, getLabels());
}

    /**
     * clearLabels :
     */

    @Override
    public void clearLabels() {
        LabelHelper.clearLabels(getWikitty());
        getPropertyChangeSupport().firePropertyChange(Label.FIELD_LABEL_LABELS, null, getLabels());
}

    /**
     * LabelAbstract :
     */

    public LabelAbstract() {
        super();
}

    /**
     * LabelAbstract :
     * @param wikitty 
     */

    public LabelAbstract(Wikitty wikitty) {
        super(wikitty);
}

    /**
     * LabelAbstract :
     * @param businessEntityWikitty 
     */

    public LabelAbstract(BusinessEntityWikitty businessEntityWikitty) {
        super(businessEntityWikitty.getWikitty());
}

    /**
     * getStaticExtensions :
     * @return Collection<WikittyExtension> 
     */

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

static {
    
        extensionLabel =
                new WikittyExtension(EXT_LABEL,
                                     "1.0", // version
                                     null,
                                     WikittyUtil.buildFieldMapExtension( // building field map
                                             "String labels[0-*] unique=true"));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionLabel);
        extensions = Collections.unmodifiableList(exts);

    }
    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return getWikitty().toString();
}


} //LabelAbstract
